/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.reservoir;

import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import org.unijena.j2k.routing.J2KProcessReachRouting;

@JAMSComponentDescription(title="ManagedDam", author="Sven Kralisch", description="Component for simulation of artificial releases from a dam", date="2021-01-28", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class ManagedDam
extends J2KProcessReachRouting {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Dam release volume at current time step", defaultValue="0", unit="m\u00b3/s", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double releaseVol;

    @Override
    public void run() {
        double addInPart;
        double RG2_part;
        double RG1_part;
        double RD2_part;
        double RD1_part;
        Attribute.Entity entity = this.entities.getCurrent();
        Attribute.Entity DestReach = (Attribute.Entity)entity.getObject("to_reach");
        if (DestReach.isEmpty()) {
            DestReach = null;
        }
        Attribute.Entity DestReservoir = null;
        DestReservoir = entity.existsAttribute("to_reservoir") ? (Attribute.Entity)entity.getObject("to_reservoir") : null;
        double width = this.width.getValue();
        double rough = this.roughness.getValue();
        double length = this.length.getValue();
        double slope = this.slope.getValue();
        if (!this.slopeAsProportion.getValue()) {
            slope /= 100.0;
        }
        double RD1act = this.actRD1.getValue() + this.inRD1.getValue();
        double RD2act = this.actRD2.getValue() + this.inRD2.getValue();
        double RG1act = this.actRG1.getValue() + this.inRG1.getValue();
        double RG2act = this.actRG2.getValue() + this.inRG2.getValue();
        double addInAct = this.actAddIn.getValue() + this.inAddIn.getValue();
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.inAddIn.setValue(0.0);
        this.actRD1.setValue(0.0);
        this.actRD2.setValue(0.0);
        this.actRG1.setValue(0.0);
        this.actRG2.setValue(0.0);
        this.actAddIn.setValue(0.0);
        double RD1DestIn = 0.0;
        double RD2DestIn = 0.0;
        double RG1DestIn = 0.0;
        double RG2DestIn = 0.0;
        double addInDestIn = 0.0;
        if (DestReach == null && DestReservoir == null) {
            RD1DestIn = 0.0;
            RD2DestIn = 0.0;
            RG1DestIn = 0.0;
            RG2DestIn = 0.0;
            addInDestIn = 0.0;
        } else if (DestReservoir != null) {
            RD1DestIn = DestReservoir.getDouble("compRD1");
            RD2DestIn = DestReservoir.getDouble("compRD2");
            RG1DestIn = DestReservoir.getDouble("compRG1");
            RG2DestIn = DestReservoir.getDouble("compRG2");
        } else {
            RD1DestIn = DestReach.getDouble("inRD1");
            RD2DestIn = DestReach.getDouble("inRD2");
            RG1DestIn = DestReach.getDouble("inRG1");
            RG2DestIn = DestReach.getDouble("inRG2");
            try {
                addInDestIn = DestReach.getDouble("inAddIn");
            }
            catch (Attribute.Entity.NoSuchAttributeException e) {
                addInDestIn = 0.0;
            }
        }
        double q_act_tot = RD1act + RD2act + RG1act + RG2act + addInAct;
        if (q_act_tot == 0.0) {
            RD1_part = RD1act / q_act_tot;
            RD2_part = RD2act / q_act_tot;
            RG1_part = RG1act / q_act_tot;
            RG2_part = RG2act / q_act_tot;
            addInPart = addInAct / q_act_tot;
        } else {
            RD1_part = 0.25;
            RD2_part = 0.25;
            RG1_part = 0.25;
            RG2_part = 0.25;
            addInPart = 0.0;
        }
        double q_act_out = this.releaseVol.getValue();
        double RD1out = q_act_out * RD1_part;
        double RD2out = q_act_out * RD2_part;
        double RG1out = q_act_out * RG1_part;
        double RG2out = q_act_out * RG2_part;
        double addInOut = q_act_out * addInPart;
        RD1DestIn += RD1out;
        RD2DestIn += RD2out;
        RG1DestIn += RG1out;
        RG2DestIn += RG2out;
        addInDestIn += addInOut;
        double channelStorage = (RD1act -= q_act_out * RD1_part) + (RD2act -= q_act_out * RD2_part) + (RG1act -= q_act_out * RG1_part) + (RG2act -= q_act_out * RG2_part) + (addInAct -= q_act_out * addInPart);
        double cumOutflow = RD1out + RD2out + RG1out + RG2out + addInOut;
        this.simRunoff.setValue(cumOutflow);
        this.channelStorage.setValue(channelStorage);
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.inAddIn.setValue(0.0);
        this.actRD1.setValue(RD1act);
        this.actRD2.setValue(RD2act);
        this.actRG1.setValue(RG1act);
        this.actRG2.setValue(RG2act);
        this.actAddIn.setValue(addInAct);
        this.outRD1.setValue(RD1out);
        this.outRD2.setValue(RD2out);
        this.outRG1.setValue(RG1out);
        this.outRG2.setValue(RG2out);
        this.outAddIn.setValue(addInOut);
        if (DestReach != null && DestReservoir == null) {
            DestReach.setDouble("inRD1", RD1DestIn);
            DestReach.setDouble("inRD2", RD2DestIn);
            DestReach.setDouble("inRG1", RG1DestIn);
            DestReach.setDouble("inRG2", RG2DestIn);
            DestReach.setDouble("inAddIn", addInDestIn);
        } else if (DestReservoir != null) {
            DestReservoir.setDouble("compRD1", RD1DestIn);
            DestReservoir.setDouble("compRD2", RD2DestIn);
            DestReservoir.setDouble("compRG1", RG1DestIn);
            DestReservoir.setDouble("compRG2", RG2DestIn);
        } else if (DestReach == null && DestReservoir == null) {
            this.catchmentRD1.setValue(RD1out);
            this.catchmentRD2.setValue(RD2out);
            this.catchmentRG1.setValue(RG1out);
            this.catchmentRG2.setValue(RG2out);
            this.catchmentAddIn.setValue(addInOut);
            this.catchmentSimRunoff.setValue(cumOutflow);
        }
        this.waterLevel.setValue(channelStorage / (1000.0 * width * length));
    }
}

