/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.mathematicalCalculations.MathematicalCalculations;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.HourlySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;

@JAMSComponentDescription(title="CalcAdditionalHRUAttribs", author="Peter Krause", description="Calculates additional attributes from existent ones")
public class CalcUniformExtraterrRadiation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity latidute [deg]")
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity longitude [deg]")
    public Attribute.Double longitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="longitude of time zone [deg]")
    public Attribute.Double longTZ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="location from Greenwich [w | e]")
    public Attribute.String locGrw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="extraterrestric radiation of each time step of the year [MJ/m\u00b2 timeUnit]")
    public Attribute.DoubleArray extRadArray;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};
    double[] extRadiation = null;

    public void init() {
        if (this.tempRes.getValue().equals("d")) {
            this.extRadiation = new double[366];
        } else if (this.tempRes.getValue().equals("h")) {
            this.extRadiation = new double[8784];
        } else if (this.tempRes.getValue().equals("m")) {
            this.extRadiation = new double[12];
        }
        double lati = this.latitude.getValue();
        double longi = this.longitude.getValue();
        double longiTZ = this.longTZ.getValue();
        if (this.locGrw.getValue().equals("e")) {
            longi = 360.0 - longi;
            longiTZ = 360.0 - longiTZ;
        }
        double latRad = MathematicalCalculations.deg2rad(lati);
        Attribute.Calendar time = this.getModel().getRuntime().getDataFactory().createCalendar();
        time.set(2000, 0, 1, 0, 0, 0);
        if (this.tempRes.getValue().equals("m")) {
            for (int i = 0; i < 12; ++i) {
                double declination = SolarRadiationCalculationMethods.calc_SunDeclination(this.monthMean[i]);
                double solarConstant = SolarRadiationCalculationMethods.calc_SolarConstant(this.monthMean[i]);
                double invRelDistEarthSun = SolarRadiationCalculationMethods.calc_InverseRelativeDistanceEarthSun(this.monthMean[i]);
                double sunsetHourAngle = DailySolarRadiationCalculationMethods.calc_SunsetHourAngle(latRad, declination);
                this.extRadiation[i] = DailySolarRadiationCalculationMethods.calc_DailyExtraterrestrialRadiation(solarConstant, invRelDistEarthSun, sunsetHourAngle, latRad, declination);
            }
        } else {
            for (int i = 0; i < 366; ++i) {
                int julDay = i + 1;
                double declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
                double solarConstant = SolarRadiationCalculationMethods.calc_SolarConstant(julDay);
                double invRelDistEarthSun = SolarRadiationCalculationMethods.calc_InverseRelativeDistanceEarthSun(julDay);
                if (this.tempRes.getValue().equals("d")) {
                    double sunsetHourAngle = DailySolarRadiationCalculationMethods.calc_SunsetHourAngle(latRad, declination);
                    this.extRadiation[i] = DailySolarRadiationCalculationMethods.calc_DailyExtraterrestrialRadiation(solarConstant, invRelDistEarthSun, sunsetHourAngle, latRad, declination);
                    continue;
                }
                if (!this.tempRes.getValue().equals("h")) continue;
                for (int hour = 0; hour < 24; ++hour) {
                    double midTimeHourAngle = HourlySolarRadiationCalculationMethods.calc_midTimeHourAngle(hour, julDay, longi, longiTZ, false);
                    double startTimeHourAngle = HourlySolarRadiationCalculationMethods.calc_startTimeHourAngle(midTimeHourAngle);
                    double endTimeHourAngle = HourlySolarRadiationCalculationMethods.calc_endTimeHourAngle(midTimeHourAngle);
                    int idx = i * 24 + hour;
                    this.extRadiation[idx] = HourlySolarRadiationCalculationMethods.calc_HourlyExtraterrestrialRadiation(solarConstant, invRelDistEarthSun, startTimeHourAngle, endTimeHourAngle, latRad, declination);
                }
            }
        }
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        this.extRadArray.setValue(this.extRadiation);
    }

    public void cleanup() {
    }
}

