/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.potET;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;

@JAMSComponentDescription(title="CalcDailyETP_Haude", author="Peter Krause", description="Calculates daily potential ETP after Penman-Monteith")
public class Haude
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable maximum temperature")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable relative humidity")
    public Attribute.Double rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable haude factor")
    public Attribute.Double haudeFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily potential ETP [mm/d]")
    public Attribute.Double pET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily actual ETP [mm/d]")
    public Attribute.Double aET;

    public void init() throws Attribute.Entity.NoSuchAttributeException, IOException {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        double tmeanVal = this.tmean.getValue();
        double tmaxVal = this.tmax.getValue();
        double rhumVal = this.rhum.getValue();
        double areaVal = this.area.getValue();
        double h_factor = this.haudeFactor.getValue();
        double est = ClimatologicalVariables.calc_saturationVapourPressure(tmeanVal);
        est = 10.0 * est;
        double maxHum = est * 216.7 / (tmeanVal + 273.15);
        double ahumVal = maxHum * (rhumVal / 100.0);
        est = ClimatologicalVariables.calc_saturationVapourPressure(tmaxVal);
        est = 10.0 * est;
        maxHum = est * 216.7 / (tmaxVal + 273.15);
        rhumVal = ahumVal / maxHum * 100.0;
        double pETP = est * (1.0 - rhumVal / 100.0) * h_factor;
        double aETP = 0.0;
        if ((pETP *= areaVal) < 0.0) {
            pETP = 0.0;
        }
        this.pET.setValue(pETP);
        this.aET.setValue(aETP);
    }

    public void cleanup() throws IOException {
    }
}

