/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.potET;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;

@JAMSComponentDescription(title="CalcPotentialETSamani", author="Peter Krause", version="1.0_1", description="Calculates potential ET according to Hargreaves Samani")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version", date="2011-05-30"), @VersionComments.Entry(version="1.0_1", comment="Corrected description of units of potET/actET", date="2018-07-04")})
public class HargreavesSamani
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | m]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable minimum air temperature", unit="degC")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature", unit="degC")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable maximum air temperature", unit="degC")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable extraterrestrial radiation", unit="MJ m^-2 day^-1")
    public Attribute.Double extRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="potential ET", unit="L")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actual ET", unit="L")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Caching configuration: 0 - write cache, 1 - use cache, 2 - caching off", defaultValue="0")
    public Attribute.Integer dataCaching;
    private File cacheFile;
    private transient ObjectOutputStream writer;
    private transient ObjectInputStream reader;

    public void init() throws Attribute.Entity.NoSuchAttributeException, IOException {
        this.cacheFile = new File(this.getModel().getWorkspace().getTempDirectory(), this.getInstanceName() + ".cache");
        if (!this.cacheFile.exists() && this.dataCaching.getValue() == 1) {
            this.getModel().getRuntime().sendHalt(this.getInstanceName() + ": dataCaching is true but no cache file available!");
        }
        if (this.dataCaching.getValue() == 1) {
            this.reader = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
        } else if (this.dataCaching.getValue() == 0) {
            this.writer = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));
        }
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        if (this.dataCaching.getValue() == 1) {
            this.potET.setValue(this.reader.readDouble());
        } else {
            double extRad = this.extRad.getValue();
            double tmin = this.tmin.getValue();
            double tavg = this.tmean.getValue();
            double tmax = this.tmax.getValue();
            double area = this.area.getValue();
            double latH = ClimatologicalVariables.calc_latentHeatOfVaporization(tavg);
            double pET = 0.0;
            double aET = 0.0;
            pET = 0.0023 * extRad * Math.sqrt(tmax - tmin) * (tavg + 17.8) / latH;
            pET *= area;
            if (this.time != null && this.tempRes.getValue().equals("m")) {
                int daysInMonth = this.time.getActualMaximum(5);
                pET *= (double)daysInMonth;
            }
            if (pET < 0.0) {
                pET = 0.0;
            }
            this.potET.setValue(pET);
            this.actET.setValue(aET);
            if (this.dataCaching.getValue() == 0) {
                this.writer.writeDouble(pET);
            }
        }
    }

    public void cleanup() throws IOException {
        if (this.dataCaching.getValue() == 0) {
            this.writer.flush();
            this.writer.close();
        } else if (this.dataCaching.getValue() == 1) {
            this.reader.close();
        }
    }
}

