/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="DewPoint2RelativeHumidity", author="Sven Kralisch", description="Approximation of relative humidity from dew point, taken from https://en.wikipedia.org/wiki/Dew_point", date="2018-01-25", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Muliplied rhum value by 100 to get \"%\"")})
public class DewPoint2RelativeHumidity
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description", unit="\u00b0C")
    public Attribute.Double dewPoint;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description", unit="\u00b0C")
    public Attribute.Double temp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Description", unit="%")
    public Attribute.Double rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="0: Magnus formula; 1: Simple approximation", defaultValue="0")
    public Attribute.Integer mode;

    public void init() {
    }

    public void run() {
        switch (this.mode.getValue()) {
            case 0: {
                double b = 17.67;
                double c = 243.5;
                double d = this.dewPoint.getValue();
                double T = this.temp.getValue();
                double h = Math.exp(d * b / (c + d) - b * T / (c + T));
                this.rhum.setValue(h * 100.0);
                break;
            }
            case 1: {
                this.rhum.setValue(100.0 - 5.0 * (this.temp.getValue() - this.dewPoint.getValue()));
                break;
            }
            default: {
                this.getModel().getRuntime().sendHalt("You must set a valid mode value!");
            }
        }
    }

    public void cleanup() {
    }
}

