/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.groundwater;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KGroundwater", author="Peter Krause", description="A two-component groundwater module", version="1.0_1", date="2013-04-26")
public class J2KProcessGroundwater_
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area", unit="m\u00b2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute slope", unit="deg")
    public Attribute.Double slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="maximum RG1 storage", unit="L")
    public Attribute.Double maxRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="maximum RG2 storage", unit="L")
    public Attribute.Double maxRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="hru attribute", unit="mm")
    public Attribute.Double RG1_max;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="hru attribute", unit="mm")
    public Attribute.Double RG2_max;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="recision coefficient k RG1 for one time step", lowerBound=1.0, upperBound=500.0, defaultValue="10.0")
    public Attribute.Double kRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="recision coefficient k RG2 for one time step", lowerBound=1.0, upperBound=700.0, defaultValue="10.0")
    public Attribute.Double kRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="actual RG1 storage", unit="L")
    public Attribute.Double actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="actual RG2 storage", unit="L")
    public Attribute.Double actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG1 inflow", unit="L")
    public Attribute.Double inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG2 inflow", unit="L")
    public Attribute.Double inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RG1 outflow", unit="L")
    public Attribute.Double outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RG2 outflow", unit="L")
    public Attribute.Double outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RG1 generation", unit="L")
    public Attribute.Double genRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RG2 generation", unit="L")
    public Attribute.Double genRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="percolation for one time step", unit="L")
    public Attribute.Double percolation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="gwExcess", unit="L")
    public Attribute.Double gwExcess;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum soil storage", unit="L")
    public Attribute.Double maxSoilStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="actual soil storage", unit="L")
    public Attribute.Double actSoilStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="RG1 correction factor", lowerBound=0.0, upperBound=10.0, defaultValue="1.0")
    public Attribute.Double gwRG1Fact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="RG2 correction factor", lowerBound=0.0, upperBound=10.0, defaultValue="1.0")
    public Attribute.Double gwRG2Fact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="RG1 RG2 distribution factor", lowerBound=0.0, upperBound=10.0, defaultValue="1.0")
    public Attribute.Double gwRG1RG2dist;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="capilary rise factor", lowerBound=0.0, upperBound=10.0, defaultValue="0.0")
    public Attribute.Double gwCapRise;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="relative initial RG1 storage", lowerBound=0.0, upperBound=1.0, unit="n/a", defaultValue="0.0")
    public Attribute.Double initRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="relative initial RG2 storage", lowerBound=0.0, upperBound=1.0, unit="n/a", defaultValue="0.0")
    public Attribute.Double initRG2;
    double run_maxRG1;
    double run_maxRG2;
    double run_actRG1;
    double run_actRG2;
    double run_inRG1;
    double run_inRG2;
    double run_outRG1;
    double run_outRG2;
    double run_genRG1;
    double run_genRG2;
    double run_k_RG1;
    double run_k_RG2;
    double run_RG1_rec;
    double run_RG2_rec;
    double run_maxSoilStor;
    double run_actSoilStor;
    double run_slope;
    double run_percolation;
    double run_gwExcess;

    public void initAll() {
        this.maxRG1.setValue(this.RG1_max.getValue() * this.area.getValue());
        this.maxRG2.setValue(this.RG2_max.getValue() * this.area.getValue());
        this.actRG1.setValue(this.maxRG1.getValue() * this.initRG1.getValue());
        this.actRG2.setValue(this.maxRG2.getValue() * this.initRG2.getValue());
    }

    public void run() {
        this.run_maxRG1 = this.maxRG1.getValue();
        this.run_maxRG2 = this.maxRG2.getValue();
        this.run_actRG1 = this.actRG1.getValue();
        this.run_actRG2 = this.actRG2.getValue();
        this.run_inRG1 = this.inRG1.getValue();
        this.run_inRG2 = this.inRG2.getValue();
        this.run_maxSoilStor = this.maxSoilStorage.getValue();
        this.run_actSoilStor = this.actSoilStorage.getValue();
        this.run_percolation = this.percolation.getValue();
        this.run_gwExcess = this.gwExcess.getValue();
        this.run_outRG1 = 0.0;
        this.run_outRG2 = 0.0;
        this.run_genRG1 = 0.0;
        this.run_genRG2 = 0.0;
        this.run_k_RG1 = this.kRG1.getValue();
        this.run_k_RG2 = this.kRG2.getValue();
        this.run_RG1_rec = this.run_k_RG1 * this.gwRG1Fact.getValue();
        this.run_RG2_rec = this.run_k_RG2 * this.gwRG2Fact.getValue();
        this.run_slope = this.slope.getValue();
        this.replenishSoilStor();
        this.redistRG1_RG2_in();
        this.distRG1_RG2();
        this.calcLinGWout();
        this.actRG1.setValue(this.run_actRG1);
        this.actRG2.setValue(this.run_actRG2);
        this.outRG1.setValue(this.run_outRG1);
        this.outRG2.setValue(this.run_outRG2);
        this.genRG1.setValue(this.run_genRG1);
        this.genRG2.setValue(this.run_genRG2);
        this.inRG1.setValue(this.run_inRG1);
        this.inRG2.setValue(this.run_inRG2);
        this.gwExcess.setValue(this.run_gwExcess);
        this.actSoilStorage.setValue(this.run_actSoilStor);
    }

    public void cleanup() {
    }

    public boolean replenishSoilStor() {
        double deltaSoilStor = this.run_maxSoilStor - this.run_actSoilStor;
        double sat_SoilStor = 0.0;
        double inSoilStor = 0.0;
        sat_SoilStor = this.run_actSoilStor > 0.0 && this.run_maxSoilStor > 0.0 ? this.run_actSoilStor / this.run_maxSoilStor : 1.0E-6;
        if (this.run_actRG2 > deltaSoilStor) {
            double alpha = this.gwCapRise.getValue();
            if (alpha < 0.0) {
                alpha = 0.0;
            }
            inSoilStor = deltaSoilStor * (1.0 - Math.exp(-1.0 * alpha / sat_SoilStor));
        }
        if (this.run_actRG2 >= inSoilStor) {
            this.run_actSoilStor += inSoilStor;
            this.run_actRG2 -= inSoilStor;
        } else {
            this.run_actSoilStor += this.run_actRG2;
            this.run_actRG2 = 0.0;
        }
        return true;
    }

    private boolean redistRG1_RG2_in() {
        if (this.run_inRG1 > 0.0) {
            double deltaRG1 = this.run_maxRG1 - this.run_actRG1;
            if (this.run_inRG1 <= deltaRG1) {
                this.run_actRG1 += this.run_inRG1;
                this.run_inRG1 = 0.0;
            } else {
                this.run_actRG1 = this.run_maxRG1;
                this.run_outRG1 = this.run_outRG1 + this.run_inRG1 - deltaRG1;
                this.run_inRG1 = 0.0;
            }
        }
        if (this.run_inRG2 > 0.0) {
            double deltaRG2 = this.run_maxRG2 - this.run_actRG2;
            if (this.run_inRG2 <= deltaRG2) {
                this.run_actRG2 += this.run_inRG2;
                this.run_inRG2 = 0.0;
            } else {
                this.run_actRG2 = this.run_maxRG2;
                this.run_outRG2 = this.run_outRG2 + this.run_inRG2 - deltaRG2;
                this.run_inRG2 = 0.0;
            }
        }
        return true;
    }

    private boolean distRG1_RG2() {
        double delta_RG1;
        double slope_weight = Math.tan(this.run_slope * (Math.PI / 180));
        double gradh = (1.0 - slope_weight) * this.gwRG1RG2dist.getValue();
        if (gradh < 0.0) {
            gradh = 0.0;
        } else if (gradh > 1.0) {
            gradh = 1.0;
        }
        double pot_RG1 = (1.0 - gradh) * this.run_percolation;
        double pot_RG2 = gradh * this.run_percolation;
        this.run_actRG1 += pot_RG1;
        this.run_actRG2 += pot_RG2;
        double delta_RG2 = this.run_actRG2 - this.run_maxRG2;
        if (delta_RG2 > 0.0) {
            this.run_actRG1 += delta_RG2;
            this.run_actRG2 = this.run_maxRG2;
        }
        if ((delta_RG1 = this.run_actRG1 - this.run_maxRG1) > 0.0) {
            this.run_gwExcess += delta_RG1;
            this.run_actRG1 = this.run_maxRG1;
        }
        if (delta_RG1 > 0.0) {
            // empty if block
        }
        return true;
    }

    private boolean calcLinGWout() {
        double k_rg1 = 1.0 / this.run_RG1_rec;
        if (k_rg1 > 1.0) {
            k_rg1 = 1.0;
        }
        double rg1_out = k_rg1 * this.run_actRG1;
        this.run_actRG1 -= rg1_out;
        this.run_outRG1 += rg1_out;
        double k_rg2 = 1.0 / this.run_RG2_rec;
        if (k_rg2 > 1.0) {
            k_rg2 = 1.0;
        }
        double rg2_out = k_rg2 * this.run_actRG2;
        this.run_actRG2 -= rg2_out;
        this.run_outRG2 += rg2_out;
        this.run_genRG1 = rg1_out;
        this.run_genRG2 = rg2_out;
        return true;
    }
}

