/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.PrintStream;
import java.io.PrintWriter;

public class XPathException
extends Exception {
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("cause", Throwable.class)};
    private static final long serialVersionUID = -1837080260374986980L;

    public XPathException(String string) {
        super(string);
        if (string == null) {
            throw new NullPointerException("message can't be null");
        }
    }

    public XPathException(Throwable throwable) {
        super(throwable);
        if (throwable == null) {
            throw new NullPointerException("cause can't be null");
        }
    }

    @Override
    public Throwable getCause() {
        return super.getCause();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("cause", super.getCause());
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Throwable throwable = (Throwable)getField.get("cause", null);
        if (super.getCause() == null && throwable != null) {
            try {
                super.initCause(throwable);
            }
            catch (IllegalStateException illegalStateException) {
                throw new InvalidClassException("Inconsistent state: two causes");
            }
        }
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        if (this.getCause() != null) {
            this.getCause().printStackTrace(printStream);
            printStream.println("--------------- linked to ------------------");
        }
        super.printStackTrace(printStream);
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.getCause() != null) {
            this.getCause().printStackTrace(printWriter);
            printWriter.println("--------------- linked to ------------------");
        }
        super.printStackTrace(printWriter);
    }
}

