/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.sax;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.Encoder;
import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.util.LocalNameQualifiedNamesMap;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetException;
import com.sun.xml.internal.org.jvnet.fastinfoset.sax.EncodingAlgorithmAttributes;
import com.sun.xml.internal.org.jvnet.fastinfoset.sax.FastInfosetWriter;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXDocumentSerializer
extends Encoder
implements FastInfosetWriter {
    protected boolean _elementHasNamespaces = false;
    protected boolean _charactersAsCDATA = false;

    protected SAXDocumentSerializer(boolean bl) {
        super(bl);
    }

    public SAXDocumentSerializer() {
    }

    @Override
    public void reset() {
        super.reset();
        this._elementHasNamespaces = false;
        this._charactersAsCDATA = false;
    }

    @Override
    public final void startDocument() throws SAXException {
        try {
            this.reset();
            this.encodeHeader(false);
            this.encodeInitialVocabulary();
        }
        catch (IOException iOException) {
            throw new SAXException("startDocument", iOException);
        }
    }

    @Override
    public final void endDocument() throws SAXException {
        try {
            this.encodeDocumentTermination();
        }
        catch (IOException iOException) {
            throw new SAXException("endDocument", iOException);
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        try {
            if (!this._elementHasNamespaces) {
                this.encodeTermination();
                this.mark();
                this._elementHasNamespaces = true;
                this.write(56);
            }
            this.encodeNamespaceAttribute(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException("startElement", iOException);
        }
    }

    @Override
    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n = attributes != null && attributes.getLength() > 0 ? this.countAttributes(attributes) : 0;
        try {
            if (this._elementHasNamespaces) {
                this._elementHasNamespaces = false;
                if (n > 0) {
                    int n2 = this._markIndex;
                    this._octetBuffer[n2] = (byte)(this._octetBuffer[n2] | 0x40);
                }
                this.resetMark();
                this.write(240);
                this._b = 0;
            } else {
                this.encodeTermination();
                this._b = 0;
                if (n > 0) {
                    this._b |= 0x40;
                }
            }
            this.encodeElement(string, string3, string2);
            if (n > 0) {
                this.encodeAttributes(attributes);
            }
        }
        catch (IOException iOException) {
            throw new SAXException("startElement", iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException("startElement", fastInfosetException);
        }
    }

    @Override
    public final void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.encodeElementTermination();
        }
        catch (IOException iOException) {
            throw new SAXException("endElement", iOException);
        }
    }

    @Override
    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        if (this.getIgnoreWhiteSpaceTextContent() && SAXDocumentSerializer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        try {
            this.encodeTermination();
            if (!this._charactersAsCDATA) {
                this.encodeCharacters(cArray, n, n2);
            } else {
                this.encodeCIIBuiltInAlgorithmDataAsCDATA(cArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public final void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.getIgnoreWhiteSpaceTextContent()) {
            return;
        }
        this.characters(cArray, n, n2);
    }

    @Override
    public final void processingInstruction(String string, String string2) throws SAXException {
        try {
            if (this.getIgnoreProcesingInstructions()) {
                return;
            }
            if (string.length() == 0) {
                throw new SAXException(CommonResourceBundle.getInstance().getString("message.processingInstructionTargetIsEmpty"));
            }
            this.encodeTermination();
            this.encodeProcessingInstruction(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException("processingInstruction", iOException);
        }
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void skippedEntity(String string) throws SAXException {
    }

    @Override
    public final void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.getIgnoreComments()) {
                return;
            }
            this.encodeTermination();
            this.encodeComment(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException("startElement", iOException);
        }
    }

    @Override
    public final void startCDATA() throws SAXException {
        this._charactersAsCDATA = true;
    }

    @Override
    public final void endCDATA() throws SAXException {
        this._charactersAsCDATA = false;
    }

    @Override
    public final void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.getIgnoreDTD()) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeDocumentTypeDeclaration(string2, string3);
            this.encodeElementTermination();
        }
        catch (IOException iOException) {
            throw new SAXException("startDTD", iOException);
        }
    }

    @Override
    public final void endDTD() throws SAXException {
    }

    @Override
    public final void startEntity(String string) throws SAXException {
    }

    @Override
    public final void endEntity(String string) throws SAXException {
    }

    @Override
    public final void octets(String string, int n, byte[] byArray, int n2, int n3) throws SAXException {
        if (n3 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeNonIdentifyingStringOnThirdBit(string, n, byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public final void object(String string, int n, Object object) throws SAXException {
        try {
            this.encodeTermination();
            this.encodeNonIdentifyingStringOnThirdBit(string, n, object);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public final void bytes(byte[] byArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIOctetAlgorithmData(1, byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public final void shorts(short[] sArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(2, sArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public final void ints(int[] nArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(3, nArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public final void longs(long[] lArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(4, lArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public final void booleans(boolean[] blArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(5, blArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public final void floats(float[] fArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(6, fArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public final void doubles(double[] dArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(7, dArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public void uuids(long[] lArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(8, lArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public void numericCharacters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            boolean bl = this.isCharacterContentChunkLengthMatchesLimit(n2);
            this.encodeNumericFourBitCharacters(cArray, n, n2, bl);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public void dateTimeCharacters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            boolean bl = this.isCharacterContentChunkLengthMatchesLimit(n2);
            this.encodeDateTimeFourBitCharacters(cArray, n, n2, bl);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public void alphabetCharacters(String string, char[] cArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            boolean bl = this.isCharacterContentChunkLengthMatchesLimit(n2);
            this.encodeAlphabetCharacters(string, cArray, n, n2, bl);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2, boolean bl) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        if (this.getIgnoreWhiteSpaceTextContent() && SAXDocumentSerializer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        try {
            this.encodeTermination();
            if (!this._charactersAsCDATA) {
                this.encodeNonIdentifyingStringOnThirdBit(cArray, n, n2, this._v.characterContentChunk, bl, true);
            } else {
                this.encodeCIIBuiltInAlgorithmDataAsCDATA(cArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new SAXException(fastInfosetException);
        }
    }

    protected final int countAttributes(Attributes attributes) {
        int n = 0;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getURI(i);
            if (string == "http://www.w3.org/2000/xmlns/" || string.equals("http://www.w3.org/2000/xmlns/")) continue;
            ++n;
        }
        return n;
    }

    protected void encodeAttributes(Attributes attributes) throws IOException, FastInfosetException {
        if (attributes instanceof EncodingAlgorithmAttributes) {
            EncodingAlgorithmAttributes encodingAlgorithmAttributes = (EncodingAlgorithmAttributes)attributes;
            for (int i = 0; i < encodingAlgorithmAttributes.getLength(); ++i) {
                if (!this.encodeAttribute(attributes.getURI(i), attributes.getQName(i), attributes.getLocalName(i))) continue;
                Object object = encodingAlgorithmAttributes.getAlgorithmData(i);
                if (object == null) {
                    String string = encodingAlgorithmAttributes.getValue(i);
                    boolean bl = this.isAttributeValueLengthMatchesLimit(string.length());
                    boolean bl2 = encodingAlgorithmAttributes.getToIndex(i);
                    String string2 = encodingAlgorithmAttributes.getAlpababet(i);
                    if (string2 == null) {
                        this.encodeNonIdentifyingStringOnFirstBit(string, this._v.attributeValue, bl, bl2);
                        continue;
                    }
                    if (string2 == "0123456789-:TZ ") {
                        this.encodeDateTimeNonIdentifyingStringOnFirstBit(string, bl, bl2);
                        continue;
                    }
                    if (string2 == "0123456789-+.E ") {
                        this.encodeNumericNonIdentifyingStringOnFirstBit(string, bl, bl2);
                        continue;
                    }
                    this.encodeNonIdentifyingStringOnFirstBit(string, this._v.attributeValue, bl, bl2);
                    continue;
                }
                this.encodeNonIdentifyingStringOnFirstBit(encodingAlgorithmAttributes.getAlgorithmURI(i), encodingAlgorithmAttributes.getAlgorithmIndex(i), object);
            }
        } else {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!this.encodeAttribute(attributes.getURI(i), attributes.getQName(i), attributes.getLocalName(i))) continue;
                String string = attributes.getValue(i);
                boolean bl = this.isAttributeValueLengthMatchesLimit(string.length());
                this.encodeNonIdentifyingStringOnFirstBit(string, this._v.attributeValue, bl, false);
            }
        }
        this._b = 240;
        this._terminate = true;
    }

    protected void encodeElement(String string, String string2, String string3) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.elementName.obtainEntry(string2);
        if (entry._valueIndex > 0) {
            QualifiedName[] qualifiedNameArray = entry._value;
            for (int i = 0; i < entry._valueIndex; ++i) {
                QualifiedName qualifiedName = qualifiedNameArray[i];
                if (string != qualifiedName.namespaceName && !string.equals(qualifiedName.namespaceName)) continue;
                this.encodeNonZeroIntegerOnThirdBit(qualifiedNameArray[i].index);
                return;
            }
        }
        this.encodeLiteralElementQualifiedNameOnThirdBit(string, SAXDocumentSerializer.getPrefixFromQualifiedName(string2), string3, entry);
    }

    protected boolean encodeAttribute(String string, String string2, String string3) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.attributeName.obtainEntry(string2);
        if (entry._valueIndex > 0) {
            QualifiedName[] qualifiedNameArray = entry._value;
            for (int i = 0; i < entry._valueIndex; ++i) {
                if (string != qualifiedNameArray[i].namespaceName && !string.equals(qualifiedNameArray[i].namespaceName)) continue;
                this.encodeNonZeroIntegerOnSecondBitFirstBitZero(qualifiedNameArray[i].index);
                return true;
            }
        }
        return this.encodeLiteralAttributeQualifiedNameOnSecondBit(string, SAXDocumentSerializer.getPrefixFromQualifiedName(string2), string3, entry);
    }
}

