/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import com.sun.org.apache.bcel.internal.classfile.EnumElementValue;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ElementValueGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import java.io.DataOutputStream;
import java.io.IOException;

public class EnumElementValueGen
extends ElementValueGen {
    private int typeIdx;
    private int valueIdx;

    protected EnumElementValueGen(int n, int n2, ConstantPoolGen constantPoolGen) {
        super(101, constantPoolGen);
        if (super.getElementValueType() != 101) {
            throw new RuntimeException("Only element values of type enum can be built with this ctor - type specified: " + super.getElementValueType());
        }
        this.typeIdx = n;
        this.valueIdx = n2;
    }

    @Override
    public ElementValue getElementValue() {
        System.err.println("Duplicating value: " + this.getEnumTypeString() + ":" + this.getEnumValueString());
        return new EnumElementValue(super.getElementValueType(), this.typeIdx, this.valueIdx, this.getConstantPool().getConstantPool());
    }

    public EnumElementValueGen(ObjectType objectType, String string, ConstantPoolGen constantPoolGen) {
        super(101, constantPoolGen);
        this.typeIdx = constantPoolGen.addUtf8(objectType.getSignature());
        this.valueIdx = constantPoolGen.addUtf8(string);
    }

    public EnumElementValueGen(EnumElementValue enumElementValue, ConstantPoolGen constantPoolGen, boolean bl) {
        super(101, constantPoolGen);
        if (bl) {
            this.typeIdx = constantPoolGen.addUtf8(enumElementValue.getEnumTypeString());
            this.valueIdx = constantPoolGen.addUtf8(enumElementValue.getEnumValueString());
        } else {
            this.typeIdx = enumElementValue.getTypeIndex();
            this.valueIdx = enumElementValue.getValueIndex();
        }
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getElementValueType());
        dataOutputStream.writeShort(this.typeIdx);
        dataOutputStream.writeShort(this.valueIdx);
    }

    @Override
    public String stringifyValue() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.getConstantPool().getConstant(this.valueIdx);
        return constantUtf8.getBytes();
    }

    public String getEnumTypeString() {
        return ((ConstantUtf8)this.getConstantPool().getConstant(this.typeIdx)).getBytes();
    }

    public String getEnumValueString() {
        return ((ConstantUtf8)this.getConstantPool().getConstant(this.valueIdx)).getBytes();
    }

    public int getValueIndex() {
        return this.valueIdx;
    }

    public int getTypeIndex() {
        return this.typeIdx;
    }
}

