/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ConstantUtf8
extends Constant {
    private final String value;

    public static synchronized void clearCache() {
        Cache.CACHE.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstantUtf8 getCachedInstance(String string) {
        if (string.length() > 200) {
            return new ConstantUtf8(string);
        }
        Class<ConstantUtf8> clazz = ConstantUtf8.class;
        synchronized (ConstantUtf8.class) {
            ConstantUtf8 constantUtf8 = (ConstantUtf8)Cache.CACHE.get(string);
            if (constantUtf8 != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return constantUtf8;
            }
            constantUtf8 = new ConstantUtf8(string);
            Cache.CACHE.put(string, constantUtf8);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return constantUtf8;
        }
    }

    public static ConstantUtf8 getInstance(DataInput dataInput) throws IOException {
        return ConstantUtf8.getInstance(dataInput.readUTF());
    }

    public static ConstantUtf8 getInstance(String string) {
        return Cache.isEnabled() ? ConstantUtf8.getCachedInstance(string) : new ConstantUtf8(string);
    }

    public ConstantUtf8(ConstantUtf8 constantUtf8) {
        this(constantUtf8.getBytes());
    }

    ConstantUtf8(DataInput dataInput) throws IOException {
        super((byte)1);
        this.value = dataInput.readUTF();
    }

    public ConstantUtf8(String string) {
        super((byte)1);
        if (string == null) {
            throw new IllegalArgumentException("Value must not be null.");
        }
        this.value = string;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantUtf8(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeUTF(this.value);
    }

    public String getBytes() {
        return this.value;
    }

    @Deprecated
    public void setBytes(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return super.toString() + "(\"" + Utility.replace(this.value, "\n", "\\n") + "\")";
    }

    private static class Cache {
        private static final boolean BCEL_STATISTICS = false;
        private static final int MAX_ENTRIES = 20000;
        private static final int INITIAL_CAPACITY = 26666;
        private static final HashMap<String, ConstantUtf8> CACHE = new LinkedHashMap<String, ConstantUtf8>(26666, 0.75f, true){
            private static final long serialVersionUID = -8506975356158971766L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ConstantUtf8> entry) {
                return this.size() > 20000;
            }
        };
        private static final int MAX_ENTRY_SIZE = 200;

        private Cache() {
        }

        static boolean isEnabled() {
            return true;
        }
    }
}

