/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class CodeException
implements Cloneable,
Node {
    private int start_pc;
    private int end_pc;
    private int handler_pc;
    private int catch_type;

    public CodeException(CodeException codeException) {
        this(codeException.getStartPC(), codeException.getEndPC(), codeException.getHandlerPC(), codeException.getCatchType());
    }

    CodeException(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
    }

    public CodeException(int n, int n2, int n3, int n4) {
        this.start_pc = n;
        this.end_pc = n2;
        this.handler_pc = n3;
        this.catch_type = n4;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCodeException(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.start_pc);
        dataOutputStream.writeShort(this.end_pc);
        dataOutputStream.writeShort(this.handler_pc);
        dataOutputStream.writeShort(this.catch_type);
    }

    public int getCatchType() {
        return this.catch_type;
    }

    public int getEndPC() {
        return this.end_pc;
    }

    public int getHandlerPC() {
        return this.handler_pc;
    }

    public int getStartPC() {
        return this.start_pc;
    }

    public void setCatchType(int n) {
        this.catch_type = n;
    }

    public void setEndPC(int n) {
        this.end_pc = n;
    }

    public void setHandlerPC(int n) {
        this.handler_pc = n;
    }

    public void setStartPC(int n) {
        this.start_pc = n;
    }

    public String toString() {
        return "CodeException(start_pc = " + this.start_pc + ", end_pc = " + this.end_pc + ", handler_pc = " + this.handler_pc + ", catch_type = " + this.catch_type + ")";
    }

    public String toString(ConstantPool constantPool, boolean bl) {
        String string = this.catch_type == 0 ? "<Any exception>(0)" : Utility.compactClassName(constantPool.getConstantString(this.catch_type, (byte)7), false) + (bl ? "(" + this.catch_type + ")" : "");
        return this.start_pc + "\t" + this.end_pc + "\t" + this.handler_pc + "\t" + string;
    }

    public String toString(ConstantPool constantPool) {
        return this.toString(constantPool, true);
    }

    public CodeException copy() {
        try {
            return (CodeException)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

