/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.geotools.data.DataSourceException;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.geotools.resources.NIOUtilities;

public class ShapefileReader
implements FileReader {
    private ShapeHandler handler;
    private ShapefileHeader header;
    private ReadableByteChannel channel;
    ByteBuffer buffer;
    private ShapeType fileShapeType = ShapeType.UNDEFINED;
    private ByteBuffer headerTransfer;
    private final Record record = new Record();
    private final boolean randomAccessEnabled;
    private boolean useMemoryMappedBuffer;
    private long currentOffset = 0L;
    private StreamLogging streamLogger = new StreamLogging("Shapefile Reader");

    public ShapefileReader(ShpFiles shapefileFiles, boolean strict, boolean useMemoryMapped) throws IOException, ShapefileException {
        this.channel = shapefileFiles.getReadChannel(ShpFileType.SHP, this);
        this.useMemoryMappedBuffer = useMemoryMapped;
        this.streamLogger.open();
        this.randomAccessEnabled = this.channel instanceof FileChannel;
        this.init(strict);
    }

    public static ShapefileHeader readHeader(ReadableByteChannel channel, boolean strict) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(100);
        if (ShapefileReader.fill(buffer, channel) == -1) {
            throw new EOFException("Premature end of header");
        }
        buffer.flip();
        ShapefileHeader header = new ShapefileHeader();
        header.read(buffer, strict);
        NIOUtilities.clean((ByteBuffer)buffer);
        return header;
    }

    public static ByteBuffer ensureCapacity(ByteBuffer buffer, int size, boolean useMemoryMappedBuffer) {
        int limit;
        if (buffer.isReadOnly() || useMemoryMappedBuffer) {
            return buffer;
        }
        for (limit = buffer.limit(); limit < size; limit *= 2) {
        }
        if (limit != buffer.limit()) {
            buffer = ByteBuffer.allocateDirect(limit);
        }
        return buffer;
    }

    public static int fill(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        int r = buffer.remaining();
        while (buffer.remaining() > 0 && r != -1) {
            r = channel.read(buffer);
        }
        if (r == -1) {
            buffer.limit(buffer.position());
        }
        return r;
    }

    private void init(boolean strict) throws IOException, ShapefileException {
        this.header = ShapefileReader.readHeader(this.channel, strict);
        this.fileShapeType = this.header.getShapeType();
        this.handler = this.fileShapeType.getShapeHandler();
        if (this.handler == null) {
            throw new IOException("Unsuported shape type:" + this.fileShapeType);
        }
        if (this.channel instanceof FileChannel && this.useMemoryMappedBuffer) {
            FileChannel fc = (FileChannel)this.channel;
            this.buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            this.buffer.position(100);
            this.currentOffset = 0L;
        } else {
            this.useMemoryMappedBuffer = false;
            this.buffer = ByteBuffer.allocateDirect(8192);
            ShapefileReader.fill(this.buffer, this.channel);
            this.buffer.flip();
            this.currentOffset = 100L;
        }
        this.headerTransfer = ByteBuffer.allocate(8);
        this.headerTransfer.order(ByteOrder.BIG_ENDIAN);
        this.record.end = this.toFileOffset(this.buffer.position());
    }

    public ShapefileHeader getHeader() {
        return this.header;
    }

    public void close() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
        }
        if (this.buffer instanceof MappedByteBuffer) {
            NIOUtilities.clean((ByteBuffer)this.buffer);
        }
        this.channel = null;
        this.header = null;
    }

    public boolean supportsRandomAccess() {
        return this.randomAccessEnabled;
    }

    public boolean hasNext() throws IOException {
        return this.hasNext(true);
    }

    private boolean hasNext(boolean checkRecno) throws IOException {
        int position = this.buffer.position();
        this.buffer.position(this.toBufferOffset(this.record.end));
        if (this.buffer.remaining() < 8) {
            return false;
        }
        boolean hasNext = true;
        if (checkRecno) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
            hasNext = this.buffer.getInt() == this.record.number + 1;
        }
        this.buffer.position(position);
        return hasNext;
    }

    public int transferTo(ShapefileWriter writer, int recordNum, double[] bounds) throws IOException {
        this.buffer.position(this.toBufferOffset(this.record.end));
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.getInt();
        int rl = this.buffer.getInt();
        int mark = this.buffer.position();
        int len = rl * 2;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        ShapeType recordType = ShapeType.forID(this.buffer.getInt());
        if (recordType.isMultiPoint()) {
            for (int i = 0; i < 4; ++i) {
                bounds[i] = this.buffer.getDouble();
            }
        } else if (recordType != ShapeType.NULL) {
            bounds[0] = bounds[1] = this.buffer.getDouble();
            bounds[2] = bounds[3] = this.buffer.getDouble();
        }
        this.headerTransfer.position(0);
        this.headerTransfer.putInt(recordNum).putInt(rl).position(0);
        writer.shpChannel.write(this.headerTransfer);
        this.headerTransfer.putInt(0, writer.offset).position(0);
        writer.offset += rl + 4;
        writer.shxChannel.write(this.headerTransfer);
        this.buffer.position(mark).limit(mark + len);
        writer.shpChannel.write(this.buffer);
        this.buffer.limit(this.buffer.capacity());
        this.record.end = this.toFileOffset(this.buffer.position());
        ++this.record.number;
        return len;
    }

    public Record nextRecord() throws IOException {
        this.buffer.position(this.toBufferOffset(this.record.end));
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int recordNumber = this.buffer.getInt();
        int recordLength = this.buffer.getInt() * 2;
        if (!this.buffer.isReadOnly() && !this.useMemoryMappedBuffer) {
            if (this.buffer.capacity() < recordLength + 8) {
                this.currentOffset += (long)this.buffer.position();
                ByteBuffer old = this.buffer;
                this.buffer = ShapefileReader.ensureCapacity(this.buffer, recordLength + 8, this.useMemoryMappedBuffer);
                this.buffer.put(old);
                NIOUtilities.clean((ByteBuffer)old);
                ShapefileReader.fill(this.buffer, this.channel);
                this.buffer.position(0);
            } else if (this.buffer.remaining() < recordLength + 8) {
                this.currentOffset += (long)this.buffer.position();
                this.buffer.compact();
                ShapefileReader.fill(this.buffer, this.channel);
                this.buffer.position(0);
            }
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        ShapeType recordType = ShapeType.forID(this.buffer.getInt());
        if (recordType != ShapeType.NULL && recordType != this.fileShapeType) {
            throw new IllegalStateException("ShapeType changed illegally from " + this.fileShapeType + " to " + recordType);
        }
        this.buffer.mark();
        if (recordType.isMultiPoint()) {
            this.record.minX = this.buffer.getDouble();
            this.record.minY = this.buffer.getDouble();
            this.record.maxX = this.buffer.getDouble();
            this.record.maxY = this.buffer.getDouble();
        } else if (recordType != ShapeType.NULL) {
            this.record.minX = this.record.maxX = this.buffer.getDouble();
            this.record.minY = this.record.maxY = this.buffer.getDouble();
        }
        this.buffer.reset();
        this.record.offset = this.record.end;
        this.record.length = recordLength;
        this.record.type = recordType;
        this.record.number = recordNumber;
        this.record.end = this.toFileOffset(this.buffer.position()) + recordLength - 4;
        this.record.start = this.buffer.position();
        this.record.shape = null;
        return this.record;
    }

    public void goTo(int offset) throws IOException, UnsupportedOperationException {
        if (this.randomAccessEnabled) {
            if (this.useMemoryMappedBuffer) {
                this.buffer.position(offset);
            } else if (this.currentOffset <= (long)offset && this.currentOffset + (long)this.buffer.limit() >= (long)(offset + 8)) {
                this.buffer.position(this.toBufferOffset(offset));
            } else {
                FileChannel fc = (FileChannel)this.channel;
                fc.position(offset);
                this.currentOffset = offset;
                this.buffer.position(0);
                ShapefileReader.fill(this.buffer, fc);
                this.buffer.position(0);
            }
            int oldRecordOffset = this.record.end;
            this.record.end = offset;
            try {
                this.hasNext(false);
            }
            catch (IOException ioe) {
                this.record.end = oldRecordOffset;
                throw ioe;
            }
        } else {
            throw new UnsupportedOperationException("Random Access not enabled");
        }
    }

    public Object shapeAt(int offset) throws IOException, UnsupportedOperationException {
        if (this.randomAccessEnabled) {
            this.goTo(offset);
            return this.nextRecord().shape();
        }
        throw new UnsupportedOperationException("Random Access not enabled");
    }

    public Record recordAt(int offset) throws IOException, UnsupportedOperationException {
        if (this.randomAccessEnabled) {
            this.goTo(offset);
            return this.nextRecord();
        }
        throw new UnsupportedOperationException("Random Access not enabled");
    }

    private int toBufferOffset(int offset) {
        return (int)((long)offset - this.currentOffset);
    }

    private int toFileOffset(int offset) {
        return (int)(this.currentOffset + (long)offset);
    }

    public int getCount(int count) throws DataSourceException {
        try {
            if (this.channel == null) {
                return -1;
            }
            count = 0;
            long offset = this.currentOffset;
            try {
                this.goTo(100);
            }
            catch (UnsupportedOperationException e) {
                return -1;
            }
            while (this.hasNext()) {
                ++count;
                this.nextRecord();
            }
            this.goTo((int)offset);
        }
        catch (IOException ioe) {
            count = -1;
            throw new DataSourceException("Problem reading shapefile record", ioe);
        }
        return count;
    }

    public void setHandler(ShapeHandler handler) {
        this.handler = handler;
    }

    public String id() {
        return this.getClass().getName();
    }

    public final class Record {
        int length;
        int number = 0;
        int offset;
        int start = 0;
        public double minX;
        public double minY;
        public double maxX;
        public double maxY;
        ShapeType type;
        int end = 0;
        Object shape = null;

        public Object shape() {
            if (this.shape == null) {
                ShapefileReader.this.buffer.position(this.start);
                ShapefileReader.this.buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.shape = ShapefileReader.this.handler.read(ShapefileReader.this.buffer, this.type);
            }
            return this.shape;
        }

        public int offset() {
            return this.offset;
        }

        public String toString() {
            return "Record " + this.number + " length " + this.length + " bounds " + this.minX + "," + this.minY + " " + this.maxX + "," + this.maxY;
        }
    }
}

