/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.util.Converters;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class DefaultAttributeType
extends AttributeDescriptorImpl
implements AttributeType {
    protected DefaultAttributeType(String name, Class type, boolean nillable, int min, int max, Object defaultValue, Filter f) {
        this(DefaultAttributeType.createAttributeType(name, type != null ? type : Object.class, f), name, nillable, min, max, defaultValue);
    }

    protected DefaultAttributeType(org.opengis.feature.type.AttributeType type, String name, boolean nillable, int min, int max, Object defaultValue) {
        super(type, new NameImpl(name == null ? "" : name), min, max, nillable, defaultValue);
        if (defaultValue != null && !type.getBinding().isAssignableFrom(defaultValue.getClass())) {
            throw new IllegalArgumentException("Default value does not match type");
        }
    }

    protected DefaultAttributeType(String name, Class type, boolean nillable, int min, int max, Object defaultValue) {
        this(name, type, nillable, min, max, defaultValue, (Filter)Filter.INCLUDE);
    }

    protected DefaultAttributeType(String name, Class type, boolean nillable, Object defaultValue) {
        this(name, type, nillable, 1, 1, defaultValue, (Filter)Filter.INCLUDE);
    }

    protected DefaultAttributeType(AttributeType copy) {
        super(copy.getType(), copy.getName(), copy.getMinOccurs(), copy.getMaxOccurs(), copy.isNillable(), copy.getDefaultValue());
    }

    public DefaultAttributeType(org.opengis.feature.type.AttributeType type, Name name, int min, int max, boolean isNillable, Object defaultValue) {
        super(type, name, min, max, isNillable, defaultValue);
    }

    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    public Class getBinding() {
        return this.getType().getBinding();
    }

    public Object duplicate(Object src) throws IllegalAttributeException {
        if (src == null) {
            return null;
        }
        if (src instanceof String || src instanceof Integer || src instanceof Double || src instanceof Float || src instanceof Byte || src instanceof Boolean || src instanceof Short || src instanceof Long || src instanceof Character || src instanceof Number) {
            return src;
        }
        if (src instanceof Date) {
            return new Date(((Date)src).getTime());
        }
        if (src instanceof URL || src instanceof URI) {
            return src;
        }
        if (src instanceof Object[]) {
            Object[] array = (Object[])src;
            Object[] copy = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                copy[i] = this.duplicate(array[i]);
            }
            return copy;
        }
        if (src instanceof Geometry) {
            Geometry geometry = (Geometry)src;
            return geometry.clone();
        }
        if (src instanceof Feature) {
            Feature feature = (Feature)src;
            return feature.getFeatureType().duplicate(feature);
        }
        Class<?> type = src.getClass();
        if (type.isArray() && type.getComponentType().isPrimitive()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            System.arraycopy(src, 0, copy, 0, length);
            return copy;
        }
        if (type.isArray()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(copy, i, this.duplicate(Array.get(src, i)));
            }
            return copy;
        }
        if (src instanceof List) {
            List list = (List)src;
            ArrayList<Object> copy = new ArrayList<Object>(list.size());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                copy.add(this.duplicate(i.next()));
            }
            return Collections.unmodifiableList(copy);
        }
        if (src instanceof Map) {
            Map map = (Map)src;
            HashMap copy = new HashMap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                copy.put(entry.getKey(), this.duplicate(entry.getValue()));
            }
            return Collections.unmodifiableMap(copy);
        }
        if (src instanceof GridCoverage) {
            return src;
        }
        throw new IllegalAttributeException("Do not know how to deep copy " + type.getName());
    }

    public int hashCode() {
        return super.hashCode() ^ this.type.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AttributeType)) {
            return false;
        }
        AttributeType att = (AttributeType)other;
        if (!super.equals(att)) {
            return false;
        }
        return this.getBinding().equals(att.getBinding());
    }

    public boolean isGeometry() {
        return Geometry.class.isAssignableFrom(this.getBinding());
    }

    public String toString() {
        String details = "name=" + this.name;
        details = details + " , type=" + this.type;
        details = details + " , nillable=" + this.isNillable() + ", min=" + this.getMinOccurs() + ", max=" + this.getMaxOccurs();
        return "DefaultAttributeType [" + details + "]";
    }

    public final Object parse(Object value) throws IllegalArgumentException {
        if (value == null || this.getBinding().isAssignableFrom(value.getClass())) {
            return value;
        }
        Object parsed = Converters.convert(value, this.getBinding());
        if (parsed == null) {
            throw new IllegalArgumentException("Could not convert " + parsed + " to type " + this.getBinding().getName());
        }
        return parsed;
    }

    public void validate(Object attribute) throws IllegalArgumentException {
        if (attribute == null) {
            if (!this.isNillable()) {
                throw new IllegalArgumentException(this.getLocalName() + " is not nillable");
            }
            return;
        }
        if (this.getBinding() != attribute.getClass() && !this.getBinding().isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(attribute.getClass().getName() + " is not an acceptable class for " + this.getLocalName() + " as it is not assignable from " + this.type);
        }
    }

    public Object createDefaultValue() {
        return this.defaultValue;
    }

    public Filter getRestriction() {
        if (!this.getType().getRestrictions().isEmpty()) {
            return (Filter)this.getType().getRestrictions().iterator().next();
        }
        return null;
    }

    public static org.opengis.feature.type.AttributeType createAttributeType(String name, Class binding, Filter restriction) {
        return new AttributeTypeImpl(new NameImpl(name), binding, false, false, restriction != null ? Collections.singletonList(restriction) : Collections.EMPTY_LIST, null, null);
    }

    public static String getLocalName(AttributeType type) {
        return type.getName().getLocalPart();
    }

    public static Class getBinding(AttributeType type) {
        return type.getType().getBinding();
    }

    public static Filter getRestriction(AttributeType type) {
        if (type.getType() != null && type.getType().getRestrictions() != null && !type.getType().getRestrictions().isEmpty()) {
            return (Filter)type.getType().getRestrictions().iterator().next();
        }
        return null;
    }
}

