/*
 * Decompiled with CFR 0.152.
 */
package netcdfTool2.gis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.StringReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.renderer.shape.ShapefileRenderer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryImpl;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ShapeFileViewer
extends JPanel {
    FeatureCollection sel_features;
    private final ShapeFileRendererPanel shapeFileRendererPanel;
    private MapContext mapContext;
    private CoordinateReferenceSystem targetCRS = null;
    private String crsID = "EPSG:4326";
    double[][][] grid = null;
    int gridWidth = 0;
    int gridHeight = 0;
    Polygon[][] rasterPolygon = null;
    TreeSet selectedCells = new TreeSet(new PointComparator());
    MathTransform crsTransformer = null;
    SimpleFeatureType geom_type = null;
    GeometryFactory geomFactory = new GeometryFactory();
    private boolean shapeLoaded = false;
    String styleString_ezg = "<StyledLayerDescriptor version=\"0.7.2\" xmlns:ogc=\"http://www.opengis.net/ogc\"><NamedLayer><Name>Layer Description File for HRU Shape</Name><UserStyle><Name>HRUs, standard</Name><FeatureTypeStyle><rule><PolygonSymbolizer><Fill><CssParameter name=\"fill\">#FFF053</CssParameter><CssParameter name=\"fill-opacity\">1.0</CssParameter></Fill><Stroke><CssParameter name=\"stroke\">#000000</CssParameter><CssParameter name=\"stroke-width\">2</CssParameter></Stroke></PolygonSymbolizer></rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>";
    String styleString_raster = "<StyledLayerDescriptor version=\"0.7.2\" xmlns:ogc=\"http://www.opengis.net/ogc\"><NamedLayer><Name>Layer Description File for HRU Shape</Name><UserStyle><Name>HRUs, standard</Name><FeatureTypeStyle><rule><PolygonSymbolizer><Fill><CssParameter name=\"fill\">#5FA8F1</CssParameter><CssParameter name=\"fill-opacity\">0.5</CssParameter></Fill><Stroke><CssParameter name=\"stroke\">#000000</CssParameter><CssParameter name=\"stroke-width\">1</CssParameter></Stroke></PolygonSymbolizer></rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>";
    String styleString_selection = "<StyledLayerDescriptor version=\"0.7.2\" xmlns:ogc=\"http://www.opengis.net/ogc\"><NamedLayer><Name>Layer Description File for HRU Shape</Name><UserStyle><Name>HRUs, standard</Name><FeatureTypeStyle><rule><PolygonSymbolizer><Fill><CssParameter name=\"fill\">#00FF00</CssParameter><CssParameter name=\"fill-opacity\">0.5</CssParameter></Fill><Stroke><CssParameter name=\"stroke\">#000000</CssParameter><CssParameter name=\"stroke-width\">1</CssParameter></Stroke></PolygonSymbolizer></rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>";
    public Style style_ezg = this.loadStyle(this.styleString_ezg);
    public Style style_raster = this.loadStyle(this.styleString_raster);
    public Style style_selection = this.loadStyle(this.styleString_selection);

    public ShapeFileViewer() {
        this.setLayout(new BorderLayout());
        try {
            this.geom_type = DataUtilities.createType((String)"location", (String)"geom:Polygon,ID:String");
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "unexpected error, because" + e);
        }
        this.shapeFileRendererPanel = new ShapeFileRendererPanel();
        this.shapeFileRendererPanel.setMinimumSize(new Dimension(600, 400));
        this.add((Component)this.shapeFileRendererPanel, "Center");
        this.setMinimumSize(new Dimension(600, 400));
    }

    public java.awt.Point[] getSelectedCells() {
        java.awt.Point[] array = new java.awt.Point[this.selectedCells.size()];
        Iterator e = this.selectedCells.iterator();
        int i = 0;
        while (e.hasNext()) {
            Object o = e.next();
            if (!(o instanceof java.awt.Point)) continue;
            array[i++] = (java.awt.Point)o;
        }
        return array;
    }

    public FeatureCollection getSelectedFeatures() {
        return this.sel_features;
    }

    public void setSelectedCells(ArrayList<java.awt.Point> points) {
        this.selectedCells.clear();
        this.selectedCells.addAll(points);
        this.repaint();
    }

    public void setSelectedCells(java.awt.Point[] points) {
        this.selectedCells.clear();
        if (points.length == 0) {
            return;
        }
        for (java.awt.Point p : points) {
            this.selectedCells.add(p);
        }
        this.repaint();
    }

    public void showRaster() {
        int j;
        int i;
        if (this.grid == null || this.targetCRS == null) {
            return;
        }
        CoordinateReferenceSystem sourceCRS = null;
        try {
            sourceCRS = CRS.decode((String)this.crsID);
            this.crsTransformer = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)this.targetCRS);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.shapeFileRendererPanel, "transformation error");
            e.printStackTrace();
            return;
        }
        if (this.grid == null || this.grid.length == 0 || this.grid[0].length == 0) {
            return;
        }
        this.gridWidth = this.grid.length;
        this.gridHeight = this.grid[0].length;
        this.rasterPolygon = new Polygon[this.gridWidth][this.gridHeight];
        double[][][] rasterPoints = new double[this.gridWidth + 1][this.gridHeight + 1][2];
        for (i = 1; i < this.gridHeight; ++i) {
            for (j = 1; j < this.gridWidth; ++j) {
                rasterPoints[j][i][0] = (this.grid[j - 1][i - 1][0] + this.grid[j][i - 1][0] + this.grid[j - 1][i][0] + this.grid[j][i][0]) / 4.0;
                rasterPoints[j][i][1] = (this.grid[j - 1][i - 1][1] + this.grid[j][i - 1][1] + this.grid[j - 1][i][1] + this.grid[j][i][1]) / 4.0;
            }
        }
        for (i = 1; i < this.gridHeight; ++i) {
            rasterPoints[0][i][0] = rasterPoints[1][i][0] - (rasterPoints[2][i][0] - rasterPoints[1][i][0]);
            rasterPoints[0][i][1] = rasterPoints[1][i][1] - (rasterPoints[2][i][1] - rasterPoints[1][i][1]);
            rasterPoints[this.gridWidth][i][0] = rasterPoints[this.gridWidth - 1][i][0] - (rasterPoints[this.gridWidth - 2][i][0] - rasterPoints[this.gridWidth - 1][i][0]);
            rasterPoints[this.gridWidth][i][1] = rasterPoints[this.gridWidth - 1][i][1] - (rasterPoints[this.gridWidth - 2][i][1] - rasterPoints[this.gridWidth - 1][i][1]);
        }
        for (int j2 = 0; j2 < this.gridWidth + 1; ++j2) {
            rasterPoints[j2][0][0] = rasterPoints[j2][1][0] - (rasterPoints[j2][2][0] - rasterPoints[j2][1][0]);
            rasterPoints[j2][0][1] = rasterPoints[j2][1][1] - (rasterPoints[j2][2][1] - rasterPoints[j2][1][1]);
            rasterPoints[j2][this.gridHeight][0] = rasterPoints[j2][this.gridHeight - 1][0] - (rasterPoints[j2][this.gridHeight - 2][0] - rasterPoints[j2][this.gridHeight - 1][0]);
            rasterPoints[j2][this.gridHeight][1] = rasterPoints[j2][this.gridHeight - 1][1] - (rasterPoints[j2][this.gridHeight - 2][1] - rasterPoints[j2][this.gridHeight - 1][1]);
        }
        for (i = 0; i < this.gridHeight; ++i) {
            for (j = 0; j < this.gridWidth; ++j) {
                Polygon polygon;
                Coordinate[] points = new Coordinate[5];
                double[][] coord_src = new double[5][2];
                double[][] coord_dest = new double[5][2];
                coord_src[0] = rasterPoints[j][i];
                coord_src[1] = rasterPoints[j + 1][i];
                coord_src[2] = rasterPoints[j + 1][i + 1];
                coord_src[3] = rasterPoints[j][i + 1];
                coord_src[4] = rasterPoints[j][i];
                for (int k = 0; k < 5; ++k) {
                    try {
                        this.crsTransformer.transform(coord_src[k], 0, coord_dest[k], 0, 1);
                        points[k] = new Coordinate(coord_dest[k][0], coord_dest[k][1]);
                        continue;
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.shapeFileRendererPanel, "transformation error - coord:" + coord_src[k][0] + "/" + coord_src[k][1]);
                        e.printStackTrace();
                        return;
                    }
                }
                LinearRing ring = this.geomFactory.createLinearRing(points);
                this.rasterPolygon[j][i] = polygon = this.geomFactory.createPolygon(ring, null);
            }
        }
    }

    void updateViewContent() {
        FeatureCollection features = FeatureCollections.newCollection();
        this.sel_features = FeatureCollections.newCollection();
        ArrayList<Polygon> data = this.clip(this.rasterPolygon);
        for (int i = 0; i < data.size(); ++i) {
            SimpleFeature feature1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.geom_type, (Object[])new Object[]{data.get(i), "name1"}, null);
            features.add((Feature)feature1);
        }
        Iterator iter = this.selectedCells.iterator();
        for (int i = 0; i < this.selectedCells.size(); ++i) {
            java.awt.Point p = (java.awt.Point)iter.next();
            SimpleFeature feature1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.geom_type, (Object[])new Object[]{this.rasterPolygon[p.x][p.y], i + 1}, null);
            this.sel_features.add((Feature)feature1);
        }
        while (this.mapContext.getLayers().length > 1) {
            this.mapContext.removeLayer(1);
        }
        this.mapContext.addLayer((MapLayer)new DefaultMapLayer(features, this.style_raster, "raster"));
        this.mapContext.addLayer((MapLayer)new DefaultMapLayer(this.sel_features, this.style_selection, "raster"));
        this.shapeFileRendererPanel.liteRenderer.setContext(this.mapContext);
    }

    ArrayList<Polygon> clip(Polygon[][] data) {
        ArrayList<Polygon> list = new ArrayList<Polygon>();
        Envelope env = this.shapeFileRendererPanel.getScreenEnvelope();
        if (env != null && data != null) {
            Polygon[][] polygonArray = data;
            int n = polygonArray.length;
            for (int i = 0; i < n; ++i) {
                Polygon[] data1;
                block1: for (Polygon data11 : data1 = polygonArray[i]) {
                    Coordinate[] p;
                    for (Coordinate p1 : p = data11.getCoordinates()) {
                        if (!env.intersects(p1) && !env.contains(p1)) continue;
                        list.add(data11);
                        continue block1;
                    }
                }
            }
        }
        return list;
    }

    public void addRaster(double[][][] grid, String crsID) {
        this.grid = grid;
        this.crsID = crsID;
        this.showRaster();
        try {
            this.shapeFileRendererPanel.resetView();
            this.repaint();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean setShapeFile(String path) {
        this.mapContext = null;
        try {
            ShapefileDataStore store = new ShapefileDataStore(new File(path).toURI().toURL());
            this.targetCRS = ((SimpleFeatureType)store.getFeatureSource().getSchema()).getCoordinateReferenceSystem();
            if (this.targetCRS == null) {
                JOptionPane.showMessageDialog(this.shapeFileRendererPanel, "unable to find CRS data, use default WGS84");
                this.targetCRS = CRS.decode((String)"EPSG:4326");
            }
            this.mapContext = new DefaultMapContext(this.targetCRS);
            this.mapContext.addLayer(store.getFeatureSource(), this.style_ezg);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.shapeFileRendererPanel, "unable to load shape file, because:" + e);
            e.printStackTrace();
            return false;
        }
        this.shapeLoaded = true;
        this.showRaster();
        this.shapeFileRendererPanel.liteRenderer.setContext(this.mapContext);
        this.shapeFileRendererPanel.resetView();
        this.repaint();
        return true;
    }

    private Style loadStyle(final String xmlFile) {
        return new SLDParser((StyleFactory)new StyleFactoryImpl()){
            {
                super(x0);
                this.setInput(new StringReader(xmlFile));
            }
        }.readXML()[0];
    }

    private class ShapeFileRendererPanel
    extends JPanel {
        private final ShapefileRenderer liteRenderer;
        private Envelope envelope;
        private Coordinate center;
        private double zoomFactor = 1.0;
        private AffineTransform affineTransform = null;
        private JLabel coordinateLabel = new JLabel("");
        private boolean onDrag = false;
        private int startx;
        private int starty;

        public ShapeFileRendererPanel() {
            this.liteRenderer = new ShapefileRenderer(ShapeFileViewer.this.mapContext);
            this.liteRenderer.setConcatTransforms(true);
            this.setBorder(new LineBorder(new Color(0)));
            this.add(this.coordinateLabel);
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (ShapeFileRendererPanel.this.affineTransform == null) {
                        return;
                    }
                    if (e.getWheelRotation() > 0) {
                        ShapeFileRendererPanel.this.zoomFactor = ShapeFileRendererPanel.this.zoomFactor * Math.pow(0.9, e.getWheelRotation());
                    } else {
                        ShapeFileRendererPanel.this.zoomFactor = ShapeFileRendererPanel.this.zoomFactor * Math.pow(1.1111111111111112, -e.getWheelRotation());
                    }
                    ShapeFileViewer.this.updateViewContent();
                }

                public void mouseWheelEvent(MouseWheelEvent e) {
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (ShapeFileRendererPanel.this.affineTransform == null) {
                        return;
                    }
                    ShapeFileRendererPanel.this.showPosition(e.getX(), e.getY());
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    double[] dest;
                    double[] src;
                    if (ShapeFileRendererPanel.this.affineTransform == null) {
                        return;
                    }
                    ShapeFileRendererPanel.this.showPosition(e.getX(), e.getY());
                    if ((e.getModifiers() & 0x10) != 0) {
                        src = new double[4];
                        dest = new double[4];
                        src[0] = ShapeFileRendererPanel.this.startx;
                        src[1] = ShapeFileRendererPanel.this.starty;
                        src[2] = e.getX();
                        src[3] = e.getY();
                        ShapeFileRendererPanel.this.onDrag = true;
                        try {
                            ShapeFileRendererPanel.this.affineTransform.inverseTransform(src, 0, dest, 0, 2);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        FeatureCollection features = FeatureCollections.newCollection();
                        Coordinate[] points = new Coordinate[]{new Coordinate(dest[0], dest[1]), new Coordinate(dest[2], dest[1]), new Coordinate(dest[2], dest[3]), new Coordinate(dest[0], dest[3]), new Coordinate(dest[0], dest[1])};
                        LinearRing ring = ShapeFileViewer.this.geomFactory.createLinearRing(points);
                        Polygon polygon = ShapeFileViewer.this.geomFactory.createPolygon(ring, null);
                        if (!e.isControlDown()) {
                            ShapeFileViewer.this.selectedCells.clear();
                        }
                        for (int i = 0; i < ShapeFileViewer.this.gridWidth; ++i) {
                            for (int j = 0; j < ShapeFileViewer.this.gridHeight; ++j) {
                                if (polygon.contains((Geometry)ShapeFileViewer.this.rasterPolygon[i][j]) || polygon.intersects((Geometry)ShapeFileViewer.this.rasterPolygon[i][j])) {
                                    java.awt.Point p = new java.awt.Point(i, j);
                                    ShapeFileViewer.this.selectedCells.add(p);
                                    continue;
                                }
                                if (!ShapeFileViewer.this.selectedCells.contains(new java.awt.Point(i, j))) continue;
                            }
                        }
                        ShapeFileViewer.this.updateViewContent();
                    }
                    if ((e.getModifiers() & 4) != 0) {
                        src = new double[4];
                        dest = new double[4];
                        src[0] = ShapeFileRendererPanel.this.startx;
                        src[1] = ShapeFileRendererPanel.this.starty;
                        src[2] = e.getX();
                        src[3] = e.getY();
                        try {
                            ShapeFileRendererPanel.this.affineTransform.inverseTransform(src, 0, dest, 0, 2);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        ((ShapeFileRendererPanel)ShapeFileRendererPanel.this).center.x = ((ShapeFileRendererPanel)ShapeFileRendererPanel.this).center.x + dest[0] - dest[2];
                        ((ShapeFileRendererPanel)ShapeFileRendererPanel.this).center.y = ((ShapeFileRendererPanel)ShapeFileRendererPanel.this).center.y + dest[1] - dest[3];
                        ShapeFileRendererPanel.this.startx = e.getX();
                        ShapeFileRendererPanel.this.starty = e.getY();
                        ShapeFileViewer.this.updateViewContent();
                    }
                }
            });
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (ShapeFileRendererPanel.this.affineTransform == null) {
                        return;
                    }
                    ShapeFileRendererPanel.this.startx = e.getX();
                    ShapeFileRendererPanel.this.starty = e.getY();
                    ShapeFileRendererPanel.this.onDrag = false;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ShapeFileRendererPanel.this.affineTransform == null) {
                        return;
                    }
                    if (ShapeFileRendererPanel.this.onDrag) {
                        return;
                    }
                    if ((e.getModifiers() & 0x10) != 0) {
                        double[] src = new double[]{e.getX(), e.getY()};
                        double[] dest = new double[2];
                        try {
                            ShapeFileRendererPanel.this.affineTransform.inverseTransform(src, 0, dest, 0, 1);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        if (!e.isControlDown()) {
                            ShapeFileViewer.this.selectedCells.clear();
                        }
                        FeatureCollection features = FeatureCollections.newCollection();
                        Point point = ShapeFileViewer.this.geomFactory.createPoint(new Coordinate(dest[0], dest[1]));
                        for (int i = 0; i < ShapeFileViewer.this.gridWidth; ++i) {
                            for (int j = 0; j < ShapeFileViewer.this.gridHeight; ++j) {
                                if (ShapeFileViewer.this.rasterPolygon[i][j].contains((Geometry)point)) {
                                    ShapeFileViewer.this.selectedCells.add(new java.awt.Point(i, j));
                                    continue;
                                }
                                if (!ShapeFileViewer.this.selectedCells.contains(new java.awt.Point(i, j))) continue;
                            }
                        }
                    }
                    ShapeFileViewer.this.updateViewContent();
                }
            });
        }

        public void showPosition(int x, int y) {
            double[] src = new double[2];
            double[] dest = new double[2];
            src[0] = x;
            src[1] = y;
            try {
                if (this.affineTransform == null) {
                    return;
                }
                this.affineTransform.inverseTransform(src, 0, dest, 0, 1);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            src[0] = dest[0];
            src[1] = dest[1];
            NumberFormat f = NumberFormat.getNumberInstance();
            f.setMaximumFractionDigits(2);
            f.setMinimumFractionDigits(2);
            f.setMaximumIntegerDigits(10);
            f.setMinimumIntegerDigits(1);
            f.setGroupingUsed(false);
            try {
                ShapeFileViewer.this.crsTransformer.inverse().transform(src, 0, dest, 0, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.coordinateLabel.setText("lat: " + f.format(dest[1]) + " lon:" + f.format(dest[0]));
            this.coordinateLabel.invalidate();
        }

        public void resetView() {
            this.envelope = new Envelope();
            if (ShapeFileViewer.this.mapContext != null && ShapeFileViewer.this.mapContext.getLayerCount() > 0) {
                try {
                    this.envelope.expandToInclude((Envelope)ShapeFileViewer.this.mapContext.getLayer(0).getFeatureSource().getFeatures().getBounds());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ShapeFileViewer.this.mapContext.setAreaOfInterest(this.envelope);
            this.center = new Coordinate((this.envelope.getMinX() + this.envelope.getMaxX()) / 2.0, (this.envelope.getMinY() + this.envelope.getMaxY()) / 2.0);
            if (this.envelope.getHeight() == 0.0 || this.envelope.getWidth() == 0.0) {
                this.envelope.expandToInclude(ShapeFileViewer.this.rasterPolygon[0][0].getCoordinate());
            }
            ShapeFileViewer.this.updateViewContent();
        }

        private double getZoomFactor() {
            return this.zoomFactor;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (!ShapeFileViewer.this.shapeLoaded) {
                return;
            }
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            this._paintComponent((Graphics2D)graphics);
        }

        public Envelope getScreenEnvelope() {
            this.affineTransform = new AffineTransform(){
                {
                    double scaleFactorX = (double)ShapeFileRendererPanel.this.getWidth() / ShapeFileRendererPanel.this.envelope.getWidth() * ShapeFileRendererPanel.this.getZoomFactor();
                    double scaleFactorY = (double)ShapeFileRendererPanel.this.getHeight() / ShapeFileRendererPanel.this.envelope.getHeight() * ShapeFileRendererPanel.this.getZoomFactor();
                    this.translate(ShapeFileRendererPanel.this.getWidth() / 2, ShapeFileRendererPanel.this.getHeight() / 2);
                    this.scale(scaleFactorX, -scaleFactorY);
                    this.translate(-((ShapeFileRendererPanel)ShapeFileRendererPanel.this).center.x, -((ShapeFileRendererPanel)ShapeFileRendererPanel.this).center.y);
                }
            };
            java.awt.Point corner1 = new java.awt.Point(0, 0);
            java.awt.Point corner2 = new java.awt.Point(this.getSize().width, this.getSize().height);
            double[] result = new double[4];
            try {
                this.affineTransform.inverseTransform(new double[]{corner1.x, corner1.y, corner2.x, corner2.y}, 0, result, 0, 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Envelope env = new Envelope();
            env.expandToInclude(result[0], result[1]);
            env.expandToInclude(result[2], result[3]);
            return env;
        }

        private void _paintComponent(Graphics2D graphics2D) {
            graphics2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            this.affineTransform = new AffineTransform(){
                {
                    if (ShapeFileRendererPanel.this.envelope.getWidth() == 0.0 || ShapeFileRendererPanel.this.envelope.getHeight() == 0.0) {
                        ShapeFileViewer.this.updateViewContent();
                    }
                    double scaleFactorX = (double)ShapeFileRendererPanel.this.getWidth() / ShapeFileRendererPanel.this.envelope.getWidth() * ShapeFileRendererPanel.this.getZoomFactor();
                    double scaleFactorY = (double)ShapeFileRendererPanel.this.getHeight() / ShapeFileRendererPanel.this.envelope.getHeight() * ShapeFileRendererPanel.this.getZoomFactor();
                    this.translate(ShapeFileRendererPanel.this.getWidth() / 2, ShapeFileRendererPanel.this.getHeight() / 2);
                    this.scale(scaleFactorX, -scaleFactorY);
                    this.translate(-((ShapeFileRendererPanel)ShapeFileRendererPanel.this).center.x, -((ShapeFileRendererPanel)ShapeFileRendererPanel.this).center.y);
                }
            };
            if (graphics2D != null && this.liteRenderer != null) {
                this.liteRenderer.paint(graphics2D, this.getBounds(), this.affineTransform);
            }
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.repaint();
        }
    }

    public static class PointComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof java.awt.Point && o2 instanceof java.awt.Point) {
                java.awt.Point p1 = (java.awt.Point)o1;
                java.awt.Point p2 = (java.awt.Point)o2;
                if (p1.y < p2.y) {
                    return -1;
                }
                if (p1.y == p2.y) {
                    if (p1.x < p2.x) {
                        return -1;
                    }
                    if (p1.x == p2.x) {
                        return 0;
                    }
                    if (p1.x > p2.x) {
                        return 1;
                    }
                }
                if (p1.y > p2.y) {
                    return 1;
                }
            }
            return 0;
        }

        public boolean equals(Object o1, Object o2) {
            return this.compare(o1, o2) == 0;
        }
    }
}

