/*
 * Decompiled with CFR 0.152.
 */
package netcdfTool2.gis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import netcdfTool2.gis.RasterTransformer;

public class ArbitraryRasterTransformer
extends RasterTransformer {
    private double[] lon_rotated = null;
    private double[] lat_rotated = null;
    private double[] lon_original = null;
    private double[] lat_original = null;
    public static final int ROTATED = 0;
    public static final int NOTROTATED = 1;
    boolean identTransform = true;
    boolean flip = false;
    private String name;
    int src_area;
    int dest_area;

    public ArbitraryRasterTransformer(int src_area, int dest_area) {
        this.identTransform = true;
        this.name = "identity";
        this.src_area = src_area;
        this.dest_area = dest_area;
    }

    public ArbitraryRasterTransformer(int src_area, int dest_area, boolean flip) {
        this.identTransform = true;
        this.flip = flip;
        this.name = flip ? "flip dimensions" : "identity";
        this.src_area = src_area;
        this.dest_area = dest_area;
    }

    public ArbitraryRasterTransformer(String name, double[] lon_rotated, double[] lat_rotated, double[] lon_org, double[] lat_org) {
        this.lat_original = lat_org;
        this.lon_original = lon_org;
        this.lat_rotated = lat_rotated;
        this.lon_rotated = lon_rotated;
        this.identTransform = false;
        this.name = name;
    }

    public static ArbitraryRasterTransformer load(File file) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        double[] lat_original = null;
        double[] lon_original = null;
        double[] lat_transformed = null;
        double[] lon_transformed = null;
        try {
            StringTokenizer tok_lat_o = new StringTokenizer(properties.getProperty("lat_original"), ",");
            lat_original = new double[tok_lat_o.countTokens()];
            for (int i = 0; i < lat_original.length; ++i) {
                lat_original[i] = Double.parseDouble(tok_lat_o.nextToken());
            }
            StringTokenizer tok_lon_o = new StringTokenizer(properties.getProperty("lon_original"), ",");
            lon_original = new double[tok_lon_o.countTokens()];
            for (int i = 0; i < lon_original.length; ++i) {
                lon_original[i] = Double.parseDouble(tok_lon_o.nextToken());
            }
            StringTokenizer tok_lat_t = new StringTokenizer(properties.getProperty("lat_transformed"), ",");
            lat_transformed = new double[tok_lat_t.countTokens()];
            for (int i = 0; i < lat_transformed.length; ++i) {
                lat_transformed[i] = Double.parseDouble(tok_lat_t.nextToken());
            }
            StringTokenizer tok_lon_t = new StringTokenizer(properties.getProperty("lon_transformed"), ",");
            lon_transformed = new double[tok_lon_t.countTokens()];
            for (int i = 0; i < lon_transformed.length; ++i) {
                lon_transformed[i] = Double.parseDouble(tok_lon_t.nextToken());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        String name = properties.getProperty("identifier");
        return new ArbitraryRasterTransformer(name, lon_transformed, lat_transformed, lon_original, lat_original);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public double[] transform(double[] point) {
        if (this.identTransform) {
            if (this.flip) {
                return new double[]{point[1], point[0]};
            }
            return point;
        }
        double[][] src = new double[2][];
        double[][] dest = new double[2][];
        double cx = point[0];
        double cy = point[1];
        switch (this.src_area) {
            case 1: {
                src[0] = this.lat_original;
                src[1] = this.lon_original;
                break;
            }
            case 0: {
                src[0] = this.lat_rotated;
                src[1] = this.lon_rotated;
                break;
            }
            default: {
                return null;
            }
        }
        switch (this.dest_area) {
            case 1: {
                dest[0] = this.lat_original;
                dest[1] = this.lon_original;
                break;
            }
            case 0: {
                dest[0] = this.lat_rotated;
                dest[1] = this.lon_rotated;
                break;
            }
            default: {
                return null;
            }
        }
        int[] enclosingGridRect = new int[4];
        double[] distance = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        int N = src[0].length;
        for (int k = 0; k < N; ++k) {
            double current_distance = Math.sqrt((src[0][k] - cx) * (src[0][k] - cx) + (src[1][k] - cy) * (src[1][k] - cy));
            if (src[0][k] <= cx && src[1][k] <= cy && distance[0] >= current_distance) {
                enclosingGridRect[0] = k;
                distance[0] = current_distance;
            }
            if (src[0][k] >= cx && src[1][k] <= cy && distance[1] >= current_distance) {
                enclosingGridRect[1] = k;
                distance[1] = current_distance;
            }
            if (src[0][k] >= cx && src[1][k] >= cy && distance[2] >= current_distance) {
                enclosingGridRect[2] = k;
                distance[2] = current_distance;
            }
            if (!(src[0][k] <= cx) || !(src[1][k] >= cy) || !(distance[3] >= current_distance)) continue;
            enclosingGridRect[3] = k;
            distance[3] = current_distance;
        }
        double[] target = new double[2];
        if (distance[0] <= 1.0E-5) {
            target[0] = dest[0][enclosingGridRect[0]];
            target[1] = dest[1][enclosingGridRect[0]];
            return target;
        }
        if (distance[1] <= 1.0E-5) {
            target[0] = dest[0][enclosingGridRect[1]];
            target[1] = dest[1][enclosingGridRect[1]];
            return target;
        }
        if (distance[2] <= 1.0E-5) {
            target[0] = dest[0][enclosingGridRect[2]];
            target[1] = dest[1][enclosingGridRect[2]];
            return target;
        }
        if (distance[3] <= 1.0E-5) {
            target[0] = dest[0][enclosingGridRect[3]];
            target[1] = dest[1][enclosingGridRect[3]];
            return target;
        }
        double dist_sum = 1.0 / distance[0] + 1.0 / distance[1] + 1.0 / distance[2] + 1.0 / distance[3];
        target[0] = 0.0;
        target[1] = 0.0;
        for (int i = 0; i < 4; ++i) {
            target[0] = target[0] + dest[0][enclosingGridRect[i]] * (distance[i] / dist_sum);
            target[1] = target[1] + dest[1][enclosingGridRect[i]] * (distance[i] / dist_sum);
        }
        return target;
    }
}

