/*
 * Decompiled with CFR 0.152.
 */
package netcdfTool2;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import netcdfTool2.gis.RasterTransformer;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import ucar.nc2.Variable;

public abstract class ConverterTask {
    protected SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm"){
        {
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    };
    protected SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd"){
        {
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    };
    protected SimpleDateFormat format3 = new SimpleDateFormat("yyyy-MM-dd_HH:mm"){
        {
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    };
    protected SimpleDateFormat format4 = new SimpleDateFormat("yyyyMMddHH"){
        {
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    };
    protected int timeUnit = 0;
    protected String latDesc;
    protected String lonDesc;
    protected String timeDesc;
    public static final int TRANSFORM_IDENTITY = 0;
    public static final int TRANSFORM_BRAHMA = 1;
    public static final int TRANSFORM_DANUBE = 2;
    public static final int AGGREGATE_ORIGINAL = 0;
    public static final int AGGREGATE_HOURLY = 1;
    public static final int AGGREGATE_DAILY = 2;
    public static final int AGGREGATE_WEEKLY = 3;
    public static final int AGGREGATE_MONTHLY = 4;
    public static final int AGGREGATE_YEARLY = 5;
    public static final int AGGREGATE_SUM = 0;
    public static final int AGGREGATE_AVG = 1;
    public static final int AGGREGATE_MIN = 2;
    public static final int AGGREGATE_MAX = 3;
    public static final int UNITCONV_NONE = 0;
    public static final int UNITCONV_SEC_TU = 1;
    public static final int UNITCONV_K_DEG = 2;
    public static final int UNITCONV_SEC_HRS = 3;
    Progress currentProgress = new Progress();
    protected ConvertingOptions options;
    private CoordinateReferenceSystem targetCRS;
    ArrayList<PropertyChangeListener> listeners = new ArrayList();
    DecimalFormat formatYear = new DecimalFormat("0000");
    DecimalFormat formatMonth = new DecimalFormat("00");
    DecimalFormat formatDay = new DecimalFormat("00");
    SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm"){
        {
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    };

    public abstract void execute();

    public void setOptions(ConvertingOptions options) {
        this.options = options;
    }

    public void writeSelectedPolys(ConvertingOptions opt) throws MalformedURLException, IOException {
        String path = opt.shapeFileName;
        FeatureCollection sel_features = opt.selectedFeatures;
        URL targetURL = new File(path).toURI().toURL();
        ShapefileDataStore newShapefileDataStore = new ShapefileDataStore(targetURL);
        newShapefileDataStore.createSchema((SimpleFeatureType)sel_features.getSchema());
        try {
            newShapefileDataStore.forceSchemaCRS(CRS.decode((String)"EPSG:4326"));
        }
        catch (FactoryException ex) {
            Logger.getLogger(ConverterTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        FeatureSource newFeatureSource = newShapefileDataStore.getFeatureSource();
        FeatureStore newFeatureStore = (FeatureStore)newFeatureSource;
        Transaction t = newFeatureStore.getTransaction();
        newFeatureStore.addFeatures(sel_features);
        t.commit();
        t.close();
    }

    public double[][][] makeGrid(double[] axis_lat, double[] axis_lon, RasterTransformer transformer) {
        double[][][] result = new double[axis_lat.length][axis_lon.length][2];
        for (int i = 0; i < axis_lon.length; ++i) {
            for (int j = 0; j < axis_lat.length; ++j) {
                result[i][j][0] = axis_lat[i];
                result[i][j][1] = axis_lon[j];
                result[i][j] = transformer.transform(result[i][j]);
            }
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    protected void firePropertyChange(String p, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, p, oldValue, newValue);
        for (PropertyChangeListener p1 : this.listeners) {
            p1.propertyChange(evt);
        }
    }

    protected void setProgress(double d, String msg) {
        this.currentProgress.progress = d;
        this.currentProgress.isFailed = false;
        if (msg != null) {
            this.currentProgress.message = msg;
        }
        this.firePropertyChange("progress", this.currentProgress, this.currentProgress);
    }

    protected void setFailed(String msg) {
        this.currentProgress.progress = 0.0;
        this.currentProgress.isFailed = true;
        this.currentProgress.message = msg;
        this.firePropertyChange("progress", this.currentProgress, this.currentProgress);
    }

    MathTransform createCoordinateTransformer() {
        CoordinateReferenceSystem sourceCRS = null;
        MathTransform crsTransformer = null;
        try {
            this.targetCRS = CRS.decode((String)this.options.dstProjName);
            sourceCRS = CRS.decode((String)this.options.srcProjName);
            crsTransformer = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)this.targetCRS);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "cannot find a valid coordinate transformation");
            return null;
        }
        return crsTransformer;
    }

    void largeValueCalendarAdd(GregorianCalendar obj, int field, long lAmount) {
        if (lAmount < Integer.MAX_VALUE) {
            obj.add(field, (int)lAmount);
        } else if (field == 14) {
            this.largeValueCalendarAdd(obj, 13, lAmount / 1000L);
            obj.add(14, (int)(lAmount % 1000L));
        } else if (field == 13) {
            this.largeValueCalendarAdd(obj, 12, lAmount / 60L);
            obj.add(13, (int)(lAmount % 60L));
        } else if (field == 12) {
            this.largeValueCalendarAdd(obj, 10, lAmount / 60L);
            obj.add(12, (int)(lAmount % 60L));
        } else if (field == 10) {
            this.largeValueCalendarAdd(obj, 6, lAmount / 24L);
            obj.add(10, (int)(lAmount % 24L));
        } else {
            this.largeValueCalendarAdd(obj, field, lAmount - Integer.MAX_VALUE);
        }
    }

    abstract boolean readCoordinateSystem();

    abstract double[][][] makeGrid(RasterTransformer var1);

    protected String to360DayYear(GregorianCalendar originalDate, Date startDate) {
        long diff = originalDate.getTimeInMillis() - startDate.getTime();
        GregorianCalendar calendarx = new GregorianCalendar();
        calendarx.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendarx.setTime(startDate);
        long years = (diff /= 86400000L) / 360L + (long)calendarx.get(1);
        long month = diff % 360L / 30L + 1L;
        long day = diff % 30L + 1L;
        return this.formatYear.format(years) + "-" + this.formatMonth.format(month) + "-" + this.formatDay.format(day) + " " + this.timeFormat.format(originalDate.getTime());
    }

    protected String to365DayYear(GregorianCalendar originalDate, Date startDate) {
        long diff = originalDate.getTimeInMillis() - startDate.getTime();
        GregorianCalendar calendarx = new GregorianCalendar();
        calendarx.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendarx.setTime(startDate);
        long years = (diff /= 86400000L) / 365L + (long)calendarx.get(1);
        long[] startday = new long[]{0L, 31L, 59L, 90L, 120L, 151L, 181L, 212L, 243L, 273L, 304L, 334L, 365L};
        int month = 0;
        while (startday[month + 1] < diff % 365L) {
            ++month;
        }
        long day = diff - startday[month] + 1L;
        return this.formatYear.format(years) + "-" + this.formatMonth.format(month) + "-" + this.formatDay.format(day) + " " + this.timeFormat.format(originalDate.getTime());
    }

    protected Calendar from360DayYear(long timesteps, Date startDate) {
        GregorianCalendar calendarx = new GregorianCalendar();
        calendarx.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendarx.setTime(startDate);
        long years = timesteps / 360L + (long)calendarx.get(1);
        long month = timesteps % 360L / 30L + (long)calendarx.get(2);
        long day = timesteps % 30L + (long)calendarx.get(5);
        calendarx.set((int)years, (int)month, (int)day);
        if (day > (long)calendarx.getActualMaximum(5)) {
            day -= (long)calendarx.getActualMaximum(5);
            ++month;
        }
        if (month > (long)calendarx.getActualMaximum(2)) {
            month -= (long)(calendarx.getActualMaximum(2) + 1);
            ++years;
        }
        return new GregorianCalendar((int)years, (int)month, (int)day, 12, 0);
    }

    protected Calendar from365DayYear(long timesteps, Date startDate) {
        GregorianCalendar calendarx = new GregorianCalendar();
        calendarx.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendarx.setTime(startDate);
        switch (this.timeUnit) {
            case 13: {
                timesteps /= 86400L;
                break;
            }
            case 12: {
                timesteps /= 1440L;
                break;
            }
            case 10: {
                timesteps /= 24L;
            }
        }
        long years = timesteps / 365L + (long)calendarx.get(1);
        long[] startday = new long[]{0L, 31L, 59L, 90L, 120L, 151L, 181L, 212L, 243L, 273L, 304L, 334L, 365L};
        int month = 0;
        while (timesteps % 365L > startday[month + 1]) {
            ++month;
        }
        long day = timesteps % 365L - startday[month] + (long)calendarx.get(5);
        calendarx.set((int)years, month += calendarx.get(2), (int)day);
        if (day > (long)calendarx.getActualMaximum(5)) {
            day -= (long)calendarx.getActualMaximum(5);
            ++month;
        }
        if (month > calendarx.getActualMaximum(2)) {
            month -= calendarx.getActualMaximum(2) + 1;
            ++years;
        }
        return new GregorianCalendar((int)years, month, (int)day, 12, 0);
    }

    String buildHeader(double[][][] grid, Date startTime, Date endTime, Point[] cells, int aggregationTime, Variable var, int unitConvMode, String fileNames) {
        String unitConv;
        this.createCoordinateTransformer();
        String header = "#Extracted from NetCDF by NetCDFTool version 2.1; station coordinates are given in: " + this.targetCRS.getName() + "\n";
        header = header + "#Input file(s): " + fileNames + "\n";
        switch (unitConvMode) {
            case 2: {
                unitConv = "(converted K -> \u00b0C)";
                break;
            }
            case 3: {
                unitConv = "(converted s -> h)";
                break;
            }
            case 1: {
                unitConv = "(converted s -> time step)";
                break;
            }
            default: {
                unitConv = "";
            }
        }
        header = header + "@dataValueAttribs\n" + var.getFullName() + "\t0.0\t0.0\t" + var.getUnitsString() + " " + unitConv + "\n";
        header = header + "@dataSetAttribs\nmissingDataVal\t-9999\n";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (startTime != null) {
            calendar.setTime(startTime);
            this.roundCalendar(calendar, this.options.aggregationTime);
            header = header + "dataStart\t" + this.format.format(calendar.getTime()) + "\n";
            calendar.setTime(endTime);
            calendar.setTime(endTime);
            this.roundCalendar(calendar, this.options.aggregationTime);
            header = this.options.is360DayYear ? header + "dataEnd\t" + this.to360DayYear(calendar, endTime) + "\n" : (this.options.is365DayYear ? header + "dataEnd\t" + this.to365DayYear(calendar, endTime) + "\n" : header + "dataEnd\t" + this.format.format(calendar.getTime()) + "\n");
        } else {
            header = header + "dataStart\t" + startTime + "\n";
            header = header + "dataEnd\t" + endTime + "\n";
        }
        String tres = this.options.aggregationTime == 1 ? "h" : (this.options.aggregationTime == 2 ? "d" : (this.options.aggregationTime == 4 ? "m" : "y"));
        header = header + "tres\t" + tres + "\n";
        header = header + "@statAttribVal\n";
        String strStation = "name\t\t";
        String strID = "ID\t\t";
        String strElevation = "elevation\t\t";
        String strX = "x\t\t";
        String strY = "y\t\t";
        String strDataColumn = "datacolumn\t\t";
        for (int i = 0; i < cells.length; ++i) {
            int x = cells[i].x;
            int y = cells[i].y;
            strStation = strStation + "station_" + (i + 1);
            strID = strID + (i + 1);
            strElevation = strElevation + "0.0";
            double[] src = grid[x][y];
            double[] dest = new double[2];
            try {
                MathTransform crsTransformer = this.createCoordinateTransformer();
                crsTransformer.transform(src, 0, dest, 0, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            strX = strX + dest[0];
            strY = strY + dest[1];
            strDataColumn = strDataColumn + (i + 1);
            if (i == cells.length - 1) continue;
            strStation = strStation + "\t";
            strID = strID + "\t";
            strElevation = strElevation + "\t";
            strY = strY + "\t";
            strX = strX + "\t";
            strDataColumn = strDataColumn + "\t";
        }
        header = header + strStation + "\n" + strID + "\n" + strElevation + "\n" + strX + "\n" + strY + "\n" + strDataColumn + "\n";
        header = header + "@dataVal";
        return header;
    }

    protected SimpleDateFormat getRoundedFormat(int mode) {
        SimpleDateFormat sdf = null;
        switch (mode) {
            case 0: {
                sdf = new SimpleDateFormat("yyyy-MM-dd\tHH:mm");
            }
            case 1: {
                sdf = new SimpleDateFormat("yyyy-MM-dd\tHH:00");
            }
            case 2: {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
            }
            case 3: {
                sdf = new SimpleDateFormat("yyyy-ww");
            }
            case 4: {
                sdf = new SimpleDateFormat("yyyy-MM");
            }
            case 5: {
                sdf = new SimpleDateFormat("yyyy");
            }
        }
        sdf = new SimpleDateFormat("yyyy-MM-dd\tHH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf;
    }

    protected void roundCalendar(GregorianCalendar calendar, int mode) {
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                calendar.set(12, 59);
                calendar.set(14, 0);
                calendar.set(13, 0);
                break;
            }
            case 2: {
                calendar.set(11, 12);
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                break;
            }
            case 3: {
                calendar.set(11, 12);
                calendar.set(7, 1);
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                break;
            }
            case 4: {
                calendar.set(11, 12);
                calendar.set(5, calendar.getActualMaximum(5));
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                break;
            }
            case 5: {
                calendar.set(11, 12);
                calendar.set(6, calendar.getActualMaximum(6));
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                break;
            }
        }
    }

    String getLatitudeDesc() {
        return this.latDesc;
    }

    String getLongitudeDesc() {
        return this.lonDesc;
    }

    String getTimeDesc() {
        return this.timeDesc;
    }

    public static class ConvertingOptions {
        public boolean appendMode = false;
        public String datasetName = "dataset";
        public File transformationFile = null;
        public RasterTransformer transformer = null;
        public String dstProjName = null;
        public String srcProjName = null;
        public int aggregationTime = 0;
        public int aggregationMode = 0;
        public int unitConvMode = 0;
        Point[] cells = null;
        public File outputFile;
        public boolean is360DayYear;
        public boolean is365DayYear;
        public String fileNames;
        public String shapeFileName;
        public FeatureCollection selectedFeatures;
        public boolean xySwitch = false;
    }

    public static class Progress {
        boolean isFailed = false;
        String message = "";
        double progress = 0.0;

        Progress() {
        }
    }
}

