/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.ViewProperties;

public class NewTableDataDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -6786877503226330821L;
    private static final String[] DATATYPE_NAMES = new String[]{"byte (8-bit)", "short (16-bit)", "int (32-bit)", "unsigned byte (8-bit)", "unsigned short (16-bit)", "unsigned int (32-bit)", "long (64-bit)", "float", "double", "string", "enum", "unsigned long (64-bit)"};
    private FileFormat fileformat;
    private JComboBox parentChoice;
    private JComboBox nFieldBox;
    private JComboBox templateChoice;
    private Vector<Object> groupList;
    private Vector<Object> compoundDSList;
    private HObject newObject = null;
    private final Toolkit toolkit;
    private int numberOfMembers = 2;
    private JTable table;
    private DefaultTableModel tableModel;
    private RowEditorModel rowEditorModel;
    private DefaultCellEditor cellEditor;
    private JTextField nameField;
    private JTextField currentSizeField;
    private JTextField maxSizeField;
    private JTextField chunkSizeField;
    private JComboBox compressionLevel;
    private JComboBox rankChoice;
    private JComboBox memberTypeChoice;
    private JCheckBox checkCompression;
    private JRadioButton checkContinguous;
    private JRadioButton checkChunked;

    public NewTableDataDialog(JFrame owner, Group pGroup, List<?> objs) {
        super(owner, "New Compound Dataset...", true);
        this.fileformat = pGroup.getFileFormat();
        this.memberTypeChoice = new JComboBox<String>(DATATYPE_NAMES);
        this.cellEditor = new DefaultCellEditor(this.memberTypeChoice);
        this.rowEditorModel = new RowEditorModel(this.numberOfMembers, this.cellEditor);
        Object[] colNames = new String[]{"Name", "Datatype", "Array size / String length / Enum names"};
        this.tableModel = new DefaultTableModel(colNames, this.numberOfMembers);
        this.table = new JTable(this.tableModel){
            private static final long serialVersionUID = 7141605060652738476L;
            RowEditorModel rm;
            {
                this.rm = NewTableDataDialog.this.rowEditorModel;
            }

            @Override
            public TableCellEditor getCellEditor(int row, int col) {
                TableCellEditor cellEditor = this.rm.getEditor(row);
                if (cellEditor == null || col != 1) {
                    cellEditor = super.getCellEditor(row, col);
                }
                return cellEditor;
            }
        };
        this.table.setName("CompoundDataset");
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        int cellRowHeight = Math.max(16, this.table.getFontMetrics(this.table.getFont()).getHeight());
        this.table.setRowHeight(cellRowHeight);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.parentChoice = new JComboBox();
        String[] memberSizes = new String[100];
        for (int i = 0; i < 100; ++i) {
            memberSizes[i] = String.valueOf(i + 1);
        }
        this.nFieldBox = new JComboBox<String>(memberSizes);
        this.nFieldBox.setName("numbermembers");
        this.nFieldBox.setEditable(true);
        this.nFieldBox.addActionListener(this);
        this.nFieldBox.setActionCommand("Change number of members");
        this.nFieldBox.setSelectedItem(String.valueOf(this.numberOfMembers));
        this.groupList = new Vector(objs.size());
        Object obj = null;
        Iterator<?> iterator = objs.iterator();
        this.compoundDSList = new Vector(objs.size());
        while (iterator.hasNext()) {
            obj = iterator.next();
            if (obj instanceof Group) {
                Group g = (Group)obj;
                this.groupList.add(obj);
                if (g.isRoot()) {
                    this.parentChoice.addItem("/");
                    continue;
                }
                this.parentChoice.addItem(g.getPath() + g.getName() + "/");
                continue;
            }
            if (!(obj instanceof CompoundDS)) continue;
            this.compoundDSList.add(obj);
        }
        this.templateChoice = new JComboBox<Object>(this.compoundDSList);
        this.templateChoice.setName("templateChoice");
        this.templateChoice.setSelectedIndex(-1);
        this.templateChoice.addItemListener(this);
        if (pGroup.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(pGroup.getPath() + pGroup.getName() + "/");
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int w = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 500 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        JButton okButton = new JButton("   Ok   ");
        okButton.setName("OK");
        okButton.setActionCommand("Ok");
        okButton.setMnemonic(79);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setName("Cancel");
        cancelButton.setMnemonic(67);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout(5, 5));
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(3, 1));
        tmpP.add(new JLabel("   Dataset name: "));
        tmpP.add(new JLabel("   Parent group: "));
        tmpP.add(new JLabel("Import template: "));
        namePanel.add((Component)tmpP, "West");
        tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(3, 1));
        this.nameField = new JTextField();
        tmpP.add(this.nameField);
        this.nameField.setName("datasetname");
        tmpP.add(this.parentChoice);
        tmpP.add(this.templateChoice);
        namePanel.add((Component)tmpP, "Center");
        JPanel spacePanel = new JPanel();
        spacePanel.setLayout(new GridLayout(2, 3, 15, 3));
        TitledBorder border = new TitledBorder("Dataspace");
        border.setTitleColor(Color.blue);
        spacePanel.setBorder(border);
        this.rankChoice = new JComboBox();
        for (int i = 1; i < 33; ++i) {
            this.rankChoice.addItem(String.valueOf(i));
        }
        this.rankChoice.setSelectedIndex(0);
        this.currentSizeField = new JTextField("1");
        this.maxSizeField = new JTextField("0");
        spacePanel.add(new JLabel("No. of dimensions"));
        spacePanel.add(new JLabel("Current size"));
        spacePanel.add(new JLabel("Max size (-1 for unlimited)"));
        spacePanel.add(this.rankChoice);
        spacePanel.add(this.currentSizeField);
        spacePanel.add(this.maxSizeField);
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BorderLayout());
        border = new TitledBorder("Data Layout and Compression");
        border.setTitleColor(Color.BLUE);
        layoutPanel.setBorder(border);
        this.checkContinguous = new JRadioButton("Contiguous");
        this.checkContinguous.setSelected(true);
        this.checkChunked = new JRadioButton("Chunked");
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.checkChunked);
        bgroup.add(this.checkContinguous);
        this.chunkSizeField = new JTextField("1");
        this.chunkSizeField.setEnabled(false);
        this.checkCompression = new JCheckBox("gzip");
        this.compressionLevel = new JComboBox();
        for (int i = 0; i < 10; ++i) {
            this.compressionLevel.addItem(String.valueOf(i));
        }
        this.compressionLevel.setSelectedIndex(6);
        this.compressionLevel.setEnabled(false);
        tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(2, 1));
        tmpP.add(new JLabel("Storage layout:  "));
        tmpP.add(new JLabel("Compression:  "));
        layoutPanel.add((Component)tmpP, "West");
        tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(2, 1));
        JPanel tmpP0 = new JPanel();
        tmpP0.setLayout(new GridLayout(1, 2));
        tmpP0.add(this.checkContinguous);
        JPanel tmpP00 = new JPanel();
        tmpP00.setLayout(new GridLayout(1, 3));
        tmpP00.add(this.checkChunked);
        tmpP00.add(new JLabel("          Size: "));
        tmpP00.add(this.chunkSizeField);
        tmpP0.add(tmpP00);
        tmpP.add(tmpP0);
        tmpP0 = new JPanel();
        tmpP0.setLayout(new GridLayout(1, 7));
        tmpP0.add(this.checkCompression);
        tmpP0.add(new JLabel("      Level: "));
        tmpP0.add(this.compressionLevel);
        tmpP0.add(new JLabel(""));
        tmpP0.add(new JLabel(""));
        tmpP0.add(new JLabel(""));
        tmpP0.add(new JLabel(""));
        tmpP.add(tmpP0);
        layoutPanel.add((Component)tmpP, "Center");
        tmpP = new JPanel();
        tmpP.setLayout(new BorderLayout(5, 5));
        tmpP.add((Component)namePanel, "North");
        tmpP.add((Component)spacePanel, "Center");
        tmpP.add((Component)layoutPanel, "South");
        contentPane.add((Component)tmpP, "North");
        tmpP = new JPanel();
        tmpP.setLayout(new BorderLayout(5, 5));
        tmpP0 = new JPanel();
        tmpP0.setLayout(new BorderLayout(5, 5));
        tmpP0.add((Component)new JLabel(" Number of Members:"), "West");
        tmpP0.add((Component)this.nFieldBox, "Center");
        tmpP.add((Component)tmpP0, "North");
        JScrollPane scroller = new JScrollPane(this.table);
        border = new TitledBorder("Compound Datatype Properties");
        border.setTitleColor(Color.BLUE);
        tmpP.setBorder(border);
        tmpP.add((Component)scroller, "Center");
        contentPane.add((Component)tmpP, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        this.rankChoice.addItemListener(this);
        this.checkCompression.addItemListener(this);
        this.checkContinguous.addItemListener(this);
        this.checkChunked.addItemListener(this);
        this.memberTypeChoice.addItemListener(this);
        Point l = owner.getLocation();
        l.x += 250;
        l.y += 120;
        this.setLocation(l);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            try {
                this.newObject = this.createCompoundDS();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            }
            if (this.newObject != null) {
                this.dispose();
            }
        } else if (cmd.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
            this.groupList.setSize(0);
        } else if (cmd.equals("Change number of members")) {
            int n = 0;
            try {
                n = Integer.valueOf((String)this.nFieldBox.getSelectedItem());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (n == this.numberOfMembers) {
                return;
            }
            this.tableModel.setRowCount(n);
            for (int i = this.numberOfMembers; i < n; ++i) {
                this.rowEditorModel.addEditorForRow(i, this.cellEditor);
            }
            this.numberOfMembers = n;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.rankChoice)) {
            int rank = this.rankChoice.getSelectedIndex() + 1;
            String currentSizeStr = "1";
            String maxSizeStr = "0";
            for (int i = 1; i < rank; ++i) {
                currentSizeStr = currentSizeStr + " x 1";
                maxSizeStr = maxSizeStr + " x 0";
            }
            this.currentSizeField.setText(currentSizeStr);
            this.maxSizeField.setText(maxSizeStr);
            String currentStr = this.currentSizeField.getText();
            int idx = currentStr.lastIndexOf("x");
            String chunkStr = "1";
            if (rank <= 1) {
                chunkStr = currentStr;
            } else {
                for (int i = 1; i < rank - 1; ++i) {
                    chunkStr = chunkStr + " x 1";
                }
                if (idx > 0) {
                    chunkStr = chunkStr + " x " + currentStr.substring(idx + 1);
                }
            }
            this.chunkSizeField.setText(chunkStr);
        } else if (source.equals(this.checkContinguous)) {
            this.chunkSizeField.setEnabled(false);
        } else if (source.equals(this.checkChunked)) {
            this.chunkSizeField.setEnabled(true);
            String currentStr = this.currentSizeField.getText();
            int idx = currentStr.lastIndexOf("x");
            String chunkStr = "1";
            int rank = this.rankChoice.getSelectedIndex() + 1;
            if (rank <= 1) {
                chunkStr = currentStr;
            } else {
                for (int i = 1; i < rank - 1; ++i) {
                    chunkStr = chunkStr + " x 1";
                }
                if (idx > 0) {
                    chunkStr = chunkStr + " x " + currentStr.substring(idx + 1);
                }
            }
            this.chunkSizeField.setText(chunkStr);
        } else if (source.equals(this.checkCompression)) {
            boolean isCompressed = this.checkCompression.isSelected();
            if (isCompressed) {
                if (!this.checkChunked.isSelected()) {
                    String currentStr = this.currentSizeField.getText();
                    int idx = currentStr.lastIndexOf("x");
                    String chunkStr = "1";
                    int rank = this.rankChoice.getSelectedIndex() + 1;
                    if (rank <= 1) {
                        chunkStr = currentStr;
                    } else {
                        for (int i = 1; i < rank - 1; ++i) {
                            chunkStr = chunkStr + " x 1";
                        }
                        if (idx > 0) {
                            chunkStr = chunkStr + " x " + currentStr.substring(idx + 1);
                        }
                    }
                    this.chunkSizeField.setText(chunkStr);
                }
                this.compressionLevel.setEnabled(true);
                this.checkContinguous.setEnabled(false);
                this.checkChunked.setSelected(true);
                this.chunkSizeField.setEnabled(true);
            } else {
                this.compressionLevel.setEnabled(false);
                this.checkContinguous.setEnabled(true);
            }
        } else if (source.equals(this.memberTypeChoice)) {
            String item = (String)this.memberTypeChoice.getSelectedItem();
            if (item == null || !item.equals("enum")) {
                return;
            }
            int row = this.table.getSelectedRow();
            this.table.setValueAt("mb1=0,mb=1,...", row, 2);
        } else if (source.equals(this.templateChoice)) {
            String compression;
            Object obj = this.templateChoice.getSelectedItem();
            if (!(obj instanceof CompoundDS)) {
                return;
            }
            CompoundDS dset = (CompoundDS)obj;
            int rank = dset.getRank();
            if (rank < 1) {
                dset.init();
            }
            rank = dset.getRank();
            this.rankChoice.setSelectedIndex(rank - 1);
            long[] dims = dset.getDims();
            String[] mNames = dset.getMemberNames();
            int[] mOrders = dset.getMemberOrders();
            Datatype[] mTypes = dset.getMemberTypes();
            String sizeStr = String.valueOf(dims[0]);
            for (int i = 1; i < rank; ++i) {
                sizeStr = sizeStr + "x" + dims[i];
            }
            this.currentSizeField.setText(sizeStr);
            try {
                dset.getMetadata();
            }
            catch (Exception ex) {
                // empty catch block
            }
            long[] chunks = dset.getChunkSize();
            if (chunks != null) {
                this.checkChunked.setSelected(true);
                sizeStr = String.valueOf(chunks[0]);
                for (int i = 1; i < rank; ++i) {
                    sizeStr = sizeStr + "x" + chunks[i];
                }
                this.chunkSizeField.setText(sizeStr);
            }
            if ((compression = dset.getCompression()) != null) {
                int idx = compression.indexOf("GZIP: level = ");
                int clevel = -1;
                try {
                    clevel = Integer.parseInt(compression.substring(idx + 14, idx + 15));
                }
                catch (NumberFormatException ex) {
                    clevel = -1;
                }
                if (clevel > 0) {
                    this.checkCompression.setSelected(true);
                    this.compressionLevel.setSelectedIndex(clevel);
                }
            }
            this.numberOfMembers = dset.getMemberCount();
            this.nFieldBox.setSelectedIndex(this.numberOfMembers - 1);
            this.tableModel.setRowCount(this.numberOfMembers);
            for (int i = 0; i < this.numberOfMembers; ++i) {
                this.rowEditorModel.addEditorForRow(i, this.cellEditor);
                this.tableModel.setValueAt(mNames[i], i, 0);
                int typeIdx = -1;
                int tclass = mTypes[i].getDatatypeClass();
                int tsize = mTypes[i].getDatatypeSize();
                int tsigned = mTypes[i].getDatatypeSign();
                if (tclass == 10) {
                    tclass = mTypes[i].getBasetype().getDatatypeClass();
                    tsize = mTypes[i].getBasetype().getDatatypeSize();
                    tsigned = mTypes[i].getBasetype().getDatatypeSign();
                }
                if (tclass == 2) {
                    if (tsigned == 0) {
                        if (tsize == 1) {
                            typeIdx = 3;
                        }
                    } else if (tsize == 1) {
                        typeIdx = 0;
                    }
                }
                if (tclass == 0) {
                    typeIdx = tsigned == 0 ? (tsize == 1 ? 3 : (tsize == 2 ? 4 : (tsize == 4 ? 5 : 11))) : (tsize == 1 ? 0 : (tsize == 2 ? 1 : (tsize == 4 ? 2 : 6)));
                } else if (tclass == 1) {
                    typeIdx = tsize == 4 ? 7 : 8;
                } else if (tclass == 3) {
                    typeIdx = 9;
                } else if (tclass == 8) {
                    typeIdx = 10;
                }
                if (typeIdx < 0) continue;
                this.memberTypeChoice.setSelectedIndex(typeIdx);
                this.tableModel.setValueAt(this.memberTypeChoice.getSelectedItem(), i, 1);
                if (tclass == 3) {
                    this.tableModel.setValueAt(String.valueOf(tsize), i, 2);
                    continue;
                }
                if (tclass == 8) {
                    this.tableModel.setValueAt(mTypes[i].getEnumMembers(), i, 2);
                    continue;
                }
                this.tableModel.setValueAt(String.valueOf(mOrders[i]), i, 2);
            }
        }
    }

    private HObject createCompoundDS() throws Exception {
        int i;
        TableCellEditor ed;
        Dataset obj = null;
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (row >= 0 && col > 0 && (ed = this.table.getCellEditor(row, col)) != null) {
            ed.stopCellEditing();
        }
        long[] chunks = null;
        long[] maxdims = null;
        String dname = this.nameField.getText();
        if (dname == null || dname.length() <= 0) {
            throw new IllegalArgumentException("Dataset name is empty");
        }
        Group pgroup = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (pgroup == null) {
            throw new IllegalArgumentException("Invalid parent group");
        }
        int n = this.table.getRowCount();
        if (n <= 0) {
            return null;
        }
        String[] mNames = new String[n];
        Datatype[] mDatatypes = new Datatype[n];
        int[] mOrders = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            String name = (String)this.table.getValueAt(i2, 0);
            if (name == null || name.length() <= 0) {
                throw new IllegalArgumentException("Member name is empty");
            }
            mNames[i2] = name;
            int order = 1;
            String orderStr = (String)this.table.getValueAt(i2, 2);
            if (orderStr != null) {
                try {
                    order = Integer.parseInt(orderStr);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            mOrders[i2] = order;
            String typeName = (String)this.table.getValueAt(i2, 1);
            Datatype type = null;
            if (DATATYPE_NAMES[0].equals(typeName)) {
                type = this.fileformat.createDatatype(0, 1, -1, -1);
            } else if (DATATYPE_NAMES[1].equals(typeName)) {
                type = this.fileformat.createDatatype(0, 2, -1, -1);
            } else if (DATATYPE_NAMES[2].equals(typeName)) {
                type = this.fileformat.createDatatype(0, 4, -1, -1);
            } else if (DATATYPE_NAMES[3].equals(typeName)) {
                type = this.fileformat.createDatatype(0, 1, -1, 0);
            } else if (DATATYPE_NAMES[4].equals(typeName)) {
                type = this.fileformat.createDatatype(0, 2, -1, 0);
            } else if (DATATYPE_NAMES[5].equals(typeName)) {
                type = this.fileformat.createDatatype(0, 4, -1, 0);
            } else if (DATATYPE_NAMES[6].equals(typeName)) {
                type = this.fileformat.createDatatype(0, 8, -1, -1);
            } else if (DATATYPE_NAMES[7].equals(typeName)) {
                type = this.fileformat.createDatatype(1, 4, -1, -1);
            } else if (DATATYPE_NAMES[8].equals(typeName)) {
                type = this.fileformat.createDatatype(1, 8, -1, -1);
            } else if (DATATYPE_NAMES[9].equals(typeName)) {
                type = this.fileformat.createDatatype(3, order, -1, -1);
            } else if (DATATYPE_NAMES[10].equals(typeName)) {
                type = this.fileformat.createDatatype(8, 4, -1, -1);
                if (orderStr == null || orderStr.length() < 1 || orderStr.endsWith("...")) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Invalid member values: " + orderStr, this.getTitle(), 0);
                    return null;
                }
                type.setEnumMembers(orderStr);
            } else if (DATATYPE_NAMES[11].equals(typeName)) {
                type = this.fileformat.createDatatype(0, 8, -1, 0);
            } else {
                throw new IllegalArgumentException("Invalid data type.");
            }
            mDatatypes[i2] = type;
        }
        int rank = this.rankChoice.getSelectedIndex() + 1;
        StringTokenizer st = new StringTokenizer(this.currentSizeField.getText(), "x");
        if (st.countTokens() < rank) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of values in the current dimension size is less than " + rank, this.getTitle(), 0);
            return null;
        }
        long l = 0L;
        long[] dims = new long[rank];
        String token = null;
        for (i = 0; i < rank; ++i) {
            token = st.nextToken().trim();
            try {
                l = Long.parseLong(token);
            }
            catch (NumberFormatException ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid dimension size: " + this.currentSizeField.getText(), this.getTitle(), 0);
                return null;
            }
            if (l <= 0L) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Dimension size must be greater than zero.", this.getTitle(), 0);
                return null;
            }
            dims[i] = l;
        }
        st = new StringTokenizer(this.maxSizeField.getText(), "x");
        if (st.countTokens() < rank) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of values in the max dimension size is less than " + rank, this.getTitle(), 0);
            return null;
        }
        l = 0L;
        maxdims = new long[rank];
        for (i = 0; i < rank; ++i) {
            token = st.nextToken().trim();
            try {
                l = Long.parseLong(token);
            }
            catch (NumberFormatException ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid max dimension size: " + this.maxSizeField.getText(), this.getTitle(), 0);
                return null;
            }
            if (l < -1L) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Dimension size cannot be less than -1.", this.getTitle(), 0);
                return null;
            }
            if (l == 0L) {
                l = dims[i];
            }
            maxdims[i] = l;
        }
        chunks = null;
        if (this.checkChunked.isSelected()) {
            int status;
            st = new StringTokenizer(this.chunkSizeField.getText(), "x");
            if (st.countTokens() < rank) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Number of values in the chunk size is less than " + rank, this.getTitle(), 0);
                return null;
            }
            l = 0L;
            chunks = new long[rank];
            token = null;
            for (i = 0; i < rank; ++i) {
                token = st.nextToken().trim();
                try {
                    l = Long.parseLong(token);
                }
                catch (NumberFormatException ex) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Invalid chunk dimension size: " + this.chunkSizeField.getText(), this.getTitle(), 0);
                    return null;
                }
                if (l < 1L) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Chunk size cannot be less than 1.", this.getTitle(), 0);
                    return null;
                }
                chunks[i] = l;
            }
            long tchunksize = 1L;
            long tdimsize = 1L;
            for (int i3 = 0; i3 < rank; ++i3) {
                tchunksize *= chunks[i3];
                tdimsize *= dims[i3];
            }
            if (tchunksize >= tdimsize) {
                this.toolkit.beep();
                status = JOptionPane.showConfirmDialog(this, "Chunk size is equal/greater than the current size. \nAre you sure you want to set chunk size to " + this.chunkSizeField.getText() + "?", this.getTitle(), 0);
                if (status == 1) {
                    return null;
                }
            }
            if (tchunksize == 1L) {
                this.toolkit.beep();
                status = JOptionPane.showConfirmDialog(this, "Chunk size is one, which may cause large memory overhead for large dataset.\nAre you sure you want to set chunk size to " + this.chunkSizeField.getText() + "?", this.getTitle(), 0);
                if (status == 1) {
                    return null;
                }
            }
        }
        int gzip = 0;
        if (this.checkCompression.isSelected()) {
            gzip = this.compressionLevel.getSelectedIndex();
        }
        obj = this.checkChunked.isSelected() ? this.fileformat.createCompoundDS(dname, pgroup, dims, maxdims, chunks, gzip, mNames, mDatatypes, mOrders, null) : this.fileformat.createCompoundDS(dname, pgroup, dims, maxdims, null, -1, mNames, mDatatypes, mOrders, null);
        return obj;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }

    private class RowEditorModel {
        private Hashtable<Integer, TableCellEditor> data = new Hashtable();

        public RowEditorModel() {
        }

        public RowEditorModel(int rows, TableCellEditor ed) {
            for (int i = 0; i < rows; ++i) {
                this.data.put(new Integer(i), ed);
            }
        }

        public void addEditorForRow(int row, TableCellEditor e) {
            this.data.put(new Integer(row), e);
        }

        public void removeEditorForRow(int row) {
            this.data.remove(new Integer(row));
        }

        public TableCellEditor getEditor(int row) {
            return this.data.get(new Integer(row));
        }
    }
}

