/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.ViewProperties;

public class NewImageDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 6204900461720887966L;
    private JTextField nameField;
    private JTextField widthField;
    private JTextField heightField;
    private JComboBox parentChoice;
    private JRadioButton checkIndex;
    private JRadioButton checkTrueColor;
    private JRadioButton checkInterlacePixel;
    private JRadioButton checkInterlacePlane;
    private List groupList;
    private boolean isH5;
    private HObject newObject = null;
    private FileFormat fileFormat;
    private final Toolkit toolkit;

    public NewImageDialog(Frame owner, Group pGroup, List objs) {
        super(owner, "New HDF Image...", true);
        this.isH5 = pGroup.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF5"));
        this.fileFormat = pGroup.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.parentChoice = new JComboBox();
        this.groupList = new Vector();
        Object obj2 = null;
        for (Object obj2 : objs) {
            if (!(obj2 instanceof Group)) continue;
            this.groupList.add(obj2);
            Group g = (Group)obj2;
            if (g.isRoot()) {
                this.parentChoice.addItem("/");
                continue;
            }
            this.parentChoice.addItem(g.getPath() + g.getName() + "/");
        }
        if (pGroup.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(pGroup.getPath() + pGroup.getName() + "/");
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        int w = 400 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 250 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        JButton okButton = new JButton("   Ok   ");
        okButton.setActionCommand("Ok");
        okButton.setMnemonic(79);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic(67);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        JPanel centerP = new JPanel();
        centerP.setLayout(new BorderLayout(5, 5));
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(6, 1, 5, 5));
        tmpP.add(new JLabel("Image name: "));
        tmpP.add(new JLabel("Parent group: "));
        tmpP.add(new JLabel("Height: "));
        tmpP.add(new JLabel("Width: "));
        tmpP.add(new JLabel("Image type: "));
        tmpP.add(new JLabel("Data layout: "));
        centerP.add((Component)tmpP, "West");
        tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(6, 1, 5, 5));
        this.nameField = new JTextField();
        tmpP.add(this.nameField);
        tmpP.add(this.parentChoice);
        this.heightField = new JTextField();
        tmpP.add(this.heightField);
        this.widthField = new JTextField();
        tmpP.add(this.widthField);
        JPanel tmpP0 = new JPanel();
        tmpP0.setLayout(new GridLayout(1, 2));
        this.checkIndex = new JRadioButton("Indexed colormap", true);
        tmpP0.add(this.checkIndex);
        this.checkTrueColor = new JRadioButton("24-bit truecolor");
        tmpP0.add(this.checkTrueColor);
        tmpP0.setBorder(new TitledBorder(""));
        tmpP.add(tmpP0);
        tmpP0 = new JPanel();
        tmpP0.setLayout(new GridLayout(1, 2));
        this.checkInterlacePixel = new JRadioButton("Pixel interlace");
        tmpP0.add(this.checkInterlacePixel);
        this.checkInterlacePlane = new JRadioButton("Plane interlace");
        tmpP0.add(this.checkInterlacePlane);
        tmpP0.setBorder(new TitledBorder(""));
        tmpP.add(tmpP0);
        centerP.add((Component)tmpP, "Center");
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.checkInterlacePixel);
        bgroup.add(this.checkInterlacePlane);
        bgroup = new ButtonGroup();
        bgroup.add(this.checkTrueColor);
        bgroup.add(this.checkIndex);
        this.checkIndex.addItemListener(this);
        this.checkTrueColor.addItemListener(this);
        this.checkInterlacePixel.setSelected(true);
        this.checkInterlacePixel.setEnabled(false);
        this.checkInterlacePlane.setEnabled(false);
        centerP.setBorder(new TitledBorder(""));
        contentPane.add((Component)centerP, "Center");
        Point l = owner.getLocation();
        l.x += 250;
        l.y += 80;
        this.setLocation(l);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            this.newObject = this.createHDFimage();
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (cmd.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
            ((Vector)this.groupList).setSize(0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.checkIndex)) {
            this.checkInterlacePixel.setSelected(true);
            this.checkInterlacePixel.setEnabled(false);
            this.checkInterlacePlane.setEnabled(false);
        } else if (source.equals(this.checkTrueColor)) {
            this.checkInterlacePixel.setEnabled(true);
            this.checkInterlacePlane.setEnabled(true);
        }
    }

    private Dataset createHDFimage() {
        long[] tmpdims;
        Dataset dataset = null;
        String name = this.nameField.getText();
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.length() <= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (name.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        Group pgroup = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (pgroup == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select a parent group.", this.getTitle(), 0);
            return null;
        }
        int w = 0;
        int h = 0;
        try {
            w = Integer.parseInt(this.widthField.getText());
            h = Integer.parseInt(this.heightField.getText());
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            return null;
        }
        long[] dims = null;
        int tclass = 2;
        int tsign = 0;
        int tsize = 1;
        int torder = -1;
        int interlace = 0;
        int ncomp = 2;
        if (this.checkIndex.isSelected()) {
            dims = this.isH5 ? (tmpdims = new long[]{h, w}) : (tmpdims = new long[]{w, h});
        } else if (this.isH5) {
            if (this.checkInterlacePixel.isSelected()) {
                dims = tmpdims = new long[]{h, w, 3L};
            } else {
                interlace = 2;
                dims = tmpdims = new long[]{3L, h, w};
            }
        } else {
            ncomp = 3;
            dims = tmpdims = new long[]{w, h};
            if (this.checkInterlacePlane.isSelected()) {
                interlace = 2;
            }
        }
        try {
            Datatype datatype = this.fileFormat.createDatatype(tclass, tsize, torder, tsign);
            dataset = this.fileFormat.createImage(name, pgroup, datatype, dims, dims, null, -1, ncomp, interlace, null);
            dataset.init();
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            return null;
        }
        return dataset;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }
}

