/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgis.LinearRing;
import org.postgresql.util.PGtokenizer;

public class Polygon
extends Geometry {
    LinearRing[] rings;

    public Polygon() {
        this.type = Geometry.POLYGON;
    }

    public Polygon(LinearRing[] rings) {
        this();
        this.rings = rings;
        this.dimension = rings[0].dimension;
    }

    public Polygon(String value) throws SQLException {
        this();
        value = value.trim();
        if (value.indexOf("POLYGON") == 0) {
            value = value.substring(7).trim();
        }
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara((String)value), ',');
        int nrings = t.getSize();
        this.rings = new LinearRing[nrings];
        int r = 0;
        while (r < nrings) {
            this.rings[r] = new LinearRing(t.getToken(r));
            ++r;
        }
        this.dimension = this.rings[0].dimension;
    }

    public String toString() {
        return "POLYGON " + this.getValue();
    }

    public String getValue() {
        StringBuffer b = new StringBuffer("(");
        int r = 0;
        while (r < this.rings.length) {
            if (r > 0) {
                b.append(",");
            }
            b.append(this.rings[r].toString());
            ++r;
        }
        b.append(")");
        return b.toString();
    }

    public int numRings() {
        return this.rings.length;
    }

    public LinearRing getRing(int idx) {
        if (idx >= 0 & idx < this.rings.length) {
            return this.rings[idx];
        }
        return null;
    }
}

