/*
 * Decompiled with CFR 0.152.
 */
package jams.tools;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringTools {
    public static final Locale STANDARD_LOCALE = Locale.US;

    public static boolean isEmptyString(String theString) {
        if (theString == null) {
            return true;
        }
        return (theString = theString.trim()).length() == 0;
    }

    public static boolean parseToBoolean(String theString) {
        if (StringTools.isEmptyString(theString)) {
            return false;
        }
        return theString.equals("1") || theString.equalsIgnoreCase("true") || theString.equalsIgnoreCase("on") || theString.equalsIgnoreCase("yes") || theString.equalsIgnoreCase("ja");
    }

    public static String getStackTraceString(StackTraceElement[] stea) {
        String result = "";
        for (StackTraceElement ste : stea) {
            result = result + "        at " + ste.toString() + "\n";
        }
        return result;
    }

    public static String[] toArray(String str) {
        return StringTools.toArray(str, null);
    }

    public static String[] toArray(String str, String delim) {
        if (str == null) {
            return null;
        }
        if (delim == null) {
            delim = "[\\s]+";
        }
        return str.split(delim);
    }

    public static String getPartOfToken(String theToken, int thePart, String delimiter) {
        String result = null;
        StringTokenizer tokenizer = new StringTokenizer(theToken, delimiter);
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            result = tokenizer.nextToken();
            if (++i == thePart) {
                return result;
            }
            result = null;
        }
        return result;
    }

    public static String getGetterName(String attribName) {
        return "get" + attribName.substring(0, 1).toUpperCase(STANDARD_LOCALE) + attribName.substring(1);
    }

    public static String getSetterName(String attribName) {
        return "set" + attribName.substring(0, 1).toUpperCase(STANDARD_LOCALE) + attribName.substring(1);
    }

    public static boolean isDouble(String aString) {
        boolean isDouble = false;
        try {
            Double.parseDouble(aString);
            isDouble = true;
        }
        catch (NumberFormatException e) {
            System.out.println("could not parse " + aString + " to double.");
        }
        return isDouble;
    }

    public static String format(String msg, Object ... arguments) {
        try {
            return MessageFormat.format(msg, arguments);
        }
        catch (Throwable t) {
            Logger.getLogger(StringTools.class.getName()).log(Level.WARNING, t.toString(), t);
            return msg;
        }
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

