/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.meta.ContextAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class AttributeRepository {
    private HashMap<Class, ArrayList<ContextAttribute>> attributesByType = new HashMap();

    public void addAttribute(ContextAttribute attribute) {
        ArrayList<ContextAttribute> attributes = this.attributesByType.get(attribute.getType());
        if (attributes == null) {
            attributes = new ArrayList();
            this.attributesByType.put(attribute.getType(), attributes);
        }
        attributes.add(attribute);
    }

    public void removeAttribute(ContextAttribute attribute) {
        ArrayList<ContextAttribute> aList = this.attributesByType.get(attribute.getType());
        aList.remove(attribute);
    }

    public ArrayList<ContextAttribute> getUniqueAttributesByType(Class type) {
        ArrayList<ContextAttribute> aList = this.getAttributesByType(type);
        if (aList == null) {
            return null;
        }
        HashMap<String, ContextAttribute> map = new HashMap<String, ContextAttribute>();
        for (ContextAttribute a : aList) {
            map.put(a.getName(), a);
        }
        ArrayList<ContextAttribute> result = new ArrayList<ContextAttribute>();
        for (ContextAttribute a : map.values()) {
            result.add(a);
        }
        return result;
    }

    public ArrayList<ContextAttribute> getAttributesByType(Class<?> type) {
        ArrayList<ContextAttribute> result = new ArrayList<ContextAttribute>();
        for (Class subType : this.attributesByType.keySet()) {
            if (!type.isAssignableFrom(subType)) continue;
            result.addAll((Collection<ContextAttribute>)this.attributesByType.get(subType));
        }
        return result;
    }

    public ContextAttribute getAttributeByTypeName(Class type, String name) {
        ArrayList<ContextAttribute> attrs = this.getAttributesByType(type);
        for (ContextAttribute attr : attrs) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public ArrayList<ContextAttribute> getAttributes() {
        ArrayList<ContextAttribute> result = new ArrayList<ContextAttribute>();
        for (ArrayList<ContextAttribute> caList : this.attributesByType.values()) {
            result.addAll(caList);
        }
        return result;
    }
}

