/*
 * Decompiled with CFR 0.152.
 */
package jams.dataaccess;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DataFactory;
import jams.data.JAMSData;
import jams.data.JAMSString;
import jams.dataaccess.DataAccessor;

public class StringAccessor
implements DataAccessor {
    Attribute.String componentObject;
    Attribute.String[] entityObject;
    int index;
    int accessType;
    int updateType;

    public StringAccessor(DataFactory dataFactory, Attribute.Entity[] entities, JAMSData dataObject, String attributeName, int accessType, int updateType) throws Attribute.Entity.NoSuchAttributeException {
        this.entityObject = new JAMSString[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i].existsAttribute(attributeName)) {
                try {
                    this.entityObject[i] = (JAMSString)entities[i].getObject(attributeName);
                }
                catch (Attribute.Entity.NoSuchAttributeException noSuchAttributeException) {}
                continue;
            }
            if (accessType != 0) {
                this.entityObject[i] = dataFactory.createString();
                entities[i].setObject(attributeName, (Object)this.entityObject[i]);
                continue;
            }
            throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + attributeName + JAMS.i18n("_does_not_exist!"));
        }
        this.accessType = accessType;
        this.updateType = updateType;
        this.componentObject = (JAMSString)dataObject;
    }

    public void initEntityData() {
        for (Attribute.String v : this.entityObject) {
            v.setValue(this.componentObject.getValue());
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void read() {
        this.componentObject.setValue(this.entityObject[this.index].getValue());
    }

    public void write() {
        this.entityObject[this.index].setValue(this.componentObject.getValue());
    }

    public int getAccessType() {
        return this.accessType;
    }

    public int getUpdateType() {
        return this.updateType;
    }

    public JAMSData getComponentObject() {
        return this.componentObject;
    }
}

