/*
 * Decompiled with CFR 0.152.
 */
package jams;

import jams.JAMSException;
import jams.meta.HelpComponent;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class JAMS {
    public static final int SILENT = 0;
    public static final int STANDARD = 1;
    public static final int VERBOSE = 2;
    public static final int VVERBOSE = 3;
    private static final double missingDataValue = Double.POSITIVE_INFINITY;
    private static ResourceBundle resources = ResourceBundle.getBundle("resources/i18n/JAMSBundle");
    private static String charset = "UTF-8";
    public static final Font STANDARD_FONT = new Font("Monospaced", 0, 11);
    public static final String DEFAULT_MODEL_PARAMETER_FILENAME = "model.jmp";
    public static final String DEFAULT_INFOLOG_FILENAME = "info.log";
    public static final String DEFAULT_ERRORLOG_FILENAME = "error.log";
    public static final String DEFAULT_PROPERTY_FILENAME = "default.jap";
    private static String floatFormat = "%f";
    private static ImageIcon defaultIcon = new ImageIcon("/resouces/images/help.png");
    private static File baseDir;
    private static File libDir;
    private static Map<String, Object> objectRepo;

    public static String i18n(String key) {
        if (JAMS.getResources().containsKey(key)) {
            return JAMS.getResources().getString(key);
        }
        Logger.getLogger(JAMS.class.getName()).log(Level.INFO, "Could not find i18n key \"" + key + "\", using the key as result!");
        return key;
    }

    public static ImageIcon getIcon(String path) {
        URL url = ClassLoader.getSystemClassLoader().getResource(path);
        try {
            ImageIcon icon = new ImageIcon(url);
            return icon;
        }
        catch (NullPointerException npe) {
            Logger.getLogger(JAMS.class.getName()).log(Level.INFO, "Could not find image icon from " + path + " ;using default icon.");
            return defaultIcon;
        }
    }

    public static ImageIcon getScaledIcon(String path, int width, int height) {
        return new ImageIcon(JAMS.getIcon(path).getImage().getScaledInstance(width, height, 4));
    }

    public static HelpComponent getHelpDocument(String key) {
        String resourceName = "resources/help/i18n/" + key + "_" + Locale.getDefault().getLanguage() + ".html";
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
        if (stream == null) {
            resourceName = "resources/help/i18n/" + key + ".html";
            stream = ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
            if (stream == null) {
                HelpComponent help = new HelpComponent();
                help.setHelpText("Resource " + resourceName + " was not found.");
                return help;
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String result = "";
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                result = result + line;
            }
            reader.close();
        }
        catch (IOException ioe) {
            return null;
        }
        HelpComponent help = new HelpComponent();
        help.setHelpText(result);
        return help;
    }

    public static ResourceBundle getResources() {
        return resources;
    }

    public static void setResources(ResourceBundle aResources) {
        resources = aResources;
    }

    public static String getCharset() {
        return charset;
    }

    public static void setCharset(String aCharset) {
        charset = aCharset;
    }

    public static String getFloatFormat() {
        return floatFormat;
    }

    public static void setFloatFormat(String aFloatFormat) {
        floatFormat = aFloatFormat;
    }

    public static double getMissingDataValue() {
        return Double.POSITIVE_INFINITY;
    }

    public static <T> T getMissingDataValue(Class<T> c) {
        if (c == Double.class) {
            return (T)new Double(JAMS.getMissingDataValue());
        }
        if (c == Integer.class) {
            return (T)new Integer(Integer.MAX_VALUE);
        }
        if (c == Long.class) {
            return (T)new Long(Long.MAX_VALUE);
        }
        if (c == String.class) {
            return null;
        }
        throw new JAMSException("No missing value defined for class type " + c.toString());
    }

    public static void initBaseDir(String parameterFileName) {
        File f = new File(parameterFileName);
        if (f.exists()) {
            baseDir = f.getAbsoluteFile().getParentFile();
        } else {
            try {
                File jarFile = new File(JAMS.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                baseDir = jarFile.getParentFile().getParentFile();
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(JAMS.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.setProperty("user.dir", baseDir.getAbsolutePath());
        File libDirFile = new File(baseDir, "lib");
        if (libDirFile.exists()) {
            libDir = libDirFile;
        }
    }

    public static void initBaseDir() {
        if (baseDir == null) {
            JAMS.initBaseDir(DEFAULT_PROPERTY_FILENAME);
        }
    }

    public static File getLibDir() {
        if (libDir == null) {
            JAMS.initBaseDir();
        }
        return libDir;
    }

    public static File getBaseDir() {
        if (baseDir == null) {
            JAMS.initBaseDir();
        }
        return baseDir;
    }

    public static Map<String, Object> getObjectRepo() {
        return objectRepo;
    }

    static {
        objectRepo = new HashMap<String, Object>();
    }
}

