/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import junit.framework.TestCase;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;

public class TestLatLonProjection
extends TestCase {
    private LatLonProjection p;

    public TestLatLonProjection(String name) {
        super(name);
    }

    public void setUp() {
        this.p = new LatLonProjection();
    }

    void runCenter() {
        LatLonPointImpl ptL = new LatLonPointImpl(-73.79, 0.0);
        double xinc = 22.5;
        double yinc = 20.0;
        for (double lon = 0.0; lon < 380.0; lon += xinc) {
            ptL.setLongitude(lon);
            LatLonRect llbb = new LatLonRect((LatLonPoint)ptL, yinc, xinc);
            ProjectionRect ma2 = this.p.latLonToProjBB(llbb);
            LatLonRect p2 = this.p.projToLatLonBB(ma2);
            assert (llbb.equals(p2)) : llbb + " => " + ma2 + " => " + p2;
            System.out.println(llbb + " => " + p2);
        }
    }

    void runCenter(double center) {
        LatLonPointImpl ptL = new LatLonPointImpl(0.0, 0.0);
        double xinc = 22.5;
        double yinc = 20.0;
        for (double lon = 0.0; lon < 380.0; lon += xinc) {
            ptL.setLongitude(center + lon);
            LatLonRect llbb = new LatLonRect((LatLonPoint)ptL, yinc, xinc);
            ProjectionRect ma2 = this.p.latLonToProjBB(llbb);
            LatLonRect p2 = this.p.projToLatLonBB(ma2);
            assert (llbb.equals(p2)) : llbb + " => " + ma2 + " => " + p2;
            System.out.println(llbb + " => " + p2);
        }
    }

    public void testLatLonToProjBB() {
        this.runCenter();
        this.runCenter(110.45454545454547);
        this.runCenter(-110.45454545454547);
        this.runCenter(0.0);
        this.runCenter(420.0);
    }

    public LatLonRect testIntersection(LatLonRect bbox, LatLonRect bbox2) {
        System.out.println("\n     bbox= " + bbox.toString2());
        System.out.println("    bbox2= " + bbox2.toString2());
        LatLonRect result = bbox.intersect(bbox2);
        System.out.println("intersect= " + (result == null ? "null" : result.toString2()));
        if (result != null) assert (bbox.intersect(bbox2).equals(bbox2.intersect(bbox)));
        return result;
    }

    public void testIntersection() {
        LatLonRect bbox = new LatLonRect((LatLonPoint)new LatLonPointImpl(40.0, -100.0), 10.0, 20.0);
        LatLonRect bbox2 = new LatLonRect((LatLonPoint)new LatLonPointImpl(-40.0, -180.0), 120.0, 300.0);
        assert (this.testIntersection(bbox, bbox2) != null);
        bbox = new LatLonRect((LatLonPoint)new LatLonPointImpl(-90.0, -100.0), 90.0, 300.0);
        bbox2 = new LatLonRect((LatLonPoint)new LatLonPointImpl(-40.0, -180.0), 120.0, 300.0);
        assert (this.testIntersection(bbox, bbox2) != null);
        bbox2 = new LatLonRect((LatLonPoint)new LatLonPointImpl(10.0, -180.0), 120.0, 300.0);
        assert (this.testIntersection(bbox, bbox2) == null);
        bbox = new LatLonRect((LatLonPoint)new LatLonPointImpl(-90.0, -100.0), 90.0, 200.0);
        bbox2 = new LatLonRect((LatLonPoint)new LatLonPointImpl(-40.0, 120.0), 120.0, 300.0);
        assert (this.testIntersection(bbox, bbox2) != null);
        bbox = new LatLonRect((LatLonPoint)new LatLonPointImpl(-90.0, -100.0), 90.0, 200.0);
        bbox2 = new LatLonRect((LatLonPoint)new LatLonPointImpl(-40.0, -220.0), 120.0, 140.0);
        assert (this.testIntersection(bbox, bbox2) != null);
    }

    private LatLonRect testExtend(LatLonRect bbox, LatLonRect bbox2) {
        System.out.println("\n bbox =" + bbox.toString2() + " width=" + bbox.getWidth());
        System.out.println(" bbox extend by=" + bbox2.toString2() + " width=" + bbox2.getWidth());
        bbox.extend(bbox2);
        System.out.println(" result=" + bbox.toString2() + " width=" + bbox.getWidth());
        return bbox;
    }

    public void testExtend() {
        LatLonRect bbox = this.testExtend(new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, 30.0), (LatLonPoint)new LatLonPointImpl(-60.0, 120.0)), new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, -10.0), (LatLonPoint)new LatLonPointImpl(-60.0, 55.0)));
        assert (bbox.getWidth() == 130.0);
        assert (!bbox.crossDateline());
        bbox = this.testExtend(new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, -200.0), (LatLonPoint)new LatLonPointImpl(-60.0, -100.0)), new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, 177.0), (LatLonPoint)new LatLonPointImpl(-60.0, 200.0)));
        assert (bbox.getWidth() == 100.0);
        assert (bbox.crossDateline());
        bbox = this.testExtend(new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, -200.0), (LatLonPoint)new LatLonPointImpl(-60.0, -100.0)), new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, -150.0), (LatLonPoint)new LatLonPointImpl(-60.0, 200.0)));
        assert (bbox.getWidth() == 360.0);
        assert (!bbox.crossDateline());
        bbox = this.testExtend(new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, -180.0), (LatLonPoint)new LatLonPointImpl(-60.0, 135.0)), new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, 135.0), (LatLonPoint)new LatLonPointImpl(-60.0, 180.0)));
        assert (bbox.getWidth() == 360.0);
        assert (!bbox.crossDateline());
        bbox = this.testExtend(new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, -180.0), (LatLonPoint)new LatLonPointImpl(-60.0, 0.0)), new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, 135.0), (LatLonPoint)new LatLonPointImpl(-60.0, 160.0)));
        assert (bbox.getWidth() == 225.0);
        assert (bbox.crossDateline());
        bbox = this.testExtend(new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, -180.0), (LatLonPoint)new LatLonPointImpl(-60.0, 0.0)), new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, 135.0), (LatLonPoint)new LatLonPointImpl(-60.0, 180.0)));
        assert (bbox.getWidth() == 225.0);
        assert (bbox.crossDateline());
        bbox = this.testExtend(new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, 135.0), (LatLonPoint)new LatLonPointImpl(-60.0, 180.0)), new LatLonRect((LatLonPoint)new LatLonPointImpl(-81.0, -180.0), (LatLonPoint)new LatLonPointImpl(-60.0, 0.0)));
        assert (bbox.getWidth() == 225.0);
        assert (bbox.crossDateline());
    }
}

