/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.cache;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestLocal;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.util.StringUtil;

public class TestNetcdfFileCache
extends TestCase {
    FileCache cache;
    FileFactory factory = new MyFileFactory();
    int count = 0;
    int N = 10000;
    int PROD_THREAD = 10;
    int CONS_THREAD = 10;
    int SKIP = 100;

    public TestNetcdfFileCache(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.cache = new FileCache(5, 100, 3600);
    }

    public void testNetcdfFileCache() throws IOException {
        FileCache.CacheElement elem;
        this.loadFiles(new File(TestLocal.cdmTestDataDir), this.cache);
        System.out.println(" loaded " + this.count);
        this.cache.showCache(new Formatter(System.out));
        Map map = this.cache.getCache();
        assert (map.values().size() == this.count);
        for (Object key : map.keySet()) {
            FileCache.CacheElement elem2 = (FileCache.CacheElement)map.get(key);
            assert (elem2.list.size() == 1);
        }
        int saveCount = this.count;
        this.loadFiles(new File(TestLocal.cdmTestDataDir), this.cache);
        map = this.cache.getCache();
        assert (map.values().size() == saveCount);
        for (Object key : map.keySet()) {
            FileCache.CacheElement elem3 = (FileCache.CacheElement)map.get(key);
            assert (elem3.list.size() == 2);
            this.checkAllSame(elem3.list);
        }
        this.cache.clearCache(true);
        map = this.cache.getCache();
        assert (map.values().size() == 0);
        this.loadFiles(new File(TestLocal.cdmTestDataDir), this.cache);
        map = this.cache.getCache();
        assert (map.values().size() == saveCount);
        ArrayList<FileCacheable> files = new ArrayList<FileCacheable>();
        for (Object key : map.keySet()) {
            elem = (FileCache.CacheElement)map.get(key);
            assert (elem.list.size() == 1);
            for (FileCache.CacheElement.CacheFile file : elem.list) {
                files.add(file.ncfile);
            }
        }
        for (FileCacheable ncfile : files) {
            ncfile.close();
        }
        this.cache.clearCache(false);
        map = this.cache.getCache();
        assert (map.values().size() == 0) : map.values().size();
        this.loadFiles(new File(TestLocal.cdmTestDataDir), this.cache);
        this.loadFiles(new File(TestLocal.cdmTestDataDir), this.cache);
        map = this.cache.getCache();
        assert (map.values().size() == saveCount);
        for (Object key : map.keySet()) {
            elem = (FileCache.CacheElement)map.get(key);
            assert (elem.list.size() == 2);
            FileCache.CacheElement.CacheFile first = (FileCache.CacheElement.CacheFile)elem.list.get(0);
            first.ncfile.close();
            assert (!first.isLocked.get());
            assert (elem.list.size() == 2);
        }
        map = this.cache.getCache();
        assert (map.values().size() == saveCount);
        this.cache.clearCache(false);
        map = this.cache.getCache();
        assert (map.values().size() == saveCount);
        for (Object key : map.keySet()) {
            elem = (FileCache.CacheElement)map.get(key);
            assert (elem.list.size() == 1);
        }
        this.cache.clearCache(true);
    }

    void checkAllSame(List<FileCache.CacheElement.CacheFile> list) {
        FileCache.CacheElement.CacheFile first = null;
        for (FileCache.CacheElement.CacheFile file : list) {
            assert (file.isLocked.get());
            assert (file.countAccessed == 1);
            assert (file.lastAccessed != 0L);
            if (first == null) {
                first = file;
                continue;
            }
            assert (first.ncfile.getLocation().equals(file.ncfile.getLocation()));
            assert (first.lastAccessed < file.lastAccessed);
        }
    }

    void loadFiles(File dir, FileCache cache) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.loadFiles(f, cache);
                continue;
            }
            if (!f.getPath().endsWith(".nc") || f.length() <= 0L) continue;
            try {
                String want = StringUtil.replace((String)f.getPath(), (char)'\\', (String)"/");
                cache.acquire(this.factory, want, null);
                ++this.count;
            }
            catch (IOException e) {
                System.out.println(" *** failed on " + f.getPath());
            }
        }
    }

    public void testPeriodicClear() throws IOException {
        FileCache cache = new FileCache(0, 10, 3600);
        this.testPeriodicCleanup(cache);
        Map map = cache.getCache();
        assert (map.values().size() == 0) : map.values().size();
        cache = new FileCache(5, 10, 3600);
        this.testPeriodicCleanup(cache);
        map = cache.getCache();
        assert (map.values().size() == 5) : map.values().size();
    }

    private void testPeriodicCleanup(FileCache cache) throws IOException {
        this.loadFiles(new File(TestLocal.cdmTestDataDir), cache);
        System.out.println(" loaded " + this.count);
        Map map = cache.getCache();
        ArrayList<FileCacheable> files = new ArrayList<FileCacheable>();
        for (Object key : map.keySet()) {
            FileCache.CacheElement elem = (FileCache.CacheElement)map.get(key);
            assert (elem.list.size() == 1);
            for (FileCache.CacheElement.CacheFile file : elem.list) {
                files.add(file.ncfile);
            }
        }
        System.out.println(" close " + files.size());
        for (FileCacheable ncfile : files) {
            ncfile.close();
        }
        cache.showCache(new Formatter(System.out));
        cache.cleanup(10);
    }

    public void testConcurrentAccess() throws InterruptedException {
        this.loadFiles(new File(TestLocal.cdmTestDataDir), this.cache);
        Map map = this.cache.getCache();
        ArrayList<String> files = new ArrayList<String>();
        for (Object key : map.keySet()) {
            FileCache.CacheElement elem = (FileCache.CacheElement)map.get(key);
            for (FileCache.CacheElement.CacheFile file : elem.list) {
                files.add(file.ncfile.getLocation());
            }
        }
        Random r = new Random();
        int nfiles = files.size();
        Formatter format = new Formatter(System.out);
        ConcurrentLinkedQueue<Future> q = new ConcurrentLinkedQueue<Future>();
        ExecutorService qexec = Executors.newFixedThreadPool(this.CONS_THREAD);
        qexec.submit(new Consumer(q, format));
        ExecutorService exec = Executors.newFixedThreadPool(this.PROD_THREAD);
        for (int i = 0; i < this.N; ++i) {
            int findex = r.nextInt(nfiles);
            String location = (String)files.get(findex);
            q.add(exec.submit(new CallAcquire(location)));
            if (i % this.SKIP != 0) continue;
            format.format(" %3d qsize= %3d ", i, q.size());
            this.cache.showStats(format);
        }
        format.format("awaitTermination 10 secs qsize= %3d\n", q.size());
        this.cache.showStats(format);
        exec.awaitTermination(10L, TimeUnit.SECONDS);
        format.format("done qsize= %4d\n", q.size());
        this.cache.showStats(format);
        int total = 0;
        int total_locks = 0;
        HashSet checkUnique = new HashSet();
        map = this.cache.getCache();
        for (Object key : map.keySet()) {
            assert (!checkUnique.contains(key));
            checkUnique.add(key);
            FileCache.CacheElement elem = (FileCache.CacheElement)map.get(key);
            int locks = 0;
            for (FileCache.CacheElement.CacheFile file : elem.list) {
                if (!file.isLocked.get()) continue;
                ++locks;
            }
            total_locks += locks;
            total += elem.list.size();
        }
        System.out.println(" total=" + total + " total_locks=" + total_locks);
        this.cache.clearCache(false);
        format.format("after cleanup qsize= %4d\n", q.size());
        this.cache.showStats(format);
        this.cache.clearCache(true);
    }

    class RunClose
    implements Runnable {
        NetcdfFile f;

        RunClose(NetcdfFile f) {
            this.f = f;
        }

        @Override
        public void run() {
            try {
                this.f.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class CallAcquire
    implements Callable<FileCacheable> {
        String location;

        CallAcquire(String location) {
            this.location = location;
        }

        @Override
        public FileCacheable call() throws Exception {
            return TestNetcdfFileCache.this.cache.acquire(TestNetcdfFileCache.this.factory, this.location, null);
        }
    }

    class Consumer
    implements Runnable {
        private final ConcurrentLinkedQueue<Future> queue;
        Formatter format;

        Consumer(ConcurrentLinkedQueue<Future> q, Formatter format) {
            this.queue = q;
            this.format = format;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.consume(this.queue.poll());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }

        void consume(Future x) throws ExecutionException, InterruptedException, IOException {
            if (x == null) {
                return;
            }
            if (x.isDone()) {
                NetcdfFile ncfile = (NetcdfFile)x.get();
                ncfile.close();
            } else {
                this.queue.add(x);
            }
        }
    }

    class MyFileFactory
    implements FileFactory {
        MyFileFactory() {
        }

        public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDataset.openFile((String)location, (int)buffer_size, (CancelTask)cancelTask, (Object)iospMessage);
        }
    }
}

