/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;
import ucar.unidata.io.RandomAccessFile;

public class TestOffAggExistingSSTA
extends TestCase {
    String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n    <aggregation dimName='time' type='joinExisting' recheckEvery='15 min'>\n      <variableAgg name='ATssta' />\n      <scan dateFormatMark='AT#yyyyDDD_HHmmss' location='" + TestAll.cdmUnitTestDir + "ncml/nc/pfeg/' suffix='.nc' />\n" + "    </aggregation>\n" + "</netcdf>";

    public TestOffAggExistingSSTA(String name) {
        super(name);
    }

    public void testSSTA() throws IOException, InvalidRangeException {
        String filename = "file:" + TestNcML.topDir + "offsite/aggExistingSSTA.xml";
        RandomAccessFile.setDebugLeaks((boolean)true);
        List openfiles = RandomAccessFile.getOpenFiles();
        int count = openfiles.size();
        System.out.println("count files at start=" + count);
        NetcdfDataset.disableNetcdfFileCache();
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(this.ncml), (String)filename, null);
        System.out.println(" TestNcmlAggExisting.open " + filename);
        Array ATssta = ncfile.readSection("ATssta(:,0,0,0)");
        int count1 = RandomAccessFile.getOpenFiles().size();
        System.out.println("count files after open=" + count1);
        ncfile.close();
        int count2 = RandomAccessFile.getOpenFiles().size();
        System.out.println("count files after close=" + count2);
        assert (count1 == count2) : "openFile count " + count + "!=" + count2;
    }
}

