/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.Date;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.util.DiskCache2;

public class TestAggExistingCached
extends TestCase {
    String filename = "dods://localhost:8080/thredds/dodsC/aggCacheTest/aggExisting4.ncml";
    double[] result = new double[]{1.1496816E9, 1.1496852E9, 1.1496888E9};

    public TestAggExistingCached(String name) {
        super(name);
    }

    public void setUp() {
        Aggregation.setPersistenceCache((DiskCache2)new DiskCache2("/.unidata/cachePersist", true, 43200, 60));
    }

    public void testNcmlDirect() throws IOException, InvalidRangeException {
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)this.filename, (boolean)false, null);
        System.out.println("\n TestNcmlAggExistingCached.open " + this.filename);
        this.testAggCoordVar((NetcdfFile)ncfile);
        this.testAggCoordVarSubset((NetcdfFile)ncfile);
        this.testAggCoordVarSubsetDefeatLocalCache((NetcdfFile)ncfile);
        ncfile.close();
    }

    public void testNcmlCached() throws IOException, InvalidRangeException {
        System.out.println("\n TestNcmlAggExistingCached.acquire at " + new Date());
        NetcdfDataset ncfile = NetcdfDataset.acquireDataset((String)this.filename, null);
        this.testAggCoordVar((NetcdfFile)ncfile);
        ncfile.close();
        System.out.println("\n TestNcmlAggExistingCached.acquire again at " + new Date());
        ncfile = NetcdfDataset.acquireDataset((String)this.filename, null);
        this.testAggCoordVar((NetcdfFile)ncfile);
        ncfile.close();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("\n TestNcmlAggExistingCached.acquire after sleeping " + new Date());
        ncfile = NetcdfDataset.acquireDataset((String)this.filename, null);
        this.testAggCoordVar((NetcdfFile)ncfile);
        ncfile.close();
        NetcdfDataset.getNetcdfFileCache().clearCache(false);
        System.out.println("\n TestNcmlAggExistingCached.acquire after flushing cache " + new Date());
        ncfile = NetcdfDataset.acquireDataset((String)this.filename, null);
        this.testAggCoordVar((NetcdfFile)ncfile);
        this.testAggCoordVarSubset((NetcdfFile)ncfile);
        ncfile.close();
    }

    public void testAggCoordVar(NetcdfFile ncfile) {
        block15: {
            Variable time = ncfile.findVariable("time");
            assert (null != time);
            assert (time.getName().equals("time"));
            assert (time.getRank() == 1);
            assert (time.getSize() == 3L);
            assert (time.getShape()[0] == 3);
            assert (time.getDataType() == DataType.DOUBLE);
            assert (time.getDimension(0) == ncfile.findDimension("time"));
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == 3L);
                assert (data.getShape()[0] == 3);
                assert (data.getElementType() == Double.TYPE);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    assert (TestAll.closeEnough(dataI.getDoubleNext(), this.result[count]));
                    ++count;
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
    }

    public void testAggCoordVarSubset(NetcdfFile ncfile) throws InvalidRangeException, IOException {
        Variable time = ncfile.findVariable("time");
        assert (null != time);
        assert (time.getName().equals("time"));
        assert (time.getRank() == 1);
        assert (time.getSize() == 3L);
        assert (time.getShape()[0] == 3);
        assert (time.getDataType() == DataType.DOUBLE);
        assert (time.getDimension(0) == ncfile.findDimension("time"));
        Array data = time.read("1:2");
        assert (data.getRank() == 1);
        assert (data.getSize() == 2L);
        assert (data.getShape()[0] == 2);
        assert (data.getElementType() == Double.TYPE);
        int count = 0;
        IndexIterator dataI = data.getIndexIterator();
        while (dataI.hasNext()) {
            assert (TestAll.closeEnough(dataI.getDoubleNext(), this.result[count + 1]));
            ++count;
        }
        data = time.read("0:2:2");
        assert (data.getRank() == 1);
        assert (data.getSize() == 2L);
        assert (data.getShape()[0] == 2);
        assert (data.getElementType() == Double.TYPE);
        count = 0;
        dataI = data.getIndexIterator();
        while (dataI.hasNext()) {
            assert (TestAll.closeEnough(dataI.getDoubleNext(), this.result[count * 2]));
            ++count;
        }
    }

    public void testAggCoordVarSubsetDefeatLocalCache(NetcdfFile ncfile) throws InvalidRangeException, IOException {
        Variable time = ncfile.findVariable("time");
        assert (null != time);
        assert (time.getName().equals("time"));
        assert (time.getRank() == 1);
        assert (time.getSize() == 3L);
        assert (time.getShape()[0] == 3);
        assert (time.getDataType() == DataType.DOUBLE);
        assert (time.getDimension(0) == ncfile.findDimension("time"));
        time.setCachedData(null, false);
        Array data = time.read("1:2");
        assert (data.getRank() == 1);
        assert (data.getSize() == 2L);
        assert (data.getShape()[0] == 2);
        assert (data.getElementType() == Double.TYPE);
        int count = 0;
        IndexIterator dataI = data.getIndexIterator();
        while (dataI.hasNext()) {
            assert (TestAll.closeEnough(dataI.getDoubleNext(), this.result[count + 1]));
            ++count;
        }
        time.setCachedData(null, false);
        data = time.read("0:2:2");
        assert (data.getRank() == 1);
        assert (data.getSize() == 2L);
        assert (data.getShape()[0] == 2);
        assert (data.getElementType() == Double.TYPE);
        count = 0;
        dataI = data.getIndexIterator();
        while (dataI.hasNext()) {
            assert (TestAll.closeEnough(dataI.getDoubleNext(), this.result[count * 2]));
            ++count;
        }
    }
}

