/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.hdf5.TestH5;

public class TestH5eos
extends TestCase {
    public TestH5eos(String name) {
        super(name);
    }

    public void testStructMetadata() throws IOException {
        Array A;
        NetcdfFile ncfile = TestH5.openH5("eos/HIRDLS/HIRDLS2-Aura73p_b029_2000d275.he5");
        Group root = ncfile.getRootGroup();
        Group g = root.findGroup("HDFEOS INFORMATION");
        Variable dset = g.findVariable("StructMetadata.0");
        assert (null != dset);
        assert (dset.getDataType() == DataType.CHAR);
        try {
            A = dset.read();
        }
        catch (IOException e) {
            System.err.println("ERROR reading file");
            assert (false);
            return;
        }
        assert (A.getRank() == 1);
        assert (A instanceof ArrayChar);
        ArrayChar ca = (ArrayChar)A;
        String sval = ca.getString();
        System.out.println(dset.getName());
        System.out.println(" Length = " + sval.length());
        System.out.println(" Value = " + sval);
        ncfile.close();
    }

    public void test1() throws IOException {
        NetcdfFile ncfile = TestH5.openH5("eos/HIRDLS/HIR2ARSP_c3_na.he5");
        Variable v = ncfile.findVariable("HDFEOS/SWATHS/H2SO4_H2O_Tisdale/Data Fields/Wavenumber");
        assert (v != null);
        Dimension dim = v.getDimension(0);
        assert (dim != null);
        assert (dim.getName() != null);
        assert (dim.getName().equals("nChans"));
        ncfile.close();
    }

    public void test2() throws IOException {
        NetcdfFile ncfile = TestH5.openH5("eos/HIRDLS/HIRDLS1_v4.0.2a-aIrix-c2_2003d106.he5");
        Variable v = ncfile.findVariable("HDFEOS/SWATHS/HIRDLS_L1_Swath/Data Fields/Elevation Angle");
        assert (v != null);
        assert (v.getRank() == 4);
        assert (v.getDimension(0).getName().equals("MaF"));
        assert (v.getDimension(1).getName().equals("MiF"));
        assert (v.getDimension(2).getName().equals("CR"));
        assert (v.getDimension(3).getName().equals("CC"));
        ncfile.close();
    }
}

