/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.hdf5.TestChunkIndexer;
import ucar.nc2.iosp.hdf5.TestH5ReadAndCount;
import ucar.nc2.iosp.hdf5.TestH5ReadArray;
import ucar.nc2.iosp.hdf5.TestH5ReadBasic;
import ucar.nc2.iosp.hdf5.TestH5ReadStructure;
import ucar.nc2.iosp.hdf5.TestH5ReadStructure2;
import ucar.nc2.iosp.hdf5.TestH5Vlength;
import ucar.nc2.iosp.hdf5.TestH5aura;
import ucar.nc2.iosp.hdf5.TestH5compressed;
import ucar.nc2.iosp.hdf5.TestH5eos;
import ucar.nc2.iosp.hdf5.TestH5filter;
import ucar.nc2.iosp.hdf5.TestH5npoess;
import ucar.nc2.iosp.hdf5.TestH5read;
import ucar.nc2.iosp.hdf5.TestN4;
import ucar.nc2.iosp.hdf5.TestOddTypes;

public class TestH5 {
    public static boolean dumpFile = false;
    public static String testDir = TestAll.testdataDir + "hdf5/";

    public static NetcdfFile open(String filename) {
        try {
            System.out.println("**** Open " + filename);
            NetcdfFile ncfile = NetcdfFile.open((String)filename);
            if (dumpFile) {
                System.out.println("open " + ncfile);
            }
            return ncfile;
        }
        catch (IOException e) {
            System.out.println(" fail = " + e);
            e.printStackTrace();
            assert (false);
            return null;
        }
    }

    public static NetcdfFile openH5(String filename) {
        try {
            System.out.println("**** Open " + TestAll.testdataDir + "hdf5/" + filename);
            NetcdfFile ncfile = NetcdfFile.open((String)(TestAll.testdataDir + "hdf5/" + filename));
            if (dumpFile) {
                System.out.println("open H5 " + ncfile);
            }
            return ncfile;
        }
        catch (IOException e) {
            System.out.println(" fail = " + e);
            e.printStackTrace();
            assert (false);
            return null;
        }
    }

    public static NetcdfDataset openH5dataset(String filename) {
        try {
            System.out.println("**** Open " + TestAll.testdataDir + "hdf5/" + filename);
            NetcdfDataset ncfile = NetcdfDataset.openDataset((String)(TestAll.testdataDir + "hdf5/" + filename));
            if (dumpFile) {
                System.out.println("open H5 " + ncfile);
            }
            return ncfile;
        }
        catch (IOException e) {
            System.out.println(" fail = " + e);
            e.printStackTrace();
            assert (false);
            return null;
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestSuite(TestH5ReadBasic.class));
        suite.addTest((Test)new TestSuite(TestH5ReadAndCount.class));
        suite.addTest((Test)new TestSuite(TestH5ReadStructure.class));
        suite.addTest((Test)new TestSuite(TestH5ReadStructure2.class));
        suite.addTest((Test)new TestSuite(TestH5Vlength.class));
        suite.addTest((Test)new TestSuite(TestH5ReadArray.class));
        suite.addTest((Test)new TestSuite(TestOddTypes.class));
        suite.addTest((Test)new TestSuite(TestH5compressed.class));
        suite.addTest((Test)new TestSuite(TestChunkIndexer.class));
        suite.addTest((Test)new TestSuite(TestH5filter.class));
        suite.addTest((Test)new TestSuite(TestH5eos.class));
        suite.addTest((Test)new TestSuite(TestH5aura.class));
        suite.addTest((Test)new TestSuite(TestH5npoess.class));
        suite.addTest((Test)new TestSuite(TestN4.class));
        suite.addTest((Test)new TestSuite(TestH5read.class));
        return suite;
    }
}

