/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;

public class TestOfsData
extends TestCase {
    public TestOfsData(String name) {
        super(name);
    }

    public void testCompare() throws IOException {
        File where = new File("C:/data/grib/richSection");
        if (where.exists()) {
            String[] args = new String[]{where.getPath()};
            this.doAll(args);
        } else {
            this.doAll(null);
        }
    }

    void doAll(String[] args) throws IOException {
        String dirB1 = args == null || args.length < 1 ? TestAll.testdataDir + "grid/grib/grib2/section/20091122" : args[0] + "/section";
        File dir = new File(dirB1);
        if (dir.isDirectory()) {
            String[] children;
            System.out.println("In directory " + dir.getParent() + "/" + dir.getName());
            for (String child : children = dir.list()) {
                File aChild = new File(dir, child);
                if (aChild.isDirectory() || child.length() == 0 || child.endsWith("ncml") || child.endsWith("gbx") || child.endsWith("gbx8") || child.endsWith("xml") || child.endsWith("nc") || child.startsWith("ls")) continue;
                System.out.println("\n\nReading File " + child);
                long start = System.currentTimeMillis();
                NetcdfFile ncfile = NetcdfFile.open((String)(dirB1 + "/" + child));
                List vars = ncfile.getVariables();
                for (Variable var : vars) {
                    List dims = var.getDimensions();
                    if (var.getName().startsWith("Latitude") || var.getName().startsWith("Longitude")) {
                        assert (var.getRank() == 2);
                        continue;
                    }
                    if (var.getName().startsWith("U-component")) {
                        assert (var.getRank() == 4);
                        assert (((Dimension)dims.get(0)).getName().startsWith("time"));
                        continue;
                    }
                    if (var.getName().startsWith("V-component")) {
                        assert (var.getRank() == 4);
                        assert (((Dimension)dims.get(0)).getName().startsWith("time"));
                        continue;
                    }
                    if (var.getName().startsWith("time") || var.getName().startsWith("depth")) {
                        assert (var.getRank() == 1);
                        continue;
                    }
                    if (var.getName().startsWith("Curvilinear")) continue;
                    assert (var.getRank() > 2);
                    assert (((Dimension)dims.get(0)).getName().startsWith("time"));
                }
                ncfile.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        TestOfsData od = new TestOfsData("");
        od.testCompare();
    }
}

