/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import ucar.nc2.iosp.bufr.tables.CodeFlagTables;
import ucar.unidata.util.StringUtil;

public class CompareCodeTables {
    char[] remove = new char[]{'(', ')', ' ', '\"', ',', '*', '-'};
    String[] replace = new String[]{"", "", "", "", "", "", ""};

    String fxy(int fxy) {
        int f = fxy >> 16;
        int x = (fxy & 0xFF00) >> 8;
        int y = fxy & 0xFF;
        return f + "-" + x + "-" + y;
    }

    void readWmoCsv(String filename, Map<Integer, Feature> wmoMap) throws IOException {
        BufferedReader dataIS = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), Charset.forName("UTF-8")));
        int count = 0;
        int currSeqno = -1;
        Feature currSeq = null;
        while (true) {
            String[] flds;
            String line = dataIS.readLine();
            ++count;
            if (line == null) break;
            if (line.startsWith("#")) continue;
            if (count == 1) {
                System.out.println("header line == " + line);
                continue;
            }
            int pos1 = line.indexOf(34);
            if (pos1 >= 0) {
                int pos2 = line.indexOf(34, pos1 + 1);
                StringBuffer sb = new StringBuffer(line);
                for (int i = pos1; i < pos2; ++i) {
                    if (sb.charAt(i) != ',') continue;
                    sb.setCharAt(i, ' ');
                }
                line = sb.toString();
            }
            if ((flds = line.split(",")).length < 4) {
                System.out.printf("%d INCOMPLETE line == %s%n", count, line);
                continue;
            }
            int fldidx = 0;
            try {
                int sno = Integer.parseInt(flds[fldidx++]);
                int seq = Integer.parseInt(flds[fldidx++]);
                String codeFigure = flds[fldidx++];
                String desc1 = flds[fldidx++];
                if (flds.length > 4) {
                    desc1 = desc1 + " & " + flds[fldidx++];
                }
                if (flds.length > 5) {
                    desc1 = desc1 + " & " + flds[fldidx++];
                }
                if (currSeqno != seq) {
                    int y = seq % 1000;
                    int w = seq / 1000;
                    int x = w % 100;
                    currSeq = new Feature(x, y);
                    wmoMap.put(currSeq.fxy, currSeq);
                    currSeqno = seq;
                }
                currSeq.addValue(codeFigure, desc1);
            }
            catch (Exception e) {
                System.out.printf("%d %d BAD line == %s%n", count, fldidx, line);
            }
        }
        int n = wmoMap.values().size();
        System.out.printf("%s lines=%d elems=%d%n", filename, count, n);
    }

    void compare1(Map<Integer, Feature> map) {
        System.out.printf("compare wmo to ours%n", new Object[0]);
        int countValues = 0;
        for (Integer key : map.keySet()) {
            String name2;
            String name;
            Feature f = map.get(key);
            CodeFlagTables t = CodeFlagTables.getTable((short)key.shortValue());
            if (t == null) {
                System.out.printf("%s missing in ours %n", f);
                continue;
            }
            Map tm = t.getMap();
            System.out.printf("%s%n", f);
            for (Integer code : f.map.keySet()) {
                name = f.map.get(code);
                name2 = (String)tm.get(code);
                if (name2 == null) {
                    System.out.printf("   %s missing in ours (%s) %n", code, name);
                    continue;
                }
                if (this.equiv(name, name2)) continue;
                System.out.printf("   %s %s != %s %n", code, name, name2);
            }
            for (Integer code : tm.keySet()) {
                name = (String)tm.get(code);
                name2 = f.map.get(code);
                if (name2 == null) {
                    System.out.printf("   %s missing in wmo%n", code);
                }
                ++countValues;
            }
        }
        System.out.printf("  enums=%s values=%d%n", map.keySet().size(), countValues);
    }

    void compare2(Map<Integer, Feature> map) {
        System.out.printf("compare ours to wmo%n", new Object[0]);
        Map ours = CodeFlagTables.tableMap;
        for (Short key : ours.keySet()) {
            Feature f = map.get(key.intValue());
            if (f != null) continue;
            CodeFlagTables t = (CodeFlagTables)ours.get(key);
            System.out.printf("%s missing in wmo %n", t.fxy());
        }
    }

    boolean equiv(String org1, String org2) {
        String s1 = StringUtil.replace((String)org1, (char[])this.remove, (String[])this.replace).toLowerCase();
        String s2 = StringUtil.replace((String)org2, (char[])this.remove, (String[])this.replace).toLowerCase();
        return s1.equals(s2);
    }

    public static void main(String[] args) throws IOException {
        TreeMap<Integer, Feature> wmoMap = new TreeMap<Integer, Feature>();
        CompareCodeTables ct = new CompareCodeTables();
        ct.readWmoCsv("C:/docs/BC_CodeFlagTable.csv", wmoMap);
        ct.compare1(wmoMap);
        ct.compare2(wmoMap);
    }

    class Feature {
        int fxy;
        String name;
        Map<Integer, String> map = new HashMap<Integer, String>(10);

        Feature(int x, int y) {
            this.fxy = (x << 8) + y;
        }

        private void addValue(String valueS, String text) {
            if (text.toLowerCase().contains("reserved")) {
                return;
            }
            text = StringUtil.remove((String)text, (int)34);
            try {
                int value = Integer.parseInt(valueS);
                this.map.put(value, text);
            }
            catch (Exception e) {
                System.out.printf("%s cant parse %s text = %s%n", this, valueS, text);
            }
        }

        public String toString() {
            return CompareCodeTables.this.fxy(this.fxy);
        }
    }
}

