/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.unidata.io.RandomAccessFile;

public class TestReadIDD
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadSamples() throws IOException {
        String location = TestAll.testdataDir + "bufr/sample.bufr";
        RandomAccessFile raf = new RandomAccessFile(location, "r");
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null) continue;
            if (!m.isBitCountOk()) {
                System.out.println(" skip " + m.getHeader());
                continue;
            }
            System.out.println(" read " + m.getHeader());
            NetcdfDataset ncd = null;
            try {
                byte[] mbytes = scan.getMessageBytes(m);
                NetcdfFile ncfile = NetcdfFile.openInMemory((String)"test", (byte[])mbytes);
                ncd = new NetcdfDataset(ncfile);
                Structure s = (Structure)ncd.findVariable("obs");
                assert (s != null);
                this.readAll(s);
            }
            finally {
                if (ncd != null) {
                    ncd.close();
                }
            }
            ++count;
        }
    }

    private void readAll(Structure s) throws IOException {
        ArrayStructure data = (ArrayStructure)s.read();
        for (Variable v : s.getVariables()) {
            if (v.getDataType() != DataType.SEQUENCE) continue;
            System.out.println("  *** seq " + v.getDataType() + " " + v.getName());
            int recno = 0;
            while ((long)recno < data.getSize()) {
                ArraySequence seq = data.getArraySequence(recno, data.findMember(v.getShortName()));
                StructureDataIterator iter = seq.getStructureDataIterator();
                while (iter.hasNext()) {
                    StructureData sdata = iter.next();
                }
                ++recno;
            }
        }
    }
}

