/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.dt.grid.TestGrid;

public class TestGridRanks
extends TestCase {
    private boolean show = false;

    public TestGridRanks(String name) {
        super(name);
    }

    public void testWrite() throws Exception {
        int i;
        NetcdfFileWriteable ncfile = new NetcdfFileWriteable();
        ncfile.setName(TestGrid.topDir + "rankTest.nc");
        Dimension xDim = ncfile.addDimension("x", 3);
        Dimension yDim = ncfile.addDimension("y", 5);
        Dimension zDim = ncfile.addDimension("z", 4);
        Dimension tDim = ncfile.addDimension("time", 2);
        Dimension z1Dim = ncfile.addDimension("z1", 1);
        Dimension t1Dim = ncfile.addDimension("time1", 1);
        ncfile.addVariable("time", Double.TYPE, new Dimension[]{tDim});
        ncfile.addVariableAttribute("time", "units", "secs since 1-1-1 00:00");
        ncfile.addVariable("z", Double.TYPE, new Dimension[]{zDim});
        ncfile.addVariableAttribute("z", "units", "meters");
        ncfile.addVariableAttribute("z", "positive", "up");
        ncfile.addVariable("y", Double.TYPE, new Dimension[]{yDim});
        ncfile.addVariableAttribute("y", "units", "degrees_north");
        ncfile.addVariable("x", Double.TYPE, new Dimension[]{xDim});
        ncfile.addVariableAttribute("x", "units", "degrees_east");
        ncfile.addVariable("time1", Double.TYPE, new Dimension[]{t1Dim});
        ncfile.addVariableAttribute("time1", "units", "secs since 1-1-1 00:00");
        ncfile.addVariable("z1", Double.TYPE, new Dimension[]{z1Dim});
        ncfile.addVariableAttribute("z1", "units", "meters");
        ncfile.addVariableAttribute("z1", "positive", "up");
        ncfile.addVariable("full4", Double.TYPE, new Dimension[]{tDim, zDim, yDim, xDim});
        ncfile.addVariable("withZ1", Double.TYPE, new Dimension[]{tDim, z1Dim, xDim, yDim});
        ncfile.addVariable("withT1", Double.TYPE, new Dimension[]{t1Dim, zDim, xDim, yDim});
        ncfile.addVariable("withT1Z1", Double.TYPE, new Dimension[]{t1Dim, z1Dim, xDim, yDim});
        ncfile.addVariable("full3", Double.TYPE, new Dimension[]{zDim, yDim, xDim});
        ncfile.addVariable("Z1noT", Double.TYPE, new Dimension[]{z1Dim, xDim, yDim});
        ncfile.addVariable("T1noZ", Double.TYPE, new Dimension[]{t1Dim, xDim, yDim});
        ncfile.addGlobalAttribute("Convention", "COARDS");
        ncfile.create();
        int len = tDim.getLength();
        ArrayDouble.D1 A = new ArrayDouble.D1(len);
        Index ima = A.getIndex();
        for (int i2 = 0; i2 < len; ++i2) {
            A.setDouble(ima.set(i2), (double)(i2 * 3600));
        }
        int[] origin = new int[1];
        ncfile.write("time", origin, (Array)A);
        len = t1Dim.getLength();
        A = new ArrayDouble.D1(len);
        ima = A.getIndex();
        for (i = 0; i < len; ++i) {
            A.setDouble(ima.set(i), (double)(i * 3600));
        }
        origin = new int[1];
        ncfile.write("time1", origin, (Array)A);
        len = zDim.getLength();
        A = new ArrayDouble.D1(len);
        ima = A.getIndex();
        for (i = 0; i < len; ++i) {
            A.setDouble(ima.set(i), (double)(i * 10));
        }
        ncfile.write("z", origin, (Array)A);
        len = z1Dim.getLength();
        A = new ArrayDouble.D1(len);
        ima = A.getIndex();
        for (i = 0; i < len; ++i) {
            A.setDouble(ima.set(i), (double)(i * 10));
        }
        ncfile.write("z1", origin, (Array)A);
        len = yDim.getLength();
        A = new ArrayDouble.D1(len);
        ima = A.getIndex();
        for (i = 0; i < len; ++i) {
            A.setDouble(ima.set(i), (double)(i * 3));
        }
        ncfile.write("y", origin, (Array)A);
        len = xDim.getLength();
        A = new ArrayDouble.D1(len);
        ima = A.getIndex();
        for (i = 0; i < len; ++i) {
            A.setDouble(ima.set(i), (double)(i * 5));
        }
        ncfile.write("x", origin, (Array)A);
        this.doWrite4(ncfile, "full4");
        this.doWrite4(ncfile, "withZ1");
        this.doWrite4(ncfile, "withT1");
        this.doWrite4(ncfile, "withT1Z1");
        this.doWrite3(ncfile, "full3");
        this.doWrite3(ncfile, "Z1noT");
        this.doWrite3(ncfile, "T1noZ");
        if (this.show) {
            System.out.println("ncfile = " + ncfile);
        }
        ncfile.close();
        System.out.println("*****************Test Write done");
    }

    private void doWrite4(NetcdfFileWriteable ncfile, String varName) throws Exception {
        Variable v = ncfile.findVariable(varName);
        int[] w = this.getWeights(v);
        int[] shape = v.getShape();
        Array aa = Array.factory((Class)v.getDataType().getPrimitiveClassType(), (int[])shape);
        Index ima = aa.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    for (int m = 0; m < shape[3]; ++m) {
                        aa.setDouble(ima.set(i, j, k, m), (double)(i * w[0] + j * w[1] + k * w[2] + m * w[3]));
                    }
                }
            }
        }
        ncfile.write(varName, aa);
    }

    private void doWrite3(NetcdfFileWriteable ncfile, String varName) throws Exception {
        Variable v = ncfile.findVariable(varName);
        int[] w = this.getWeights(v);
        int[] shape = v.getShape();
        Array aa = Array.factory((Class)v.getDataType().getPrimitiveClassType(), (int[])shape);
        Index ima = aa.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    aa.setDouble(ima.set(i, j, k), (double)(i * w[0] + j * w[1] + k * w[2]));
                }
            }
        }
        ncfile.write(varName, aa);
    }

    private int[] getWeights(Variable v) {
        int rank = v.getRank();
        int[] w = new int[rank];
        for (int n = 0; n < rank; ++n) {
            Dimension dim = v.getDimension(n);
            String dimName = dim.getName();
            if (dimName.equals("time")) {
                w[n] = 1000;
            }
            if (dimName.equals("z")) {
                w[n] = 100;
            }
            if (dimName.equals("y")) {
                w[n] = 10;
            }
            if (!dimName.equals("x")) continue;
            w[n] = 1;
        }
        return w;
    }

    public void testRead() throws Exception {
        GridDataset dataset = GridDataset.open((String)(TestGrid.topDir + "rankTest.nc"));
        this.doRead4(dataset, "full4");
        this.doRead4(dataset, "withZ1");
        this.doRead4(dataset, "withT1");
        this.doRead4(dataset, "withT1Z1");
        this.doRead3(dataset, "full3");
        this.doRead3(dataset, "Z1noT");
        this.doRead3(dataset, "T1noZ");
        this.doRead4Volume(dataset, "full4");
        this.doRead4Volume(dataset, "withZ1");
        this.doRead4Volume(dataset, "withT1");
        this.doRead3Volume(dataset, "T1noZ");
        this.doRead3XY(dataset, "full3");
        this.doRead3XY(dataset, "Z1noT");
        dataset.close();
        System.out.println("*****************Test Read done");
    }

    private void doRead4(GridDataset ds, String varName) throws IOException {
        GeoGrid gg = ds.findGridByName(varName);
        Array aa = gg.readDataSlice(-1, -1, -1, -1);
        int[] shape = aa.getShape();
        Index ima = aa.getIndex();
        int[] w = this.getWeights(gg);
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    for (int m = 0; m < shape[3]; ++m) {
                        double got = aa.getDouble(ima.set(i, j, k, m));
                        double want = i * w[0] + j * w[1] + k * w[2] + m * w[3];
                        assert (got == want) : "got " + got + " want " + want;
                    }
                }
            }
        }
        System.out.println("ok reading " + varName);
    }

    private void doRead3(GridDataset ds, String varName) throws IOException {
        GeoGrid gg = ds.findGridByName(varName);
        Array aa = gg.readDataSlice(-1, -1, -1, -1);
        int[] shape = aa.getShape();
        int[] w = this.getWeights(gg);
        Index ima = aa.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    double got = aa.getDouble(ima.set(i, j, k));
                    double want = i * w[0] + j * w[1] + k * w[2];
                    assert (got == want) : "got " + got + " want " + want;
                }
            }
        }
        System.out.println("ok reading " + varName);
    }

    private void doRead4Volume(GridDataset ds, String varName) throws IOException {
        GeoGrid gg = ds.findGridByName(varName);
        CoordinateAxis1DTime timeAxis = gg.getCoordinateSystem().getTimeAxis1D();
        int t = 0;
        while ((long)t < timeAxis.getSize()) {
            Array aa = gg.readVolumeData(t);
            int[] shape = aa.getShape();
            Index ima = aa.getIndex();
            for (int i = 0; i < shape[0]; ++i) {
                for (int j = 0; j < shape[1]; ++j) {
                    for (int k = 0; k < shape[2]; ++k) {
                        double got = aa.getDouble(ima.set(i, j, k));
                        double want = t * 1000 + i * 100 + j * 10 + k;
                        assert (got == want) : "got " + got + " want " + want;
                    }
                }
            }
            ++t;
        }
        System.out.println("*** ok reading doRead4Volume for " + varName);
    }

    private void doRead3Volume(GridDataset ds, String varName) throws IOException {
        GeoGrid gg = ds.findGridByName(varName);
        CoordinateAxis1DTime timeAxis = gg.getCoordinateSystem().getTimeAxis1D();
        int[] w = this.getWeights(gg);
        int t = 0;
        while ((long)t < timeAxis.getSize()) {
            Array aa = gg.readVolumeData(t);
            int[] shape = aa.getShape();
            Index ima = aa.getIndex();
            for (int i = 0; i < shape[0]; ++i) {
                for (int j = 0; j < shape[1]; ++j) {
                    double got = aa.getDouble(ima.set(i, j));
                    double want = t * 1000 + i * w[1] + j * w[2];
                    assert (got == want) : "got " + got + " want " + want;
                }
            }
            ++t;
        }
        System.out.println("*** ok reading doRead3Volume for " + varName);
    }

    private void doRead3XY(GridDataset ds, String varName) throws IOException {
        GeoGrid gg = ds.findGridByName(varName);
        CoordinateAxis1D zAxis = gg.getCoordinateSystem().getVerticalAxis();
        int[] w = this.getWeights(gg);
        int z = 0;
        while ((long)z < zAxis.getSize()) {
            Array aa = gg.readYXData(0, z);
            int[] shape = aa.getShape();
            Index ima = aa.getIndex();
            for (int i = 0; i < shape[0]; ++i) {
                for (int j = 0; j < shape[1]; ++j) {
                    double got = aa.getDouble(ima.set(i, j));
                    double want = z * 100 + i * w[1] + j * w[2];
                    assert (got == want) : "got " + got + " want " + want;
                }
            }
            ++z;
        }
        System.out.println("*** ok reading doRead3XY for " + varName);
    }

    private int[] getWeights(GeoGrid gg) {
        int rank = gg.getRank();
        int[] w = new int[rank];
        for (int n = 0; n < rank; ++n) {
            Dimension dim = gg.getDimension(n);
            String dimName = dim.getName();
            if (dimName.equals("time")) {
                w[n] = 1000;
            }
            if (dimName.equals("z")) {
                w[n] = 100;
            }
            if (dimName.equals("y")) {
                w[n] = 10;
            }
            if (!dimName.equals("x")) continue;
            w[n] = 1;
        }
        return w;
    }
}

