/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dods.TestLocalDodsServer;

public class TestTDSselect
extends TestCase {
    public TestTDSselect(String name) {
        super(name);
    }

    public void testStrings() throws IOException, InvalidRangeException {
        String url = TestLocalDodsServer.testdata + "testWrite.nc";
        NetcdfDataset dodsfile = NetcdfDataset.openDataset((String)url);
        Variable v = null;
        assert (null != (v = dodsfile.findVariable("svar")));
        assert (v.getName().equals("svar"));
        assert (v.getRank() == 1);
        assert (v.getSize() == 80L);
        assert (v.getDataType() == DataType.CHAR) : v.getDataType();
        Array a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 80L) : a.getSize();
        assert (a.getElementType() == DataType.CHAR.getPrimitiveClassType());
        a = v.read("1:10");
        assert (a.getRank() == 1);
        assert (a.getSize() == 10L) : a.getSize();
        assert (a.getElementType() == DataType.CHAR.getPrimitiveClassType());
        assert (null != (v = dodsfile.findVariable("names")));
        assert (v.getName().equals("names"));
        assert (v.getRank() == 2);
        assert (v.getSize() == 240L);
        assert (v.getDataType() == DataType.CHAR) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 2);
        assert (a.getSize() == 240L) : a.getSize();
        assert (a.getElementType() == DataType.CHAR.getPrimitiveClassType());
        a = v.read("0:1,1:10");
        assert (a.getRank() == 2);
        assert (a.getSize() == 20L) : a.getSize();
        assert (a.getElementType() == DataType.CHAR.getPrimitiveClassType());
    }
}

