/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dods.TestLocalDodsServer;
import ucar.unidata.util.StringUtil;

public class TestTDScompareWithFiles
extends TestCase {
    static boolean showCompare = false;
    static boolean showEach = false;
    static boolean showStringValues = false;
    String path = "ncdodsTest";
    String root = "C:/data/ncdodsTest/";

    public TestTDScompareWithFiles(String name) {
        super(name);
    }

    public void testCompare() throws IOException {
        this.doOne("conventions/zebra/SPOL_3Volumes.nc");
        this.doOne("conventions/coards/inittest24.QRIDV07200.ncml");
        this.doOne("conventions/atd/rgg.20020411.000000.lel.ll.nc");
        this.doOne("conventions/awips/awips.nc");
        this.doOne("conventions/cf/ipcc/cl_A1.nc");
        this.doOne("conventions/csm/o3monthly.nc");
        this.doOne("conventions/gdv/OceanDJF.nc");
        this.doOne("conventions/gief/coamps.wind_uv.nc");
        this.doOne("conventions/mars/temp_air_01082000.nc");
        this.doOne("conventions/mm5/n040.nc");
        this.doOne("conventions/nuwg/eta.nc");
        this.doOne("conventions/nuwg/ruc.nc");
        this.doOne("conventions/wrf/wrfout_v2_Lambert.nc");
        this.doOne("conventions/mm5/n040.nc");
    }

    public void testCompareAll() throws IOException {
        this.readAllDir(this.root + "ncml", ".ncml");
    }

    void readAllDir(String dirName, String suffix) throws IOException {
        File f;
        int i;
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        for (i = 0; i < allFiles.length; ++i) {
            String name;
            f = allFiles[i];
            if (f.isDirectory() || !(name = f.getAbsolutePath()).endsWith(suffix)) continue;
            this.doOne(name);
        }
        for (i = 0; i < allFiles.length; ++i) {
            f = allFiles[i];
            if (!f.isDirectory()) continue;
            this.readAllDir(allFiles[i].getAbsolutePath(), suffix);
        }
    }

    private void doOne(String filename) throws IOException {
        filename = StringUtil.replace((String)filename, (char)'\\', (String)"/");
        filename = StringUtil.remove((String)filename, (String)this.root);
        String dodsUrl = TestLocalDodsServer.alldata + filename;
        String localPath = this.root + filename;
        System.out.println("--Compare " + localPath + " to " + dodsUrl);
        this.compareDatasets(dodsUrl, localPath);
    }

    private void compareDatasets(String dodsUrl, String ncfile) throws IOException {
        NetcdfDataset org_ncfile = NetcdfDataset.openDataset((String)ncfile);
        NetcdfDataset dods_file = NetcdfDataset.openDataset((String)dodsUrl);
        this.compareDatasets((NetcdfFile)org_ncfile, (NetcdfFile)dods_file);
    }

    private void compareDatasets(NetcdfFile org, NetcdfFile dods) {
        if (org.getId() != null || dods.getId() != null) assert (org.getId().equals(dods.getId()));
        if (org.getTitle() != null || dods.getTitle() != null) assert (org.getTitle().equals(dods.getTitle()));
        this.compareGroups(org.getRootGroup(), dods.getRootGroup());
    }

    private void compareGroups(Group org, Group dods) {
        if (showCompare) {
            System.out.println("compareGroups  " + org.getName() + " " + dods.getName());
        }
        assert (org.getName().equals(dods.getName()));
        this.checkAll(org.getDimensions(), dods.getDimensions(), true);
        this.checkAll(org.getAttributes(), dods.getAttributes(), true);
        List vars = org.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable orgV = (Variable)vars.get(i);
            Variable dodsV = dods.findVariable(orgV.getShortName());
            assert (dodsV != null) : " cant find " + orgV.getName();
            this.compareVariables(orgV, dodsV);
        }
        ArrayList groups = this.checkAll(org.getGroups(), dods.getGroups(), true);
        for (int i = 0; i < groups.size(); i += 2) {
            Group orgGroup = (Group)groups.get(i);
            Group dodsGroup = (Group)groups.get(i + 1);
            this.compareGroups(orgGroup, dodsGroup);
        }
    }

    private void compareStringVariables(Variable org, Variable dods) {
        if (showCompare) {
            System.out.println("compareStringVariables  " + org.getName() + " " + dods.getName());
        }
        assert (org.getName().equals(dods.getName()));
        assert (org.getDataType() == DataType.CHAR);
        assert (dods.getDataType() == DataType.STRING);
        List orgDims = org.getDimensions();
        if (org.getRank() > 0) {
            assert (org.getRank() - 1 == dods.getRank());
            orgDims = orgDims.subList(0, org.getRank() - 1);
        }
        this.checkAll(orgDims, dods.getDimensions(), false);
        this.checkAll(org.getAttributes(), dods.getAttributes(), true);
        try {
            Array orgData = org.read();
            assert (orgData instanceof ArrayChar);
            ArrayChar.StringIterator siter = ((ArrayChar)orgData).getStringIterator();
            Array dodsData = dods.read();
            assert (dodsData instanceof ArrayObject);
            IndexIterator ii = dodsData.getIndexIterator();
            while (ii.hasNext()) {
                String dodsString = (String)ii.getObjectNext();
                String orgString = siter.next();
                if (showStringValues) {
                    System.out.println("org=<" + orgString + "> dods=<" + dodsString + ">");
                }
                assert (dodsString.equals(orgString)) : "<" + orgString + "> != <" + dodsString + ">";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void compareVariables(Variable org, Variable dods) {
        if (showCompare) {
            System.out.println("compareVariables  " + org.getName() + " " + dods.getName());
        }
        assert (org.getName().equals(dods.getName()));
        assert (org.getDataType() == dods.getDataType()) : org.getDataType() + " != " + dods.getDataType();
        this.checkAll(org.getDimensions(), dods.getDimensions(), true);
        this.check1in2(org.getAttributes(), dods.getAttributes());
        List atts = dods.getAttributes();
        for (int i = 0; i < atts.size(); ++i) {
            Attribute dodsAtt = (Attribute)atts.get(i);
            if (dodsAtt.getName().startsWith("_CoordinateAxes")) continue;
            Attribute orgAtt = dods.findAttribute(dodsAtt.getName());
            assert (orgAtt != null);
            assert (dodsAtt.equals((Object)orgAtt));
        }
        if (org instanceof Structure) {
            assert (dods instanceof Structure);
            Structure orgS = (Structure)org;
            Structure dodsS = (Structure)dods;
            ArrayList vars = this.checkAll(orgS.getVariables(), dodsS.getVariables(), true);
            for (int i = 0; i < vars.size(); i += 2) {
                Variable orgV = (Variable)vars.get(i);
                Variable dodsV = (Variable)vars.get(i + 1);
                this.compareVariables(orgV, dodsV);
            }
        }
    }

    public ArrayList checkAttributes(List list1, List list2, boolean required) {
        ArrayList result = new ArrayList();
        Iterator iter1 = list1.iterator();
        while (iter1.hasNext()) {
            this.checkEach(iter1.next(), list1, list2, result, required);
        }
        Iterator iter2 = list2.iterator();
        while (iter2.hasNext()) {
            this.checkEach(iter2.next(), list2, list1, null, required);
        }
        return result;
    }

    public ArrayList checkAll(List list1, List list2, boolean required) {
        ArrayList result = new ArrayList();
        Iterator iter1 = list1.iterator();
        while (iter1.hasNext()) {
            this.checkEach(iter1.next(), list1, list2, result, required);
        }
        Iterator iter2 = list2.iterator();
        while (iter2.hasNext()) {
            this.checkEach(iter2.next(), list2, list1, null, required);
        }
        return result;
    }

    public void check1in2(List list1, List list2) {
        Iterator iter1 = list1.iterator();
        while (iter1.hasNext()) {
            this.checkEach(iter1.next(), list1, list2, null, true);
        }
    }

    public void checkEach(Object want1, List list1, List list2, List result, boolean required) {
        int index2 = list2.indexOf(want1);
        if (required) {
            assert (index2 >= 0) : this.grabErr(want1 + " not in list 2");
        } else if (index2 < 0) {
            System.out.println("WARN: " + want1 + " not in list 2");
            return;
        }
        Object want2 = list2.get(index2);
        int index1 = list1.indexOf(want2);
        if (required) {
            assert (index1 >= 0) : want2 + " not in list 1";
        } else if (index1 < 0) {
            System.out.println("WARN: " + want2 + " not in list 1");
            return;
        }
        Object want = list1.get(index1);
        assert (want == want1) : want1 + " not == " + want;
        if (showEach) {
            System.out.println("  OK <" + want1 + "> equals <" + want2 + ">");
        }
        if (result != null) {
            result.add(want1);
            result.add(want2);
        }
    }

    private String grabErr(String s) {
        return "ERR= " + s;
    }

    public static void main(String[] args) throws IOException {
        TestTDScompareWithFiles t = new TestTDScompareWithFiles("dummy");
    }
}

