/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DODSStructure;

public class TestDODSStructureForSequence
extends TestCase {
    public TestDODSStructureForSequence(String name) {
        super(name);
    }

    public void testConstrainedAccess() {
        StructureDataIterator dodsIt;
        String dfsURL = "http://dods.jpl.nasa.gov/dods-bin/nph-dods/catalogs/quikscat/L2B/quikscat_L2.dat";
        String seqName = "QuikSCAT_L2B";
        String catTitleAttName = "DODS_Global.DODS_Title";
        String catAllowedDateRangeStartAttName = "DODS_Global.DODS_StartDate";
        String catAllowedDateRangeEndAttName = "DODS_Global.DODS_EndDate";
        DODSNetcdfFile dfs = null;
        try {
            dfs = new DODSNetcdfFile(dfsURL);
        }
        catch (IOException e) {
            TestDODSStructureForSequence.assertTrue((String)("Unexpected IOException connecting to JPL DODS File Server <" + dfsURL + ">: " + e.getMessage()), (boolean)false);
        }
        DODSStructure struct = (DODSStructure)dfs.findVariable(seqName);
        if (struct == null) {
            TestDODSStructureForSequence.assertTrue((String)("Did not find \"" + seqName + "\" variable on JPL DFS."), (boolean)false);
        }
        String ce = "&" + seqName + ".longitude>359.9" + "&" + seqName + ".longitude<359.9205";
        try {
            dodsIt = struct.getStructureIterator(ce);
        }
        catch (IOException e) {
            TestDODSStructureForSequence.assertTrue((String)("Unexpected IOException getting structure iterator for constraint <" + ce + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        this.entryTest(dodsIt, new BasicEntry(2000, 86, 5, 55, 27, 566, 359.9182f, 3999, 1624, "http://dods.jpl.nasa.gov/cgi-bin/nph-dods/pub/ocean_wind/quikscat/L2B/data/2000/086/QS_S2B03999.20001670430.Z"), 1.0E-4f);
        this.entryTest(dodsIt, new BasicEntry(2003, 276, 5, 55, 16, 791, 359.9203f, 22331, 1624, "http://dods.jpl.nasa.gov/cgi-bin/nph-dods/pub/ocean_wind/quikscat/L2B/data/2003/276/QS_S2B22331.20032762156.Z"), 1.0E-4f);
    }

    private void entryTest(StructureDataIterator dodsIt, BasicEntry expectedEntry, float longDelta) {
        StructureData curData;
        try {
            if (!dodsIt.hasNext()) {
                TestDODSStructureForSequence.assertTrue((String)"DODS result does not contain expected entry.", (boolean)false);
            }
            curData = dodsIt.next();
        }
        catch (IOException e) {
            TestDODSStructureForSequence.assertTrue((String)("Unexpected IOException reading from structure iterator: " + e.getMessage()), (boolean)false);
            return;
        }
        int year = curData.getScalarInt("year");
        int day = curData.getScalarInt("day");
        int hours = curData.getScalarInt("hours");
        int minutes = curData.getScalarInt("minutes");
        int seconds = curData.getScalarInt("seconds");
        int m_seconds = curData.getScalarInt("m_seconds");
        float longitude = curData.getScalarFloat("longitude");
        int rev_num = curData.getScalarInt("rev_num");
        int wvc_rows = curData.getScalarInt("wvc_rows");
        String dodsUrl = curData.getScalarString("DODS_URL");
        if (year != expectedEntry.getYear() || day != expectedEntry.getDay() || hours != expectedEntry.getHours() || minutes != expectedEntry.getMinutes() || seconds != expectedEntry.getSeconds() || m_seconds != expectedEntry.getM_seconds() || longitude > expectedEntry.getLongitude() + longDelta || longitude < expectedEntry.getLongitude() - longDelta || rev_num != expectedEntry.getRev_num() || wvc_rows != expectedEntry.getWvc_rows() || !dodsUrl.equals(expectedEntry.getDodsUrl())) {
            System.out.println("year = " + year + " should be " + expectedEntry.getYear());
            System.out.println("day = " + day + " should be " + expectedEntry.getDay());
            System.out.println("hours = " + hours + " should be " + expectedEntry.getHours());
            System.out.println("minutes = " + minutes + " should be " + expectedEntry.getMinutes());
            System.out.println("longitude = " + longitude + " should be > " + expectedEntry.getLongitude() + longDelta);
            System.out.println("dodsUrl = " + dodsUrl + " should be " + expectedEntry.getDodsUrl());
            TestDODSStructureForSequence.assertTrue((String)("Current entry <" + year + "-" + day + "T" + hours + ":" + minutes + ":" + seconds + ":" + m_seconds + " Long: " + longitude + " revNum: " + rev_num + " wvcRows: " + wvc_rows + " dodsUrl: " + dodsUrl + "> is not as expected <" + expectedEntry.getYear() + "-" + expectedEntry.getDay() + "T" + expectedEntry.getHours() + ":" + expectedEntry.getMinutes() + ":" + expectedEntry.getSeconds() + ":" + expectedEntry.getM_seconds() + " Long: " + expectedEntry.getLongitude() + " revNum: " + expectedEntry.getRev_num() + " wvcRows: " + expectedEntry.getWvc_rows() + " dodsUrl: " + expectedEntry.getDodsUrl() + ">."), (boolean)false);
        }
    }

    private class BasicEntry {
        private int year;
        private int day;
        private int hours;
        private int minutes;
        private int seconds;
        private int m_seconds;
        private float longitude;
        private int rev_num;
        private int wvc_rows;
        private String dodsUrl;

        public BasicEntry(int year, int day, int hours, int minutes, int seconds, int m_seconds, float longitude, int rev_num, int wvc_rows, String dodsUrl) {
            this.year = year;
            this.day = day;
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
            this.m_seconds = m_seconds;
            this.longitude = longitude;
            this.rev_num = rev_num;
            this.wvc_rows = wvc_rows;
            this.dodsUrl = dodsUrl;
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public int getDay() {
            return this.day;
        }

        public void setDay(int day) {
            this.day = day;
        }

        public int getHours() {
            return this.hours;
        }

        public void setHours(int hours) {
            this.hours = hours;
        }

        public int getMinutes() {
            return this.minutes;
        }

        public void setMinutes(int minutes) {
            this.minutes = minutes;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public void setSeconds(int seconds) {
            this.seconds = seconds;
        }

        public int getM_seconds() {
            return this.m_seconds;
        }

        public void setM_seconds(int m_seconds) {
            this.m_seconds = m_seconds;
        }

        public float getLongitude() {
            return this.longitude;
        }

        public void setLongitude(float longitude) {
            this.longitude = longitude;
        }

        public int getRev_num() {
            return this.rev_num;
        }

        public void setRev_num(int rev_num) {
            this.rev_num = rev_num;
        }

        public int getWvc_rows() {
            return this.wvc_rows;
        }

        public void setWvc_rows(int wvc_rows) {
            this.wvc_rows = wvc_rows;
        }

        public String getDodsUrl() {
            return this.dodsUrl;
        }

        public void setDodsUrl(String dodsUrl) {
            this.dodsUrl = dodsUrl;
        }
    }
}

