/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DODSVariable;
import ucar.nc2.dods.TestDODSRead;

public class TestDODSGrid
extends TestCase {
    public TestDODSGrid(String name) {
        super(name);
    }

    public void testGrid() throws IOException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.06a");
        Variable v = null;
        assert (null != (v = dodsfile.findVariable("OneD")));
        assert (v instanceof DODSVariable);
        this.checkArray(v);
        assert (null != (v = dodsfile.findVariable("x")));
        this.checkArray(v);
    }

    void checkArray(Variable v) throws IOException {
        assert (v.getRank() == 1);
        assert (v.getSize() == 10L);
        assert (v.getDataType() == DataType.DOUBLE);
        Array a = v.read();
        assert (a.getElementType() == Double.TYPE);
        assert (a instanceof ArrayDouble.D1);
        double[] tFloat64 = new double[]{1.0, 0.9999500004166653, 0.9998000066665778, 0.9995500337489875, 0.9992001066609779, 0.9987502603949663, 0.9982005399352042, 0.9975510002532796, 0.9968017063026194, 0.9959527330119943};
        IndexIterator iter = a.getIndexIterator();
        int count = 0;
        while (iter.hasNext()) {
            TestDODSGrid.assertEquals((double)iter.getDoubleNext(), (double)tFloat64[count], (double)1.0E-9);
            ++count;
        }
    }
}

