/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DODSStructure;
import ucar.nc2.dods.TestDODSRead;

public class TestDODSArrayOfStructure
extends TestCase {
    private boolean debug = false;
    private DODSNetcdfFile dodsfile;

    public TestDODSArrayOfStructure(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        DODSNetcdfFile.setPreload((boolean)false);
        this.dodsfile = TestDODSRead.open("test.50");
        DODSNetcdfFile.setPreload((boolean)true);
    }

    protected void tearDown() throws Exception {
        this.dodsfile.close();
    }

    public void testScalarReadByte() throws IOException {
        Variable v = null;
        Array a = null;
        assert (null != (v = this.dodsfile.findVariable("types")));
        v.setCaching(false);
        assert (v instanceof Structure);
        Structure s = (Structure)v;
        assert (null != (v = s.findVariable("b")));
        assert (v.getShortName().equals("b"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.BYTE);
        a = v.read();
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Byte.TYPE);
        assert (a instanceof ArrayByte.D0);
        byte valb = ((ArrayByte.D0)a).get();
        assert (valb == 0);
    }

    public void testReadScalarMemberVariable() throws IOException {
        Variable v = this.dodsfile.findVariable("types.i32");
        assert (v != null);
        assert (v.getRank() == 0);
        assert (v.getDataType() == DataType.INT) : v.getDataType();
        Array a = v.read();
        Index ima = a.getIndex();
        assert (a.getRank() == 0);
        assert (a.getInt(ima) == 1);
        assert (a instanceof ArrayInt.D0);
        v = this.dodsfile.findVariable("types.s");
        assert (v != null);
        assert (v.getRank() == 0);
        assert (v.getDataType() == DataType.STRING) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 0);
        assert (a instanceof ArrayObject.D0);
        ArrayObject.D0 a0 = (ArrayObject.D0)a;
        assert (a0.get().equals("This is a data test string (pass 0)."));
    }

    public void testReadArrayOfStructs() throws IOException, InvalidRangeException {
        Variable v = this.dodsfile.findVariable("types");
        assert (v != null);
        assert (v instanceof DODSStructure);
        assert (v.getRank() == 1);
        assert (v.getDataType() == DataType.STRUCTURE);
        DODSStructure struct = (DODSStructure)v;
        Array data = struct.read();
        assert (data.getRank() == 1);
        assert (data.getElementType().equals(StructureData.class));
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            Object d = ii.next();
            assert (d instanceof StructureData) : d.getClass().getName();
        }
    }

    public void testRead1DArrayOfStructs() throws IOException, InvalidRangeException {
        Variable v = this.dodsfile.findVariable("types");
        assert (v != null);
        assert (v instanceof DODSStructure);
        assert (v.getRank() == 1);
        assert (v.getDataType() == DataType.STRUCTURE);
        DODSStructure struct = (DODSStructure)v;
        int i = 0;
        while ((long)i < struct.getSize()) {
            StructureData sd = struct.readStructure(i);
            assert (sd.getScalarByte("b") == 0) : sd.getScalarByte("b");
            assert (sd.getScalarString("s").equals("This is a data test string (pass 0)."));
            ++i;
        }
    }

    public void testReadIteratorArrayOfStructs() throws IOException, InvalidRangeException {
        Variable v = this.dodsfile.findVariable("types");
        assert (v != null);
        assert (v instanceof DODSStructure);
        assert (v.getRank() == 1);
        assert (v.getDataType() == DataType.STRUCTURE);
        DODSStructure struct = (DODSStructure)v;
        StructureDataIterator iter = struct.getStructureIterator();
        while (iter.hasNext()) {
            StructureData sd = iter.next();
        }
    }

    public void testMemberReadNoFlatten() throws IOException, InvalidRangeException {
        Array a = this.dodsfile.read("types(1).b", false);
        assert (a.getRank() == 1);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == StructureData.class) : a.getElementType();
        assert (a instanceof ArrayStructure);
        StructureData sd = (StructureData)a.getObject(a.getIndex());
        StructureMembers.Member m = sd.findMember("b");
        assert (m != null);
        Array data = sd.getArray(m);
        assert (data != null);
        assert (data.getRank() == 0);
        assert (data.getSize() == 1L);
        assert (data.getElementType() == Byte.TYPE);
        assert (data instanceof ArrayByte.D0);
        ArrayByte.D0 b = (ArrayByte.D0)data;
        assert (b.get() == 0);
    }

    public void testArrayReadNoFlatten() throws IOException, InvalidRangeException {
        Array a = this.dodsfile.read("types(1:7).b", false);
        assert (a.getRank() == 1);
        assert (a.getSize() == 7L);
        assert (a.getElementType() == StructureData.class) : a.getElementType();
        assert (a instanceof ArrayStructure);
        StructureData sd = (StructureData)a.getObject(a.getIndex());
        StructureMembers.Member m = sd.findMember("b");
        assert (m != null);
        Array data = sd.getArray(m);
        assert (data != null);
        assert (data.getRank() == 0);
        assert (data.getSize() == 1L);
        assert (data.getElementType() == Byte.TYPE);
        assert (data instanceof ArrayByte.D0);
        ArrayByte.D0 b = (ArrayByte.D0)data;
        assert (b.get() == 0) : b.get();
    }

    public void testArrayReadFlatten() throws IOException, InvalidRangeException {
        Array a = this.dodsfile.read("types(1:7).b", true);
        assert (a.getRank() == 1);
        assert (a.getSize() == 7L);
        assert (a.getElementType() == Byte.TYPE);
        assert (a instanceof ArrayByte.D1);
        ArrayByte.D1 b1 = (ArrayByte.D1)a;
        assert (b1.get(0) == 0);
        assert (b1.get(6) == 6);
    }
}

