/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.CompareNetcdf;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LambertAzimuthalEqualArea;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;
import ucar.unidata.geoloc.projection.proj4.StereographicAzimuthalProjection;
import ucar.unidata.geoloc.projection.proj4.TransverseMercatorProjection;
import ucar.unidata.geoloc.projection.sat.MSGnavigation;

public class TestProjections
extends TestCase {
    private String testDir = "cdmUnitTest/transforms/";

    public TestProjections(String name) {
        super(name);
    }

    public void testProjections() throws IOException, InvalidRangeException {
        Projection p = this.test(TestAll.testdataDir + this.testDir + "Sigma_LC.nc", "Lambert_Conformal", "Temperature", LambertConformal.class);
        p = this.test(TestAll.testdataDir + this.testDir + "LambertAzimuth.nc", "grid_mapping0", "VIL", LambertAzimuthalEqualArea.class);
        p = this.test(TestAll.testdataDir + this.testDir + "PolarStereographic.nc", "Polar_Stereographic", "D2_O3", Stereographic.class);
        p = this.test(TestAll.testdataDir + this.testDir + "Polar_Stereographic2.nc", null, "dpd-Surface0", Stereographic.class);
        p = this.test(TestAll.testdataDir + "grid/netcdf/cf/Base_month.nc", null, "D2_SO4", Stereographic.class);
        p = this.test(TestAll.testdataDir + this.testDir + "Mercator.grib1", "Mercator", "Temperature", Mercator.class);
        p = this.test(TestAll.testdataDir + this.testDir + "Eumetsat.VerticalPerspective.grb", "Space_View_Perspective_or_Orthographic", "Pixel_scene_type", MSGnavigation.class);
    }

    public void testProjectionsHeiko() throws IOException, InvalidRangeException {
        String dir = TestAll.testdataDir + this.testDir + "heiko/";
        Projection p = this.test(dir + "topo_stere_sphere.nc", "projection_stere", "air_temperature_2m", Stereographic.class);
        p = this.test(dir + "topo_stere_WGS.nc", "projection_stere", "air_temperature_2m", StereographicAzimuthalProjection.class);
        p = this.test(dir + "topo_utm_sphere.nc", "projection_tmerc", "air_temperature_2m", TransverseMercator.class);
        p = this.test(dir + "topo_utm_WGS.nc", "projection_tmerc", "air_temperature_2m", TransverseMercatorProjection.class);
    }

    private Projection test(String filename, String ctvName, String varName, Class projClass) throws IOException, InvalidRangeException {
        System.out.printf("Open= %s%n", filename);
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)filename);
        Variable ctv = null;
        if (ctvName != null) {
            ctv = ncd.findVariable(ctvName);
            assert (ctv != null);
            System.out.println(" dump of ctv = \n" + ctv);
        }
        VariableDS v = (VariableDS)ncd.findVariable(varName);
        assert (v != null);
        List cList = v.getCoordinateSystems();
        assert (cList != null);
        assert (cList.size() == 1);
        CoordinateSystem csys = (CoordinateSystem)cList.get(0);
        ArrayList<CoordinateTransform> pList = new ArrayList<CoordinateTransform>();
        List tList = csys.getCoordinateTransforms();
        assert (tList != null);
        for (int i = 0; i < tList.size(); ++i) {
            CoordinateTransform ct = (CoordinateTransform)tList.get(i);
            if (ct.getTransformType() != TransformType.Projection) continue;
            pList.add(ct);
        }
        assert (pList.size() == 1);
        CoordinateTransform ct = (CoordinateTransform)pList.get(0);
        assert (ct.getTransformType() == TransformType.Projection);
        assert (ct instanceof ProjectionCT);
        ProjectionCT vct = (ProjectionCT)ct;
        ProjectionImpl proj = vct.getProjection();
        assert (proj != null);
        assert (projClass.isInstance(proj)) : proj.getClass().getName();
        VariableDS ctvSyn = CoordTransBuilder.makeDummyTransformVariable((NetcdfDataset)ncd, (CoordinateTransform)ct);
        System.out.println(" dump of equivilent ctv = \n" + ctvSyn);
        if (ctv != null) {
            Formatter f = new Formatter(System.out);
            CompareNetcdf.checkContains((List)ctv.getAttributes(), (List)ctvSyn.getAttributes(), (Formatter)f);
        }
        ncd.close();
        return proj;
    }
}

