/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;

public class TestFindCoord
extends TestCase {
    public TestFindCoord(String name) {
        super(name);
    }

    public void testRegular() throws IOException {
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n    <dimension name='lat'  length='2' />\n    <dimension name='lon'  length='2' />\n    <dimension name='bnds' length='2' />\n    <attribute name='Conventions' value='CF-1.0' />\n    <variable name='lat' shape='lat' type='double'>\n        <attribute name='units' type='String' value='degrees_north' />\n        <attribute name='bounds' type='String' value='lat_bnds' />\n        <values>-45 45</values>\n    </variable>\n    <variable name='lat_bnds' shape='lat bnds' type='double'>\n        <values>-90 0 0 90</values>\n    </variable>\n    <variable name='lon' shape='lon' type='double'>\n        <attribute name='units' type='String' value='degrees_east' />\n        <attribute name='bounds' type='String' value='lon_bnds' />\n        <values>90 270</values>\n    </variable>\n    <variable name='lon_bnds' shape='lon bnds' type='double'>\n        <values>0 180 180 360</values>\n    </variable>\n</netcdf>";
        this.doTest(ncml, "lat", false, new double[]{-91.0, -90.0, -67.5, -45.0, -22.5, 0.0, 22.5, 45.0, 67.5, 90.0, 91.0}, new int[]{-1, 0, 0, 0, 0, 1, 1, 1, 1, -1, -1});
        this.doTest(ncml, "lon", false, new double[]{-91.0, -90.0, 0.0, 45.0, 90.0, 135.0, 180.0, 225.0, 270.0, 315.0, 360.0, 450.0, 451.0}, new int[]{-1, -1, 0, 0, 0, 0, 1, 1, 1, 1, -1, -1, -1});
        this.doTest(ncml, "lat", true, new double[]{-91.0, -90.0, -67.5, -45.0, -22.5, 0.0, 22.5, 45.0, 67.5, 90.0, 91.0}, new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1});
        this.doTest(ncml, "lon", true, new double[]{-91.0, -90.0, 0.0, 45.0, 90.0, 135.0, 180.0, 225.0, 270.0, 315.0, 360.0, 450.0, 451.0}, new int[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1});
    }

    public void testRegularDescending() throws IOException {
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n    <dimension name='lat'  length='2' />\n    <dimension name='lon'  length='2' />\n    <dimension name='bnds' length='2' />\n    <attribute name='Conventions' value='CF-1.0' />\n    <variable name='lat' shape='lat' type='double'>\n        <attribute name='units' type='String' value='degrees_north' />\n        <attribute name='bounds' type='String' value='lat_bnds' />\n        <values>45 -45</values>\n    </variable>\n    <variable name='lat_bnds' shape='lat bnds' type='double'>\n        <values>90 0 0 -90</values>\n    </variable>\n    <variable name='lon' shape='lon' type='double'>\n        <attribute name='units' type='String' value='degrees_east' />\n        <attribute name='bounds' type='String' value='lon_bnds' />\n        <values>270 90</values>\n    </variable>\n    <variable name='lon_bnds' shape='lon bnds' type='double'>\n        <values>360 180 180 0</values>\n    </variable>\n</netcdf>";
        this.doTest(ncml, "lat", false, new double[]{-91.0, -90.0, -67.5, -45.0, -22.5, 0.0, 22.5, 45.0, 67.5, 90.0, 91.0}, new int[]{-1, -1, 1, 1, 1, 1, 0, 0, 0, 0, -1});
        this.doTest(ncml, "lon", false, new double[]{-91.0, -90.0, 0.0, 45.0, 90.0, 135.0, 180.0, 225.0, 270.0, 315.0, 360.0, 450.0, 451.0}, new int[]{-1, -1, -1, 1, 1, 1, 1, 0, 0, 0, 0, -1, -1});
        this.doTest(ncml, "lat", true, new double[]{-91.0, -90.0, -67.5, -45.0, -22.5, 0.0, 22.5, 45.0, 67.5, 90.0, 91.0}, new int[]{1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0});
        this.doTest(ncml, "lon", true, new double[]{-91.0, -90.0, 0.0, 45.0, 90.0, 135.0, 180.0, 225.0, 270.0, 315.0, 360.0, 450.0, 451.0}, new int[]{1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0});
    }

    public void testIrregular() throws IOException {
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n    <dimension name='lat'  length='3' />\n    <dimension name='lon'  length='3' />\n    <dimension name='bnds' length='2' />\n    <attribute name='Conventions' value='CF-1.0' />\n    <variable name='lat' shape='lat' type='double'>\n        <attribute name='units' type='String' value='degrees_north' />\n        <attribute name='bounds' type='String' value='lat_bnds' />\n        <values>-45 10 45</values>\n    </variable>\n    <variable name='lat_bnds' shape='lat bnds' type='double'>\n        <values>-90 5 5 15 15 90</values>\n    </variable>\n    <variable name='lon' shape='lon' type='double'>\n        <attribute name='units' type='String' value='degrees_east' />\n        <attribute name='bounds' type='String' value='lon_bnds' />\n        <values>90 200 270</values>\n    </variable>\n    <variable name='lon_bnds' shape='lon bnds' type='double'>\n        <values>0 180 180 220 220 360</values>\n    </variable>\n</netcdf>";
        this.doTest(ncml, "lat", false, new double[]{-91.0, -90.0, -67.5, -45.0, -22.5, 0.0, 10.0, 45.0, 67.5, 90.0, 91.0}, new int[]{-1, 0, 0, 0, 0, 0, 1, 2, 2, 2, -1});
        this.doTest(ncml, "lon", false, new double[]{-91.0, -90.0, 0.0, 45.0, 90.0, 135.0, 180.0, 210.0, 270.0, 315.0, 360.0, 450.0, 451.0}, new int[]{-1, -1, 0, 0, 0, 0, 1, 1, 2, 2, 2, -1, -1});
        this.doTest(ncml, "lat", true, new double[]{-91.0, -90.0, -67.5, -45.0, -22.5, 0.0, 10.0, 45.0, 67.5, 90.0, 91.0}, new int[]{0, 0, 0, 0, 0, 0, 1, 2, 2, 2, 2});
        this.doTest(ncml, "lon", true, new double[]{-91.0, -90.0, 0.0, 45.0, 90.0, 135.0, 180.0, 210.0, 270.0, 315.0, 360.0, 450.0, 451.0}, new int[]{0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 2});
    }

    public void testIrregularDescending() throws IOException {
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n    <dimension name='lat'  length='3' />\n    <dimension name='lon'  length='3' />\n    <dimension name='bnds' length='2' />\n    <attribute name='Conventions' value='CF-1.0' />\n    <variable name='lat' shape='lat' type='double'>\n        <attribute name='units' type='String' value='degrees_north' />\n        <attribute name='bounds' type='String' value='lat_bnds' />\n        <values>44 40 30</values>\n    </variable>\n    <variable name='lat_bnds' shape='lat bnds' type='double'>\n        <values>50 42 42 35 35 0</values>\n    </variable>\n    <variable name='lon' shape='lon' type='double'>\n        <attribute name='units' type='String' value='degrees_east' />\n        <attribute name='bounds' type='String' value='lon_bnds' />\n        <values>9 0 -20</values>\n    </variable>\n    <variable name='lon_bnds' shape='lon bnds' type='double'>\n        <values>20 0 0 -10 -10 -90</values>\n    </variable>\n</netcdf>";
        this.doTest(ncml, "lat", false, new double[]{-90.0, 0.0, 0.0, 10.0, 33.0, 44.0, 55.0, 90.0}, new int[]{-1, 2, 2, 2, 2, 0, -1, -1});
        this.doTest(ncml, "lon", false, new double[]{-91.0, -90.0, -12.0, -2.0, 0.0, 2.0, 22.0, 90.0}, new int[]{-1, 2, 2, 1, 1, 0, -1, -1});
        this.doTest(ncml, "lat", true, new double[]{-90.0, 0.0, 0.0, 10.0, 33.0, 44.0, 55.0, 90.0}, new int[]{2, 2, 2, 2, 2, 0, 0, 0});
        this.doTest(ncml, "lon", true, new double[]{-91.0, -90.0, -12.0, -2.0, 0.0, 2.0, 22.0, 90.0}, new int[]{2, 2, 2, 1, 1, 0, 0, 0});
    }

    public void testNonContig() throws IOException {
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n    <dimension name='lat'  length='3' />\n    <dimension name='lon'  length='3' />\n    <dimension name='bnds' length='2' />\n    <attribute name='Conventions' value='CF-1.0' />\n    <variable name='lat' shape='lat' type='double'>\n        <attribute name='units' type='String' value='degrees_north' />\n        <attribute name='bounds' type='String' value='lat_bnds' />\n        <values>10 20 90</values>\n    </variable>\n    <variable name='lat_bnds' shape='lat bnds' type='double'>\n        <values>0 11 18 22 30 90</values>\n    </variable>\n    <variable name='lon' shape='lon' type='double'>\n        <attribute name='units' type='String' value='degrees_east' />\n        <attribute name='bounds' type='String' value='lon_bnds' />\n        <values>0 10 90</values>\n    </variable>\n    <variable name='lon_bnds' shape='lon bnds' type='double'>\n        <values>0 5 5 10 80 90</values>\n    </variable>\n</netcdf>";
        this.doTest(ncml, "lat", false, new double[]{90.0, 50.0, 48.0, 41.5, 40.0, 33.0, 15.0, 0.0, -10.0}, new int[]{2, 2, 2, 2, 2, 2, -1, 0, -1});
        this.doTest(ncml, "lon", false, new double[]{90.0, 20.0, 18.0, 5.0, 4.0, 0.0, -10.0, -15.0, -20.0, -45.0, -90.0, -100.0}, new int[]{2, -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1});
        this.doTest(ncml, "lat", true, new double[]{90.0, 50.0, 48.0, 41.5, 40.0, 33.0, 15.0, 0.0, -10.0}, new int[]{2, 2, 2, 2, 2, 2, 1, 0, 0});
        this.doTest(ncml, "lon", true, new double[]{90.0, 20.0, 18.0, 5.0, 4.0, 0.0, -10.0, -15.0, -20.0, -45.0, -90.0, -100.0}, new int[]{2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    }

    public void testNonContigDescending() throws IOException {
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n    <dimension name='lat'  length='3' />\n    <dimension name='lon'  length='3' />\n    <dimension name='bnds' length='2' />\n    <attribute name='Conventions' value='CF-1.0' />\n    <variable name='lat' shape='lat' type='double'>\n        <attribute name='units' type='String' value='degrees_north' />\n        <attribute name='bounds' type='String' value='lat_bnds' />\n        <values>44 40 30</values>\n    </variable>\n    <variable name='lat_bnds' shape='lat bnds' type='double'>\n        <values>50 42 41 35 32 0</values>\n    </variable>\n    <variable name='lon' shape='lon' type='double'>\n        <attribute name='units' type='String' value='degrees_east' />\n        <attribute name='bounds' type='String' value='lon_bnds' />\n        <values>9 0 -20</values>\n    </variable>\n    <variable name='lon_bnds' shape='lon bnds' type='double'>\n        <values>20 5 0 -10 -20 -90</values>\n    </variable>\n</netcdf>";
        this.doTest(ncml, "lat", false, new double[]{90.0, 50.0, 48.0, 41.5, 40.0, 33.0, 15.0, 0.0, -10.0}, new int[]{-1, 0, 0, -1, 1, -1, 2, 2, -1});
        this.doTest(ncml, "lon", false, new double[]{90.0, 20.0, 18.0, 5.0, 4.0, 0.0, -10.0, -15.0, -20.0, -45.0, -90.0, -100.0}, new int[]{-1, 0, 0, 0, -1, 1, 1, -1, 2, 2, 2, -1});
        this.doTest(ncml, "lat", true, new double[]{90.0, 50.0, 48.0, 41.5, 40.0, 33.0, 15.0, 0.0, -10.0}, new int[]{0, 0, 0, 1, 1, 2, 2, 2, 2});
        this.doTest(ncml, "lon", true, new double[]{90.0, 20.0, 18.0, 5.0, 4.0, 0.0, -10.0, -15.0, -20.0, -45.0, -90.0, -100.0}, new int[]{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 2, 2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(String ncml, String varName, boolean bounded, double[] vals, int[] expect) throws IOException {
        NetcdfDataset nc = NcMLReader.readNcML((Reader)new StringReader(ncml), null);
        NetcdfDataset dataset = new NetcdfDataset((NetcdfFile)nc, true);
        try {
            int index;
            int i;
            CoordinateAxis1D axis1D = (CoordinateAxis1D)dataset.findVariable(varName);
            if (axis1D.isContiguous()) {
                double[] edge = axis1D.getCoordEdges();
                System.out.printf("%s =", varName);
                for (int i2 = 0; i2 < edge.length; ++i2) {
                    System.out.printf("%2f, ", edge[i2]);
                }
                System.out.printf("%n", new Object[0]);
            } else {
                System.out.printf("%s =", varName);
                double[] bound1 = axis1D.getBound1();
                double[] bound2 = axis1D.getBound2();
                int i3 = 0;
                while ((long)i3 < axis1D.getSize()) {
                    System.out.printf("(%f,%f) ", bound1[i3], bound2[i3]);
                    ++i3;
                }
                System.out.printf("%n", new Object[0]);
            }
            for (i = 0; i < vals.length; ++i) {
                double v = vals[i];
                index = bounded ? axis1D.findCoordElementBounded(v) : axis1D.findCoordElement(v);
                System.out.printf(" %5.1f, index= %2d %n", v, index);
                if (expect != null) assert (index == expect[i]);
            }
            System.out.printf("{", new Object[0]);
            for (i = 0; i < vals.length; ++i) {
                double v = vals[i];
                index = bounded ? axis1D.findCoordElementBounded(v) : axis1D.findCoordElement(v);
                System.out.printf("%2d, ", index);
            }
            System.out.printf("}%n%n", new Object[0]);
        }
        finally {
            dataset.close();
        }
    }
}

