/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.File;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CompareNetcdf;

public class TestDatasetWrap
extends TestCase {
    public TestDatasetWrap(String name) {
        super(name);
    }

    public void testDatasetWrap() throws Exception {
        this.doOne(TestAll.testdataDir + "grid/netcdf/nuwg/eta.nc");
    }

    void readAllDir(String dirName) throws Exception {
        int i;
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        for (i = 0; i < allFiles.length; ++i) {
            String name = allFiles[i].getAbsolutePath();
            if (!name.endsWith(".nc")) continue;
            this.doOne(name);
        }
        for (i = 0; i < allFiles.length; ++i) {
            File f = allFiles[i];
            if (!f.isDirectory()) continue;
            this.readAllDir(allFiles[i].getAbsolutePath());
        }
    }

    private void doOne(String filename) throws Exception {
        NetcdfFile ncfile = NetcdfDataset.acquireFile((String)filename, null);
        NetcdfDataset ncWrap = new NetcdfDataset(ncfile, true);
        NetcdfDataset ncd = NetcdfDataset.acquireDataset((String)filename, null);
        System.out.println(" dataset wraps= " + filename);
        CompareNetcdf.compareFiles((NetcdfFile)ncd, (NetcdfFile)ncWrap);
        ncd.close();
        ncWrap.close();
    }
}

