/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;

public class TestConventions
extends TestCase {
    public TestConventions(String name) {
        super(name);
    }

    public void testWRF() throws IOException {
        this.testWRF(TestAll.cdmUnitTestDir + "conventions/wrf/wrf2.nc");
    }

    private void testWRF(String location) throws IOException {
        NetcdfDataset ds = NetcdfDataset.openDataset((String)location);
    }

    public void testCF() throws IOException {
        GridDataset ds = GridDataset.open((String)(TestAll.cdmUnitTestDir + "conventions/cf/twoGridMaps.nc"));
        GeoGrid grid = ds.findGridByName("altitude");
        GridCoordSystem gcs = grid.getCoordinateSystem();
        assert (1 == gcs.getCoordinateTransforms().size());
        CoordinateTransform ct = (CoordinateTransform)gcs.getCoordinateTransforms().get(0);
        assert (ct.getTransformType() == TransformType.Projection);
        assert (ct.getName().equals("projection_stere"));
        ds.close();
    }
}

