/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import ucar.nc2.util.Stat;

public class TimeMMap {
    static boolean debug = false;
    static boolean showEach = true;
    static boolean check = false;
    static Random random = new Random(System.currentTimeMillis());

    static void writeChannelDirect(String filename, long fileSize, int recordSize, Stat stat) throws Exception {
        String name = "writeCD ";
        long size = 0L;
        long startTime = System.currentTimeMillis();
        long fileSizeBytes = fileSize * 1000L * 1000L;
        int recordSizeBytes = recordSize * 1000;
        int n = (int)(fileSizeBytes / (long)recordSizeBytes);
        String rfilename = filename + random.nextInt();
        RandomAccessFile file = new RandomAccessFile(rfilename, "rw");
        file.setLength(fileSizeBytes);
        FileChannel channel = file.getChannel();
        if (debug) {
            System.out.println("Opened file to write:'" + rfilename + "', size=" + channel.size() + " fileSize = " + fileSize + " Mb; recSize = " + recordSize + " Kb; nrecs = " + n);
        }
        int nelems = recordSizeBytes / 4;
        int[] data = new int[nelems];
        for (int i = 0; i < nelems; ++i) {
            data[i] = i;
        }
        ByteBuffer buff = ByteBuffer.allocate(recordSizeBytes);
        IntBuffer src = buff.asIntBuffer();
        for (int i = 0; i < n; ++i) {
            buff.clear();
            src.clear();
            src.put(data);
            channel.write(buff);
            TimeMMap.showBufferInfo(" end bb ", buff);
            TimeMMap.showBufferInfo(" end ib ", src);
            System.out.println(" channel pos= " + channel.position());
        }
        channel.close();
        file.close();
        long endTime = System.currentTimeMillis();
        long diff = endTime - startTime;
        if (stat != null) {
            stat.avg(name + filename, diff);
        }
        if (showEach || stat == null) {
            System.out.println("timeWrite to " + rfilename + "; n records = " + n + " took " + diff + " msecs");
        }
        if (check) {
            TimeMMap.checkWrite(rfilename);
        }
    }

    static void showBufferInfo(String name, Buffer b) {
        System.out.println(" buffer= " + name + " pos= " + b.position() + " limit= " + b.limit());
    }

    static void timeWriteMMap(String filename, long fileSize, int recordSize, Stat stat) throws Exception {
        String name = "WriteMM ";
        long startTime = System.currentTimeMillis();
        long fileSizeBytes = fileSize * 1000L * 1000L;
        int recordSizeBytes = recordSize * 1000;
        int n = (int)(fileSizeBytes / (long)recordSizeBytes);
        long size = fileSizeBytes + (long)(n * 4);
        String rfilename = filename + random.nextInt();
        RandomAccessFile file = new RandomAccessFile(rfilename, "rw");
        FileChannel channel = file.getChannel();
        if (debug) {
            System.out.println("Opened file to write:'" + rfilename + "', size=" + channel.size() + " fileSize = " + fileSize + " Mb; recSize = " + recordSize + " Kb; nrecs = " + n);
        }
        MappedByteBuffer mbuff = channel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
        int nelems = recordSizeBytes / 4;
        int[] data = new int[nelems];
        for (int i = 0; i < nelems; ++i) {
            data[i] = i;
        }
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            ((ByteBuffer)mbuff).position(pos);
            mbuff.putInt(nelems);
            IntBuffer intBuff = mbuff.asIntBuffer();
            intBuff.put(data);
            pos += (nelems + 1) * 4;
        }
        channel.close();
        file.close();
        long endTime = System.currentTimeMillis();
        long diff = endTime - startTime;
        if (stat != null) {
            stat.avg(name + filename, diff);
        }
        if (showEach || stat == null) {
            System.out.println("writeMMap to " + rfilename + "; n records = " + n + " took " + diff + " msecs");
        }
        if (check) {
            TimeMMap.checkWrite(rfilename);
        }
    }

    static void checkWrite(String filename) throws Exception {
        int nelems;
        RandomAccessFile file = new RandomAccessFile(filename, "r");
        FileChannel channel = file.getChannel();
        int size = (int)channel.size();
        if (debug) {
            System.out.println("Opened file to read:'" + filename + "', size=" + size);
        }
        MappedByteBuffer mbuff = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        System.out.println("checking " + filename);
        for (int pos = 0; pos < size; pos += (nelems + 1) * 4) {
            ((ByteBuffer)mbuff).position(pos);
            nelems = mbuff.getInt();
            int[] data = new int[nelems];
            IntBuffer intBuff = mbuff.asIntBuffer();
            intBuff.get(data);
            int j = 0;
            if (j >= nelems) continue;
            if (data[j] == j) break;
            System.out.println(" bad at pos " + pos);
            break;
        }
        channel.close();
        file.close();
    }

    static long timeReadMMap(String filename, Stat stat) throws Exception {
        long startTime = System.currentTimeMillis();
        RandomAccessFile file = new RandomAccessFile(filename, "r");
        FileChannel channel = file.getChannel();
        long fileSizeBytes = channel.size();
        int sm = (int)fileSizeBytes / 1000 / 1000;
        if (debug) {
            System.out.println("Try to map file:'" + filename + "', size=" + fileSizeBytes);
        }
        MappedByteBuffer mbuff = channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSizeBytes);
        int nreads = 0;
        int pos = 0;
        block0: while ((long)pos < fileSizeBytes) {
            ((ByteBuffer)mbuff).position(pos);
            int nelems = mbuff.getInt();
            int[] data = new int[nelems];
            IntBuffer intBuff = mbuff.asIntBuffer();
            intBuff.get(data);
            for (int j = 0; j < nelems; ++j) {
                if (data[j] == j) continue;
                System.out.println(" bad at pos " + pos + " file= " + filename);
                break block0;
            }
            pos += (nelems + 1) * 4;
            ++nreads;
        }
        channel.close();
        file.close();
        long endTime = System.currentTimeMillis();
        long diff = endTime - startTime;
        if (stat != null) {
            stat.avg("readMM " + sm, diff);
        }
        if (showEach || stat == null) {
            System.out.println("readMM from " + filename + " nbytes= " + pos + " nreads = " + nreads + " took " + diff + " msecs");
        }
        return fileSizeBytes;
    }

    static long timeReadCD(String filename, Stat stat) throws Exception {
        long startTime = System.currentTimeMillis();
        RandomAccessFile file = new RandomAccessFile(filename, "r");
        FileChannel channel = file.getChannel();
        long fileSizeBytes = channel.size();
        int sm = (int)fileSizeBytes / 1000 / 1000;
        if (debug) {
            System.out.println("readCD file:'" + filename + "', size=" + fileSizeBytes);
        }
        int nreads = 0;
        int pos = 0;
        block0: while ((long)pos < fileSizeBytes) {
            file.seek(pos);
            int nelems = file.readInt();
            ByteBuffer bbuff = ByteBuffer.allocateDirect(nelems * 4);
            IntBuffer ibuff = bbuff.asIntBuffer();
            channel.read(bbuff);
            int[] data = new int[nelems];
            ibuff.get(data);
            for (int j = 0; j < nelems; ++j) {
                if (data[j] == j) continue;
                System.out.println(" bad at pos " + pos + " file= " + filename);
                break block0;
            }
            pos += (nelems + 1) * 4;
            ++nreads;
        }
        channel.close();
        file.close();
        long endTime = System.currentTimeMillis();
        long diff = endTime - startTime;
        if (stat != null) {
            stat.avg("readCD " + sm, diff);
        }
        if (showEach || stat == null) {
            System.out.println("readCD from " + filename + " nbytes= " + pos + " nreads = " + nreads + " took " + diff + " msecs");
        }
        return fileSizeBytes;
    }

    public static void testWriteMM(Stat s, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            TimeMMap.timeWriteMMap("timing/data/writeMM-1K", 1L, 1, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM-4K", 1L, 4, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM-8K", 1L, 8, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM-16K", 1L, 16, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM-32K", 1L, 32, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM-100K", 1L, 100, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM10-1K", 10L, 1, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM10-4K", 10L, 4, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM10-8K", 10L, 8, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM10-16K", 10L, 16, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM10-32K", 10L, 32, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM10-100K", 10L, 100, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM100-1K", 100L, 1, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM100-4K", 100L, 4, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM100-8K", 100L, 8, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM100-16K", 100L, 16, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM100-32K", 100L, 32, s);
            TimeMMap.timeWriteMMap("timing/data/writeMM100-100K", 100L, 100, s);
            if (s == null) continue;
            s.print();
        }
    }

    public static void testWriteCD(Stat s) throws Exception {
        TimeMMap.writeChannelDirect("timing/data/writeCD100", 100L, 100, s);
    }

    public static void testReadMM(Stat s, int n) throws Exception {
        long totalRead = 0L;
        for (int i = 0; i < n; ++i) {
            try {
                File dir = new File("timing/data/");
                String[] flist = dir.list();
                for (int j = 0; j < flist.length; ++j) {
                    totalRead += TimeMMap.timeReadMMap("timing/data/" + flist[j], s);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.out.println("MM total before error= " + totalRead);
                break;
            }
            if (s != null) {
                s.print();
            }
            System.out.println("MM total done = " + totalRead);
        }
    }

    public static void testReadCD(Stat s, int n) throws Exception {
        long totalRead = 0L;
        for (int i = 0; i < n; ++i) {
            try {
                File dir = new File("timing/data/");
                String[] flist = dir.list();
                for (int j = 0; j < flist.length; ++j) {
                    totalRead += TimeMMap.timeReadCD("timing/data/" + flist[j], s);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.out.println("CD total before error= " + totalRead);
                break;
            }
            if (s != null) {
                s.print();
            }
            System.out.println("CD total done = " + totalRead);
        }
    }

    public static void main(String[] args) throws Exception {
        Stat stat = new Stat();
        TimeMMap.testWriteMM(stat, 10);
        stat.print();
    }
}

