/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.netcdf3.N3channelWriter;

public class TimeFileWriter {
    public static void timeFileWriter(String location, String fileOut) throws IOException {
        long startTime = System.currentTimeMillis();
        NetcdfFile ds = NetcdfDataset.openFile((String)location, null);
        NetcdfFile ncfileOut = FileWriter.writeToFile((NetcdfFile)ds, (String)fileOut, (boolean)false, (int)0);
        long diff = System.currentTimeMillis() - startTime;
        File result = new File(fileOut);
        double size = 0.001 * (double)result.length();
        double rate = size / (double)diff;
        System.out.println("FileWriter.writeToFile " + location + "  took " + diff + " msecs rate= " + rate + " Mb/sec");
    }

    public static void timeChannelWriter(String location, String fileOut) throws IOException, InvalidRangeException {
        long startTime = System.currentTimeMillis();
        NetcdfFile ncfile = NetcdfDataset.openFile((String)location, null);
        FileOutputStream fout = new FileOutputStream(fileOut);
        N3channelWriter.writeToChannel((NetcdfFile)ncfile, (WritableByteChannel)fout.getChannel());
        long diff = System.currentTimeMillis() - startTime;
        File result = new File(fileOut);
        double size = 0.001 * (double)result.length();
        double rate = size / (double)diff;
        System.out.println("N3channelWriter.writeToFile " + location + "  took " + diff + " msecs rate= " + rate + " Mb/sec");
    }

    public static void main(String[] args) throws IOException, InvalidRangeException {
        TimeFileWriter.timeFileWriter("dods://motherlode.ucar.edu:8081/thredds/dodsC/fmrc/NCEP/NAM/CONUS_12km/files/NAM_CONUS_12km_20080215_0600.grib2", "C:/temp/testOut124.nc");
    }
}

