/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.TestLocal;

public class TestWriteRecordStructure
extends TestCase {
    static String fileName = TestLocal.temporaryDataDir + "testWriteRecordStructure.nc";
    static boolean dumpAfterCreate = false;

    public TestWriteRecordStructure(String name) {
        super(name);
    }

    public void testWriteRecordStructure() throws IOException, InvalidRangeException {
        NetcdfFileWriteable writeableFile = NetcdfFileWriteable.createNew((String)fileName);
        Dimension latDim = writeableFile.addDimension("lat", 3);
        Dimension lonDim = writeableFile.addDimension("lon", 4);
        Dimension timeDim = writeableFile.addUnlimitedDimension("time");
        Dimension[] dim3 = new Dimension[]{timeDim, latDim, lonDim};
        writeableFile.addVariable("lat", DataType.FLOAT, new Dimension[]{latDim});
        writeableFile.addVariableAttribute("lat", "units", "degrees_north");
        writeableFile.addVariable("lon", DataType.FLOAT, new Dimension[]{lonDim});
        writeableFile.addVariableAttribute("lon", "units", "degrees_east");
        writeableFile.addVariable("rh", DataType.INT, dim3);
        writeableFile.addVariableAttribute("rh", "long_name", "relative humidity");
        writeableFile.addVariableAttribute("rh", "units", "percent");
        writeableFile.addVariable("T", DataType.DOUBLE, dim3);
        writeableFile.addVariableAttribute("T", "long_name", "surface temperature");
        writeableFile.addVariableAttribute("T", "units", "degC");
        writeableFile.addVariable("time", DataType.INT, new Dimension[]{timeDim});
        writeableFile.addVariableAttribute("time", "units", "hours since 1990-01-01");
        writeableFile.create();
        writeableFile.write("lat", Array.factory((Object)new float[]{41.0f, 40.0f, 39.0f}));
        writeableFile.write("lon", Array.factory((Object)new float[]{-109.0f, -107.0f, -105.0f, -103.0f}));
        ArrayInt.D3 rhData = new ArrayInt.D3(1, latDim.getLength(), lonDim.getLength());
        ArrayDouble.D3 tempData = new ArrayDouble.D3(1, latDim.getLength(), lonDim.getLength());
        Array timeData = Array.factory((DataType)DataType.INT, (int[])new int[]{1});
        int[] origin = new int[]{0, 0, 0};
        int[] time_origin = new int[]{0};
        int time = 0;
        while (time < 10) {
            timeData.setInt(timeData.getIndex(), time * 12);
            Index ima = rhData.getIndex();
            for (int lat = 0; lat < latDim.getLength(); ++lat) {
                for (int lon = 0; lon < lonDim.getLength(); ++lon) {
                    rhData.setInt(ima.set(0, lat, lon), time * lat * lon);
                    tempData.set(0, lat, lon, (double)(time * lat * lon) / 3.14159);
                }
            }
            time_origin[0] = time;
            origin[0] = time++;
            writeableFile.write("rh", origin, (Array)rhData);
            writeableFile.write("T", origin, (Array)tempData);
            writeableFile.write("time", time_origin, timeData);
        }
        writeableFile.close();
    }
}

