/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.TestLocal;
import ucar.nc2.Variable;
import ucar.nc2.util.CompareNetcdf;

public class TestWrite
extends TestCase {
    private boolean show = false;

    public TestWrite(String name) {
        super(name);
    }

    public void testNC3Write() throws IOException {
        String filename;
        block95: {
            Array tA;
            Index ima;
            NetcdfFileWriteable ncfile;
            block94: {
                block93: {
                    block92: {
                        ArrayChar.D1 ac;
                        block91: {
                            int j;
                            int i;
                            block90: {
                                block89: {
                                    block88: {
                                        ArrayChar.D1 ac2;
                                        int[] origin;
                                        Dimension names;
                                        Dimension svar_len;
                                        block87: {
                                            block86: {
                                                int[] origin1;
                                                block85: {
                                                    Dimension latDim;
                                                    block84: {
                                                        block83: {
                                                            Dimension lonDim;
                                                            block82: {
                                                                filename = TestLocal.temporaryDataDir + "testWrite.nc";
                                                                ncfile = NetcdfFileWriteable.createNew((String)filename, (boolean)false);
                                                                latDim = ncfile.addDimension("lat", 64);
                                                                lonDim = ncfile.addDimension("lon", 128);
                                                                ArrayList<Dimension> dims = new ArrayList<Dimension>();
                                                                dims.add(latDim);
                                                                dims.add(lonDim);
                                                                ncfile.addVariable("temperature", DataType.DOUBLE, dims);
                                                                ncfile.addVariableAttribute("temperature", "units", "K");
                                                                Array data = Array.factory(Integer.TYPE, (int[])new int[]{3}, (Object)new int[]{1, 2, 3});
                                                                ncfile.addVariableAttribute("temperature", "scale", data);
                                                                ncfile.addVariableAttribute("temperature", "versionD", (Number)new Double(1.2));
                                                                ncfile.addVariableAttribute("temperature", "versionF", (Number)new Float(1.2));
                                                                ncfile.addVariableAttribute("temperature", "versionI", (Number)new Integer(1));
                                                                ncfile.addVariableAttribute("temperature", "versionS", (Number)new Short(2));
                                                                ncfile.addVariableAttribute("temperature", "versionB", (Number)new Byte(3));
                                                                ncfile.addVariableAttribute("temperature", "versionString", "1.2");
                                                                svar_len = ncfile.addDimension("svar_len", 80);
                                                                dims = new ArrayList();
                                                                dims.add(svar_len);
                                                                ncfile.addVariable("svar", DataType.CHAR, dims);
                                                                ncfile.addVariable("svar2", DataType.CHAR, dims);
                                                                names = ncfile.addDimension("names", 3);
                                                                ArrayList<Dimension> dima = new ArrayList<Dimension>();
                                                                dima.add(names);
                                                                dima.add(svar_len);
                                                                ncfile.addVariable("names", DataType.CHAR, dima);
                                                                ncfile.addVariable("names2", DataType.CHAR, dima);
                                                                ncfile.addVariable("scalar", DataType.DOUBLE, new ArrayList());
                                                                ncfile.addVariable("bvar", DataType.BYTE, "lat");
                                                                ncfile.addGlobalAttribute("yo", "face");
                                                                ncfile.addGlobalAttribute("versionD", (Number)new Double(1.2));
                                                                ncfile.addGlobalAttribute("versionF", (Number)new Float(1.2));
                                                                ncfile.addGlobalAttribute("versionI", (Number)new Integer(1));
                                                                ncfile.addGlobalAttribute("versionS", (Number)new Short(2));
                                                                ncfile.addGlobalAttribute("versionB", (Number)new Byte(3));
                                                                try {
                                                                    Array bad = Array.factory(ArrayList.class, (int[])new int[]{1});
                                                                    ncfile.addGlobalAttribute("versionC", bad);
                                                                    assert (false);
                                                                }
                                                                catch (IllegalArgumentException e) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    ncfile.create();
                                                                }
                                                                catch (IOException e) {
                                                                    System.err.println("ERROR creating file " + ncfile.getLocation() + "\n" + e);
                                                                    if ($assertionsDisabled) break block82;
                                                                    throw new AssertionError();
                                                                }
                                                            }
                                                            ArrayDouble.D2 A = new ArrayDouble.D2(latDim.getLength(), lonDim.getLength());
                                                            ima = A.getIndex();
                                                            for (i = 0; i < latDim.getLength(); ++i) {
                                                                for (j = 0; j < lonDim.getLength(); ++j) {
                                                                    A.setDouble(ima.set(i, j), (double)(i * 1000000 + j * 1000));
                                                                }
                                                            }
                                                            origin = new int[2];
                                                            try {
                                                                ncfile.write("temperature", origin, (Array)A);
                                                            }
                                                            catch (IOException e) {
                                                                System.err.println("ERROR writing file");
                                                                assert (false);
                                                            }
                                                            catch (InvalidRangeException e) {
                                                                e.printStackTrace();
                                                                if ($assertionsDisabled) break block83;
                                                                throw new AssertionError();
                                                            }
                                                        }
                                                        origin1 = new int[1];
                                                        ac = new ArrayChar.D1(svar_len.getLength());
                                                        ima = ac.getIndex();
                                                        String val = "Testing 1-2-3";
                                                        for (j = 0; j < val.length(); ++j) {
                                                            ac.setChar(ima.set(j), val.charAt(j));
                                                        }
                                                        try {
                                                            ncfile.write("svar", origin1, (Array)ac);
                                                        }
                                                        catch (IOException e) {
                                                            System.err.println("ERROR writing Achar");
                                                            assert (false);
                                                        }
                                                        catch (InvalidRangeException e) {
                                                            e.printStackTrace();
                                                            if ($assertionsDisabled) break block84;
                                                            throw new AssertionError();
                                                        }
                                                    }
                                                    ArrayByte.D1 barray = new ArrayByte.D1(latDim.getLength());
                                                    int start = -latDim.getLength() / 2;
                                                    for (j = 0; j < latDim.getLength(); ++j) {
                                                        barray.setByte(j, (byte)(start + j));
                                                    }
                                                    try {
                                                        ncfile.write("bvar", (Array)barray);
                                                    }
                                                    catch (IOException e) {
                                                        System.err.println("ERROR writing bvar");
                                                        assert (false);
                                                    }
                                                    catch (InvalidRangeException e) {
                                                        e.printStackTrace();
                                                        if ($assertionsDisabled) break block85;
                                                        throw new AssertionError();
                                                    }
                                                }
                                                try {
                                                    ac2 = new ArrayChar.D1(svar_len.getLength());
                                                    ac2.setString("Two pairs of ladies stockings!");
                                                    ncfile.write("svar2", origin1, (Array)ac2);
                                                }
                                                catch (IOException e) {
                                                    System.err.println("ERROR writing Achar2");
                                                    assert (false);
                                                }
                                                catch (InvalidRangeException e) {
                                                    e.printStackTrace();
                                                    if ($assertionsDisabled) break block86;
                                                    throw new AssertionError();
                                                }
                                            }
                                            try {
                                                ac2 = new ArrayChar.D2(names.getLength(), svar_len.getLength());
                                                ima = ac2.getIndex();
                                                ac2.setString(ima.set(0), "No pairs of ladies stockings!");
                                                ac2.setString(ima.set(1), "One pair of ladies stockings!");
                                                ac2.setString(ima.set(2), "Two pairs of ladies stockings!");
                                                ncfile.write("names", origin, (Array)ac2);
                                            }
                                            catch (IOException e) {
                                                System.err.println("ERROR writing Achar3");
                                                assert (false);
                                            }
                                            catch (InvalidRangeException e) {
                                                e.printStackTrace();
                                                if ($assertionsDisabled) break block87;
                                                throw new AssertionError();
                                            }
                                        }
                                        try {
                                            ac2 = new ArrayChar.D2(names.getLength(), svar_len.getLength());
                                            ac2.setString(0, "0 pairs of ladies stockings!");
                                            ac2.setString(1, "1 pair of ladies stockings!");
                                            ac2.setString(2, "2 pairs of ladies stockings!");
                                            ncfile.write("names2", origin, (Array)ac2);
                                        }
                                        catch (IOException e) {
                                            System.err.println("ERROR writing Achar4");
                                            assert (false);
                                        }
                                        catch (InvalidRangeException e) {
                                            e.printStackTrace();
                                            if ($assertionsDisabled) break block88;
                                            throw new AssertionError();
                                        }
                                    }
                                    try {
                                        ArrayDouble.D0 datas = new ArrayDouble.D0();
                                        datas.set(222.333);
                                        ncfile.write("scalar", (Array)datas);
                                    }
                                    catch (IOException e) {
                                        System.err.println("ERROR writing scalar");
                                        assert (false);
                                    }
                                    catch (InvalidRangeException e) {
                                        e.printStackTrace();
                                        if ($assertionsDisabled) break block89;
                                        throw new AssertionError();
                                    }
                                }
                                try {
                                    ncfile.flush();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    if ($assertionsDisabled) break block90;
                                    throw new AssertionError();
                                }
                            }
                            if (this.show) {
                                System.out.println("ncfile = " + ncfile);
                            }
                            Variable temp = ncfile.findVariable("temperature");
                            assert (null != temp);
                            tA = temp.read();
                            assert (tA.getRank() == 2);
                            ima = tA.getIndex();
                            int[] shape = tA.getShape();
                            for (i = 0; i < shape[0]; ++i) {
                                for (j = 0; j < shape[1]; ++j) {
                                    assert (tA.getDouble(ima.set(i, j)) == (double)(i * 1000000 + j * 1000));
                                }
                            }
                            int[] origin2 = new int[2];
                            int[] shape2 = new int[]{1, temp.getShape()[1]};
                            try {
                                tA = temp.read(origin2, shape2);
                            }
                            catch (InvalidRangeException e) {
                                System.err.println("ERROR reading file " + (Object)((Object)e));
                                assert (false);
                                return;
                            }
                            catch (IOException e) {
                                System.err.println("ERROR reading file");
                                assert (false);
                                return;
                            }
                            assert (tA.getRank() == 2);
                            for (j = 0; j < shape2[1]; ++j) {
                                assert (tA.getDouble(ima.set(0, j)) == (double)(j * 1000));
                            }
                            Array Areduce = tA.reduce();
                            Index ima2 = Areduce.getIndex();
                            assert (Areduce.getRank() == 1);
                            for (j = 0; j < shape2[1]; ++j) {
                                assert (Areduce.getDouble(ima2.set(j)) == (double)(j * 1000));
                            }
                            Variable c = null;
                            assert (null != (c = ncfile.findVariable("svar")));
                            try {
                                tA = c.read();
                            }
                            catch (IOException e) {
                                if ($assertionsDisabled) break block91;
                                throw new AssertionError();
                            }
                        }
                        assert (tA instanceof ArrayChar);
                        ArrayChar achar = (ArrayChar)tA;
                        String sval = achar.getString(ac.getIndex());
                        assert (sval.equals("Testing 1-2-3")) : sval;
                        Variable c2 = null;
                        assert (null != (c2 = ncfile.findVariable("svar2")));
                        try {
                            tA = c2.read();
                        }
                        catch (IOException e) {
                            if ($assertionsDisabled) break block92;
                            throw new AssertionError();
                        }
                    }
                    assert (tA instanceof ArrayChar);
                    ArrayChar ac2 = (ArrayChar)tA;
                    assert (ac2.getString().equals("Two pairs of ladies stockings!"));
                    Variable c3 = null;
                    assert (null != (c3 = ncfile.findVariable("names")));
                    try {
                        tA = c3.read();
                    }
                    catch (IOException e) {
                        if ($assertionsDisabled) break block93;
                        throw new AssertionError();
                    }
                }
                assert (tA instanceof ArrayChar);
                ArrayChar ac3 = (ArrayChar)tA;
                ima = ac3.getIndex();
                assert (ac3.getString(ima.set(0)).equals("No pairs of ladies stockings!"));
                assert (ac3.getString(ima.set(1)).equals("One pair of ladies stockings!"));
                assert (ac3.getString(ima.set(2)).equals("Two pairs of ladies stockings!"));
                Variable c4 = null;
                assert (null != (c4 = ncfile.findVariable("names2")));
                try {
                    tA = c4.read();
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block94;
                    throw new AssertionError();
                }
            }
            assert (tA instanceof ArrayChar);
            ArrayChar ac4 = (ArrayChar)tA;
            ima = ac4.getIndex();
            assert (ac4.getString(0).equals("0 pairs of ladies stockings!"));
            assert (ac4.getString(1).equals("1 pair of ladies stockings!"));
            assert (ac4.getString(2).equals("2 pairs of ladies stockings!"));
            try {
                ncfile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block95;
                throw new AssertionError();
            }
        }
        System.out.println("*****************Test Write done on " + filename);
    }

    public void utestDennisCode() throws IOException, InvalidRangeException {
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)"location");
        ArrayInt data = new ArrayInt(new int[]{4});
        Index ima = data.getIndex();
        data.setInt(ima.set(0), 1);
        data.setInt(ima.set(1), 2);
        data.setInt(ima.set(2), 3);
        data.setInt(ima.set(3), 4);
        int[] origin = new int[]{0};
        ncfile.write("v", origin, (Array)data);
    }

    public void utestDennisCode2() throws IOException, InvalidRangeException {
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)"location");
        ArrayInt.D1 data = new ArrayInt.D1(4);
        data.setInt(0, 1);
        data.setInt(1, 2);
        data.setInt(2, 3);
        data.setInt(3, 4);
        ncfile.write("v", (Array)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecordSizeBug() throws IOException, InvalidRangeException {
        Array result1;
        String filename = TestLocal.temporaryDataDir + "foo.nc";
        NetcdfFileWriteable ncWriteable = NetcdfFileWriteable.createNew((String)filename, (boolean)false);
        try {
            Dimension timeDim = ncWriteable.addUnlimitedDimension("time");
            ncWriteable.addVariable("time", DataType.INT, new Dimension[]{timeDim});
            ncWriteable.addVariableAttribute("time", "units", "hours since 1990-01-01");
            ncWriteable.create();
            Array timeData = Array.factory((DataType)DataType.INT, (int[])new int[]{1});
            int[] time_origin = new int[]{0};
            int time = 0;
            while (time < 10) {
                timeData.setInt(timeData.getIndex(), time * 12);
                time_origin[0] = time++;
                ncWriteable.write("time", time_origin, timeData);
            }
            result1 = ncWriteable.readSection("time");
            System.out.println(result1);
        }
        finally {
            ncWriteable.close();
        }
        NetcdfFile ncFile = NetcdfFile.open((String)filename);
        try {
            Array result2 = ncFile.readSection("time");
            System.out.println(result2);
            CompareNetcdf.compareData((Array)result1, (Array)result2);
        }
        finally {
            ncFile.close();
        }
    }
}

