/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;

public class TestStructureSubset
extends TestCase {
    NetcdfFile ncfile;

    protected void setUp() throws Exception {
        this.ncfile = NetcdfFile.open((String)(TestAll.testdataDir + "/station/ldm/metar/Surface_METAR_20060328_0000.nc"));
        this.ncfile.sendIospMessage((Object)"AddRecordStructure");
    }

    protected void tearDown() throws Exception {
        this.ncfile.close();
    }

    public void testReadStructureSubset() throws IOException, InvalidRangeException {
        Structure record = (Structure)this.ncfile.findVariable("record");
        assert (record != null);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add("wind_speed");
        vars.add("wind_gust");
        vars.add("report");
        Structure subset = record.select(vars);
        ArrayStructure dataAll = (ArrayStructure)subset.read();
        StructureMembers sm = dataAll.getStructureMembers();
        for (StructureMembers.Member m : sm.getMembers()) {
            Variable v = subset.findVariable(m.getName());
            assert (v != null);
            Array mdata = dataAll.extractMemberArray(m);
            assert (mdata.getShape()[0] == dataAll.getShape()[0]);
            assert (mdata.getElementType() == m.getDataType().getPrimitiveClassType());
            System.out.println(m.getName() + " shape=" + new Section(mdata.getShape()));
        }
        System.out.println("*** TestStructureSubset ok");
    }

    public void testReadStructureSection() throws IOException, InvalidRangeException {
        Structure record = (Structure)this.ncfile.findVariable("record");
        assert (record != null);
        Structure subset = (Structure)record.section(new Section("0:10"));
        assert (subset != null);
        assert (subset.getRank() == 1);
        assert (subset.getSize() == 11L);
        ArrayStructure dataAll = (ArrayStructure)subset.read(new Section("0:10"));
        assert (dataAll.getSize() == 11L);
        StructureMembers sm = dataAll.getStructureMembers();
        for (StructureMembers.Member m : sm.getMembers()) {
            Variable v = subset.findVariable(m.getName());
            assert (v != null);
            Array mdata = dataAll.extractMemberArray(m);
            assert (mdata.getShape()[0] == dataAll.getShape()[0]);
            assert (mdata.getElementType() == m.getDataType().getPrimitiveClassType());
            System.out.println(m.getName() + " shape=" + new Section(mdata.getShape()));
        }
        System.out.println("*** TestStructureSubset ok");
    }
}

