/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.TestStructureArray;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.StructurePseudo;
import ucar.nc2.TestAll;
import ucar.nc2.TestNC2;
import ucar.nc2.dataset.NetcdfDataset;

public class TestStructureArray2
extends TestCase {
    TestStructureArray test = new TestStructureArray();

    public TestStructureArray2(String name) {
        super(name);
    }

    public void testBB() throws IOException, InvalidRangeException {
        NetcdfFile ncfile = TestNC2.openFile("testWriteRecord.nc");
        ncfile.sendIospMessage((Object)"AddRecordStructure");
        Structure v = (Structure)ncfile.findVariable("record");
        assert (v != null);
        assert (v.getDataType() == DataType.STRUCTURE);
        Array data = v.read();
        assert (data instanceof ArrayStructure);
        assert (data instanceof ArrayStructureBB);
        assert (data.getElementType() == StructureData.class);
        this.test.testArrayStructure((ArrayStructure)data);
        ncfile.close();
    }

    public void testMA() throws IOException, InvalidRangeException {
        NetcdfFile ncfile = TestNC2.openFile("jan.nc");
        Dimension dim = ncfile.findDimension("time");
        assert (dim != null);
        StructurePseudo p = new StructurePseudo(ncfile, null, "Psuedo", dim);
        assert (p.getDataType() == DataType.STRUCTURE);
        Array data = p.read();
        assert (data instanceof ArrayStructure);
        assert (data instanceof ArrayStructureMA);
        assert (data.getElementType() == StructureData.class);
        this.test.testArrayStructure((ArrayStructure)data);
        ncfile.close();
    }

    public void utestBufr() throws IOException, InvalidRangeException {
        String fileIn = TestAll.testdataDir + "bufr/edition3/ecmwf/synop.bufr";
        NetcdfFile ncf = NetcdfFile.open((String)fileIn);
        System.out.println(ncf.toString());
        Structure s = (Structure)ncf.findVariable("obs");
        Array data = s.read();
        this.test.testArrayStructure((ArrayStructure)data);
        Array data2 = s.read(new Section().appendRange(1, 3));
        assert (data2.getSize() == 3L);
        this.test.testArrayStructure((ArrayStructure)data2);
        System.out.println(NCdumpW.printArray((Array)data2, (String)"testArrayStructure", null));
    }

    public void utestBufrEnhanced() throws IOException, InvalidRangeException {
        String fileIn = TestAll.testdataDir + "bufr/edition3/ecmwf/synop.bufr";
        NetcdfDataset ncf = NetcdfDataset.openDataset((String)fileIn);
        System.out.println(ncf.toString());
        Structure s = (Structure)ncf.findVariable("obs");
        Array data = s.read();
        this.test.testArrayStructure((ArrayStructure)data);
        Array data2 = s.read(new Section().appendRange(1, 3));
        assert (data2.getSize() == 3L);
        this.test.testArrayStructure((ArrayStructure)data2);
        System.out.println(NCdumpW.printArray((Array)data2, (String)"testArrayStructure", null));
    }
}

