/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.TestLocal;
import ucar.nc2.TestLocalNC2;
import ucar.nc2.Variable;

public class TestStructureArray
extends TestCase {
    NetcdfFile ncfile;

    public TestStructureArray(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.ncfile = TestLocalNC2.open(TestLocal.cdmTestDataDir + "testStructures.nc");
        this.ncfile.sendIospMessage((Object)"AddRecordStructure");
    }

    protected void tearDown() throws Exception {
        this.ncfile.close();
    }

    public void testNames() {
        List vars = this.ncfile.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            System.out.println(" " + v.getShortName() + " == " + v.getName());
        }
        Structure record = (Structure)this.ncfile.findVariable("record");
        assert (record != null);
        vars = record.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            assert (("record." + v.getShortName()).equals(v.getName()));
        }
    }

    public void testReadTop() throws IOException, InvalidRangeException {
        Variable v = this.ncfile.findVariable("record");
        assert (v != null);
        assert (v.getDataType() == DataType.STRUCTURE);
        assert (v instanceof Structure);
        assert (v.getRank() == 1);
        assert (v.getSize() == 1000L);
        Array data = v.read(new int[]{4}, new int[]{3});
        assert (data instanceof ArrayStructure);
        assert (data instanceof ArrayStructureBB);
        assert (data.getElementType() == StructureData.class);
        assert (data.getSize() == 3L) : data.getSize();
        assert (data.getRank() == 1);
    }
}

