/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayInt;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.TestLocal;
import ucar.nc2.TestLocalNC2;
import ucar.nc2.Variable;

public class TestStructure
extends TestCase {
    NetcdfFile ncfile;

    public TestStructure(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.ncfile = TestLocalNC2.openFile("testWriteRecord.nc");
        this.ncfile.sendIospMessage((Object)"AddRecordStructure");
    }

    protected void tearDown() throws Exception {
        this.ncfile.close();
    }

    public void testNames() {
        List vars = this.ncfile.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            System.out.println(" " + v.getShortName() + " == " + v.getName());
        }
        Structure record = (Structure)this.ncfile.findVariable("record");
        assert (record != null);
        vars = record.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            System.out.println(" " + v.getShortName() + " == " + v.getName());
        }
        Variable time = this.ncfile.findVariable("record.time");
        assert (time != null);
        Variable time2 = record.findVariable("time");
        assert (time2 != null);
        assert (time.equals((Object)time2));
    }

    public void testReadStructureCountBytesRead() throws IOException, InvalidRangeException {
        Structure record = (Structure)this.ncfile.findVariable("record");
        assert (record != null);
        long totalAll = 0L;
        Array dataAll = record.read();
        IndexIterator iter = dataAll.getIndexIterator();
        while (iter.hasNext()) {
            StructureData sd = (StructureData)iter.next();
            for (StructureMembers.Member m : sd.getMembers()) {
                Array data = sd.getArray(m);
                totalAll += data.getSize() * (long)m.getDataType().getSize();
            }
        }
        System.out.println("  total bytes readAll= " + totalAll);
        int numrecs = record.getShape()[0];
        long totalOne = 0L;
        for (int i = 0; i < numrecs; ++i) {
            StructureData sd = record.readStructure(i);
            for (StructureMembers.Member m : sd.getMembers()) {
                Array data = sd.getArray(m);
                totalOne += data.getSize() * (long)m.getDataType().getSize();
            }
        }
        assert (totalOne == totalAll);
        long totalIter = 0L;
        StructureDataIterator iter2 = record.getStructureIterator();
        while (iter2.hasNext()) {
            StructureData sd = iter2.next();
            for (StructureMembers.Member m : sd.getMembers()) {
                Array data = sd.getArray(m);
                totalIter += data.getSize() * (long)m.getDataType().getSize();
            }
        }
        assert (totalOne == totalIter);
        System.out.println("*** testReadStructureCountBytesRead ok");
    }

    public void testN3ReadStructureCheckValues() throws IOException, InvalidRangeException {
        Array rh;
        StructureData s;
        Structure record = (Structure)this.ncfile.findVariable("record");
        assert (record != null);
        int recnum = 0;
        Array dataAll = record.read();
        IndexIterator iter = dataAll.getIndexIterator();
        while (iter.hasNext()) {
            StructureData s2 = (StructureData)iter.next();
            Array rh2 = s2.getArray("rh");
            assert (rh2 instanceof ArrayInt.D2);
            this.checkValues(rh2, recnum);
            ++recnum;
        }
        int numrecs = record.getShape()[0];
        long totalOne = 0L;
        for (int i = 0; i < numrecs; ++i) {
            s = record.readStructure(i);
            rh = s.getArray("rh");
            assert (rh instanceof ArrayInt.D2);
            this.checkValues(rh, i);
        }
        recnum = 0;
        StructureDataIterator iter2 = record.getStructureIterator();
        while (iter2.hasNext()) {
            s = iter2.next();
            rh = s.getArray("rh");
            assert (rh instanceof ArrayInt.D2);
            this.checkValues(rh, recnum);
            ++recnum;
        }
        System.out.println("*** testN3ReadStructureCheckValues ok");
    }

    public void readBothWays(String filename) throws IOException {
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        ncfile.sendIospMessage((Object)"AddRecordStructure");
        ncfile.close();
        ncfile = NetcdfFile.open((String)filename);
        ncfile.close();
    }

    public void testReadBothWaysV3mode() throws IOException {
        this.readBothWays(TestLocal.cdmTestDataDir + "testWriteRecord.nc");
        System.out.println("*** testReadBothWaysV3mode ok");
    }

    private void checkValues(Array rh, int recnum) {
        assert (rh instanceof ArrayInt.D2) : rh.getClass().getName();
        ArrayInt.D2 rha = (ArrayInt.D2)rh;
        int[] shape = rha.getShape();
        for (int j = 0; j < shape[0]; ++j) {
            for (int k = 0; k < shape[1]; ++k) {
                int want = 20 * recnum + 4 * j + k + 1;
                int val = rha.get(j, k);
                System.out.println(" " + recnum + " " + j + " " + k + " " + want + " " + val);
                assert (want == val) : want + " " + val;
            }
        }
    }
}

